/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.util.TextOccurrencesUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.NotNullList;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolGroupContext;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCExpectedTypeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCUnresolvedReferenceRenamer
extends VariableInplaceRenamer {
    private PsiFile myFile;
    private PsiReference myReference;

    public OCUnresolvedReferenceRenamer(@Nullable PsiNamedElement elementToRename, @NotNull Editor editor, @NotNull PsiFile file, @NotNull Project project2, @NotNull PsiReference reference, @Nullable String initialName, @Nullable String oldName) {
        super(elementToRename, editor, project2, initialName, oldName);
        this.myFile = file;
        this.myReference = reference;
        this.myInitialName = initialName;
    }

    protected Collection<PsiReference> collectRefs(SearchScope referencesSearchScope) {
        final ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        final String referenceName = this.myReference.getCanonicalText();
        this.myFile.accept((PsiElementVisitor)new OCRecursiveVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                super.visitElement(element);
                for (PsiReference reference : element.getReferences()) {
                    if (!reference.getCanonicalText().equals(referenceName) || reference.resolve() != null || reference.getElement() instanceof OCDeclarator || OCElementUtil.isPartOfMacroSubstitution(reference.getElement())) continue;
                    refs.add(reference);
                }
            }
        });
        return refs;
    }

    protected void collectAdditionalElementsToRename(@NotNull List<Pair<PsiElement, TextRange>> stringUsages) {
        TextOccurrencesUtil.processUsagesInStringsAndComments((PsiElement)this.myFile, (String)this.myReference.getCanonicalText(), (boolean)true, (psiElement, textRange) -> {
            if (psiElement.getContainingFile() == this.myFile && !OCElementUtil.isPartOfMacroSubstitution(psiElement)) {
                stringUsages.add(Pair.create((Object)psiElement, (Object)textRange));
            }
            return true;
        });
    }

    public boolean performInplaceRename() {
        this.myNameSuggestions = null;
        Collection<PsiReference> refs = this.collectRefs((SearchScope)new LocalSearchScope((PsiElement)this.myFile));
        this.myEditor.putUserData(INPLACE_RENAMER, (Object)this);
        ourRenamersStack.push((Object)this);
        for (PsiReference ref : refs) {
            PsiElement element = ref.getElement();
            HashSet<String> suggestions = new HashSet<String>();
            if (element instanceof OCQualifiedExpression) {
                OCType qualifierType = ((OCQualifiedExpression)element).getQualifier().getResolvedType();
                OCSymbolGroupContext symbolContext = ((OCQualifiedExpression)element).getSymbolContext();
                ((OCQualifiedExpression)element).processTargets(null, this.getProcessor((OCExpression)element, qualifierType, symbolContext, suggestions), false, OCTokenTypes.DEREF, true, false, null, OCResolveContext.forPsi(element));
            } else {
                if (!(element instanceof OCReferenceElement) || !(element.getParent() instanceof OCReferenceExpression)) continue;
                OCSymbolGroupContext symbolContext = ((OCReferenceElement)element).getSymbolContext();
                if (symbolContext != null) {
                    OCResolveUtil.processLocalAndMemberSymbols(null, element, this.getProcessor((OCExpression)element.getParent(), null, symbolContext, suggestions));
                }
            }
            if (this.myNameSuggestions == null) {
                this.myNameSuggestions = new LinkedHashSet<String>(suggestions);
                continue;
            }
            this.myNameSuggestions.retainAll(suggestions);
        }
        NotNullList stringUsages = new NotNullList();
        this.collectAdditionalElementsToRename((List<Pair<PsiElement, TextRange>>)stringUsages);
        return this.buildTemplateAndStart(refs, (Collection)stringUsages, (PsiElement)this.myFile, this.myFile);
    }

    private Processor<OCSymbol> getProcessor(@NotNull OCExpression expression, @Nullable OCType qualifierType, @Nullable OCSymbolGroupContext symbolContext, Set<String> suggestions) {
        OCResolveContext context = OCResolveContext.forPsi(expression);
        OCType type = OCExpectedTypeUtil.getExpectedType(expression, context).resolve(context);
        return symbol -> {
            if ((symbolContext == null || symbolContext.isSuitableSymbol((OCSymbol)symbol)) && (type.isUnknown() || type.isCompatible(symbol.getResolvedType(context), context) || symbol.getResolvedType(context).isCompatible(type, context)) && OCVisibility.isVisible(symbol, expression, qualifierType, this.myProject) && this.isIdentifier(symbol.getName(), OCLanguage.getInstance())) {
                suggestions.add(symbol.getName());
            }
            return true;
        };
    }

    protected void performOnInvalidIdentifier(String newName, LinkedHashSet<String> nameSuggestions) {
        PsiElement element = this.myReference.getElement();
        this.restoreCaretOffset(element.getTextOffset());
        JBPopupFactory.getInstance().createConfirmation("Inserted identifier is not valid", "Continue editing", "Cancel", () -> {
            OCUnresolvedReferenceRenamer renamer = new OCUnresolvedReferenceRenamer(element instanceof PsiNamedElement ? (PsiNamedElement)element : null, this.myEditor, this.myFile, this.myProject, this.myReference, newName, this.myOldName);
            renamer.performInplaceRename();
        }, 0).showInBestPositionFor(this.myEditor);
    }

    public String getInitialName() {
        return this.myInitialName != null ? this.myInitialName : this.myReference.getCanonicalText();
    }

    protected String getCommandName() {
        return "Rename reference";
    }

    protected void showDialogAdvertisement(String actionId) {
    }
}

