/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.unwrap.OCUnwrapper;
import org.jetbrains.annotations.NotNull;

public class OCForUnwrapper
extends OCUnwrapper {
    public OCForUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.for", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        return e instanceof OCForStatement || e instanceof OCForeachStatement;
    }

    protected void doUnwrap(PsiElement element, OCUnwrapper.Context context) {
        boolean addNewLine = false;
        if (element instanceof OCForStatement) {
            addNewLine = this.unwrapInitializer((OCForStatement)element, context);
        }
        this.unwrapBody((OCLoopStatement)element, addNewLine, context);
        context.delete(element);
    }

    private boolean unwrapInitializer(OCForStatement forStmt, OCUnwrapper.Context context) {
        OCStatement init = forStmt.getInitializer();
        if (init != null) {
            context.extractFromBlockOrSingleStatement(init, forStmt);
            OCStatement next = init;
            while (true) {
                if (context.isWhiteSpace(next = next.getNextSibling())) {
                    context.extractWhitespace(next, forStmt);
                    continue;
                }
                if (PsiUtilCore.getElementType((PsiElement)next) != OCTokenTypes.BLOCK_COMMENT) break;
                context.extractElement(next, forStmt);
            }
            if (PsiUtilCore.getElementType((PsiElement)next) == OCTokenTypes.SEMICOLON) {
                context.extractElement(next, forStmt);
            }
            return true;
        }
        return false;
    }

    private void unwrapBody(OCLoopStatement loopStmt, boolean addNewLine, OCUnwrapper.Context context) {
        OCStatement body = loopStmt.getBody();
        if (body != null) {
            if (addNewLine && !(body instanceof OCEmptyStatement)) {
                context.addNewLineBefore(loopStmt);
            }
            context.extractFromBlockOrSingleStatement(body, loopStmt);
        }
    }
}

