/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFunctionGroupSymbol
extends OCFunctionSymbol {
    private final List<OCFunctionSymbol> myOverloads;
    private final Collection<OCSymbol> myNonDeducedOverloads;
    private final Cause myCause;

    public Collection<OCSymbol> getNonDeducedOverloads() {
        return this.myNonDeducedOverloads;
    }

    public OCFunctionGroupSymbol(@NotNull List<OCFunctionSymbol> overloads, @Nullable OCType returnType, @NotNull Cause cause, @Nullable Collection<OCSymbol> nonDeducedOverloads) {
        super(overloads.get(0).getContainingFile(), 0L, overloads.get(0).getParent(), overloads.get(0).getQualifiedName(), Collections.emptyList(), Collections.emptyList(), 0, OCSymbolAttribute.STATIC.getMask(), Collections.emptyList(), OCFunctionGroupSymbol.getFunctionType(overloads, returnType), OCFunctionGroupSymbol.getParameters(overloads), OCFunctionGroupSymbol.getSymbolKind(overloads), null);
        this.myOverloads = overloads;
        this.myCause = cause;
        this.myNonDeducedOverloads = nonDeducedOverloads;
    }

    private static List<OCDeclaratorSymbol> getParameters(List<OCFunctionSymbol> overloads) {
        return overloads.get(0).getParameterSymbols();
    }

    private static OCFunctionType getFunctionType(List<OCFunctionSymbol> overloads, @Nullable OCType returnType) {
        if (overloads.size() == 1) {
            return overloads.get(0).getType();
        }
        if (returnType == null || overloads.get(0).isCppOperator()) {
            returnType = new OCMagicType(overloads.get(0).getType().getReturnType());
        }
        return new OCFunctionType(returnType, Collections.singletonList(OCEllipsisType.instance()));
    }

    private static OCSymbolKind getSymbolKind(List<OCFunctionSymbol> overloads) {
        OCSymbolKind kind = null;
        for (OCFunctionSymbol symbol : overloads) {
            if (kind == null) {
                kind = symbol.getKind();
                continue;
            }
            if (symbol.getKind().isSame(kind)) continue;
            return OCSymbolKind.FUNCTION_PREDECLARATION;
        }
        return kind != null ? kind : OCSymbolKind.FUNCTION_PREDECLARATION;
    }

    public List<OCFunctionSymbol> getOverloads() {
        return this.myOverloads;
    }

    public Cause getCause() {
        return this.myCause;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        throw new UnsupportedOperationException("this symbol is synthetic and should not be interned");
    }

    public static enum Cause {
        Ambiguous,
        NoViable,
        Magic;

    }
}

