/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.resolve.references.OCCompositeResourceReference;
import com.jetbrains.cidr.lang.resolve.references.OCResourceCompletionProvider;
import com.jetbrains.cidr.lang.resolve.references.OCResourceReference;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeResourceCompletionProvider
extends OCResourceCompletionProvider {
    private static final Function<OCResourceCompletionProvider, String> CLASS_NAME = provider2 -> provider2.getClassName();
    private static final Function<OCResourceCompletionProvider, String> SELECTOR = provider2 -> provider2.getArgumentSelector();
    @NotNull
    private final OCResourceCompletionProvider[] myProviders;

    public CompositeResourceCompletionProvider(OCResourceCompletionProvider ... providers) {
        super(CompositeResourceCompletionProvider.className(providers), CompositeResourceCompletionProvider.argumentSelector(providers));
        this.myProviders = providers;
    }

    private static String argumentSelector(@NotNull OCResourceCompletionProvider[] providers) {
        return CompositeResourceCompletionProvider.assertSameValue(Arrays.asList(providers), SELECTOR);
    }

    private static String className(@NotNull OCResourceCompletionProvider[] providers) {
        return CompositeResourceCompletionProvider.assertSameValue(Arrays.asList(providers), CLASS_NAME);
    }

    public static <T, V> V assertSameValue(@NotNull Iterable<T> items, Function<T, V> property) {
        OCLog.LOG.assertTrue(items.iterator().hasNext());
        Object result = null;
        for (T item : items) {
            Object value = property.fun(item);
            OCLog.LOG.assertTrue(result == null || result.equals(value));
            result = value;
        }
        return (V)result;
    }

    @Override
    @Nullable
    protected OCResourceReference createReference(OCExpression expression, @Nullable PsiElement referenceElement) {
        ArrayList<OCResourceReference> references = new ArrayList<OCResourceReference>();
        for (OCResourceCompletionProvider provider2 : this.myProviders) {
            references.add(provider2.createReference(expression, referenceElement));
        }
        return new OCCompositeResourceReference(references);
    }
}

