/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCResourceFilesProvider {
    private static final ExtensionPointName<OCResourceFilesProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.resourceFilesProvider");

    @NotNull
    public static SortedMap<String, VirtualFile> getAccessibleResources(@NotNull Project project2, @NotNull VirtualFile virtualFile) {
        TreeMap<String, VirtualFile> result = new TreeMap<String, VirtualFile>();
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            result.putAll(provider2.getAccessibleResourceFiles(project2, virtualFile));
        }
        return result;
    }

    @NotNull
    public static SortedMap<String, VirtualFile> getAccessibleResources(@NotNull PsiElement element) {
        VirtualFile file = OCResourceFilesProvider.getFileFromElement(element);
        if (file != null) {
            return OCResourceFilesProvider.getAccessibleResources(element.getProject(), file);
        }
        return Collections.emptySortedMap();
    }

    public static boolean isAccessible(@NotNull Project project2, @Nullable VirtualFile from, @Nullable VirtualFile who) {
        if (from == null) {
            return false;
        }
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            if (!provider2.isAccessibleInner(project2, from, who)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAccessible(@NotNull PsiElement element, @NotNull VirtualFile file) {
        return OCResourceFilesProvider.isAccessible(element.getProject(), OCResourceFilesProvider.getFileFromElement(element), file);
    }

    @Nullable
    private static VirtualFile getFileFromElement(@NotNull PsiElement element) {
        VirtualFile elementFile = element.getContainingFile().getVirtualFile();
        if (elementFile == null) {
            elementFile = element.getContainingFile().getOriginalFile().getVirtualFile();
        }
        return elementFile;
    }

    @NotNull
    protected abstract SortedMap<String, VirtualFile> getAccessibleResourceFiles(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract boolean isAccessibleInner(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable VirtualFile var3);

    @Nullable
    public static String withoutLocalization(String fileName) {
        String locationExtension = ".lproj" + File.separator;
        int extensionIndex = fileName.lastIndexOf(locationExtension);
        if (extensionIndex <= 0) {
            return null;
        }
        int separatorIndex = fileName.lastIndexOf(File.separator, extensionIndex - 1);
        if (separatorIndex == extensionIndex - 1) {
            return null;
        }
        return fileName.substring(0, separatorIndex + 1) + fileName.substring(extensionIndex + locationExtension.length());
    }
}

