/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.v2;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.resolve.v2.ImplicitConversionSequence;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import org.jetbrains.annotations.NotNull;

public class TypeProperties {
    public static boolean isAggregateType(@NotNull OCType type) {
        if (!(type instanceof OCStructType) || ((OCStructType)type).getKind() == OCSymbolKind.ENUM) {
            return false;
        }
        OCStructSymbol symbol = ((OCStructType)type).getSymbol();
        if (symbol.hasBaseClasses()) {
            return false;
        }
        if (!symbol.processConstructors((Processor<? super OCFunctionSymbol>)new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            protected boolean accept(OCFunctionSymbol symbol) {
                return !symbol.isDefault() && !symbol.isDelete();
            }
        })) {
            return false;
        }
        return symbol.processMembers((String)null, (Processor<? super OCSymbol>)new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol s) {
                if (s.isUnnamed()) {
                    return false;
                }
                if (s instanceof OCFunctionSymbol) {
                    OCFunctionSymbol func = (OCFunctionSymbol)s;
                    return func.isVirtual();
                }
                if (s instanceof OCDeclaratorSymbol && !((OCDeclaratorSymbol)s).isFriendOrStatic()) {
                    OCVisibility vis = ((OCDeclaratorSymbol)s).getVisibility();
                    return vis != null && vis != OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC && vis != OCVisibility.PUBLIC;
                }
                return false;
            }
        });
    }

    public static boolean isEnum(@NotNull OCType type) {
        return type instanceof OCStructType && ((OCStructType)type).isEnum();
    }

    public static boolean isRecordType(@NotNull OCType type) {
        return type instanceof OCStructType && (!((OCStructType)type).isEnum() || ((OCStructType)type).isEnumClass());
    }

    public static boolean isPromotableIntegerType(@NotNull OCType type, @NotNull OCResolveContext context) {
        if (type instanceof OCIntType) {
            switch (((OCIntType)type).getCTypeId()) {
                case BOOL: 
                case SIGNED_CHAR: 
                case CHAR: 
                case CHAR16_T: 
                case CHAR32_T: 
                case WCHAR_T: 
                case SHORT: {
                    return true;
                }
            }
            return false;
        }
        if (TypeProperties.isEnum(type)) {
            return !type.isMagicInside(context) && !((OCStructType)type).getSymbol().isEnumClass();
        }
        return false;
    }

    public static boolean isIntegerLikeType(@NotNull OCType type) {
        return type instanceof OCIntType || TypeProperties.isEnum(type) && !((OCStructType)type).getSymbol().isEnumClass();
    }

    public static boolean isIntegralType(@NotNull OCType type, @NotNull OCResolveContext context) {
        return type instanceof OCIntType || !context.isCpp() && TypeProperties.isEnum(type);
    }

    public static boolean isArithmeticType(@NotNull OCType type) {
        return type instanceof OCNumericType || TypeProperties.isEnum(type);
    }

    public static boolean isSignedIntegerType(@NotNull OCType type) {
        return type instanceof OCIntType && ((OCIntType)type).isSigned() || TypeProperties.isEnum(type);
    }

    public static boolean isAnyCharacterType(@NotNull OCType type) {
        if (type instanceof OCIntType) {
            switch (((OCIntType)type).getCTypeId()) {
                case SIGNED_CHAR: 
                case CHAR: 
                case CHAR16_T: 
                case CHAR32_T: 
                case WCHAR_T: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isCharacterType(@NotNull OCType type) {
        if (type instanceof OCIntType) {
            switch (((OCIntType)type).getCTypeId()) {
                case SIGNED_CHAR: 
                case CHAR: {
                    return true;
                }
            }
        }
        return false;
    }

    public static OCType getEnumPromotionType(OCType enumType) {
        return OCIntType.INT;
    }

    public static int getTypeSize(@NotNull OCType type, @NotNull OCResolveContext context) {
        if (type instanceof OCNumericType) {
            return type.getSizeInBytes(context.getFile(), null, context.getProject());
        }
        if (TypeProperties.isEnum(type)) {
            return TypeProperties.getEnumPromotionType(type).getSizeInBytes(context.getFile(), null, context.getProject());
        }
        throw new IllegalArgumentException(type.getName());
    }

    public static boolean hasSameUnqualifiedType(OCType T1, OCType T2, @NotNull OCResolveContext context) {
        return TypeProperties.hasSameUnqualifiedTypeEx(T1, T2, context) != SameUnqualTypeResult.DIFFERENT;
    }

    public static SameUnqualTypeResult hasSameUnqualifiedTypeEx(OCType T1, OCType T2, @NotNull OCResolveContext context) {
        if (T2 != null) {
            OCTypeEqualityVisitor visitor = new OCTypeEqualityVisitor(T2, true, true, context);
            visitor.setAssumeUnknownTypesEqual(true);
            if (visitor.equal(T1)) {
                return visitor.isMagicallyEquals() ? SameUnqualTypeResult.SAME_MAGIC : SameUnqualTypeResult.SAME;
            }
        }
        return SameUnqualTypeResult.DIFFERENT;
    }

    public static boolean isIncompleteOrObjectType(@NotNull OCType type) {
        return !(type instanceof OCFunctionType);
    }

    public static boolean IsDerivedFrom(OCType Derived, OCType Base, @NotNull OCResolveContext context) {
        if (!(Derived instanceof OCStructType) || !(Base instanceof OCStructType)) {
            return false;
        }
        for (OCStructSymbol symbol : ((OCStructType)Derived).getStructs()) {
            if (!((OCStructType)Base).getSymbol().isAncestor(symbol, context)) continue;
            return true;
        }
        return false;
    }

    public static boolean canAssignObjCInterfaces(OCType LHSOPT, OCType RHSOPT, @NotNull OCResolveContext context) {
        return LHSOPT.isCompatible(RHSOPT, context);
    }

    public static boolean AreSimilarPointerTypes(OCType T1, OCType T2, @NotNull OCResolveContext context) {
        if (!(T1 instanceof OCPointerType) || !(T2 instanceof OCPointerType)) {
            return false;
        }
        OCPointerType t1Ptr = (OCPointerType)T1;
        OCPointerType t2Ptr = (OCPointerType)T2;
        if (T1.isPointerToObject() || T2.isPointerToObject()) {
            return T1.isPointerToObject() && T2.isPointerToObject();
        }
        if (t1Ptr.getClassQualifier() != null || t2Ptr.getClassQualifier() != null) {
            return t1Ptr.getClassQualifier() != null && t2Ptr.getClassQualifier() != null && TypeProperties.hasSameUnqualifiedType(t1Ptr.getClassQualifier(), t2Ptr.getClassQualifier(), context);
        }
        return true;
    }

    public static OCType getArrayDecayedType(OCArrayType Ty, @NotNull OCResolveContext context) {
        OCPointerType PtrTy = OCPointerType.to(Ty.getRefType());
        return PtrTy.cloneWithCVQualifiers(Ty.getArrayElementType().getCVQualifiers(), context.getProject());
    }

    public static boolean hasDeprecatedStringLiteralToCharPtrConversion(ImplicitConversionSequence ICS) {
        return ICS.isStandard() && ICS.Standard.DeprecatedStringLiteralToCharPtr || ICS.isUserDefined() && ICS.UserDefined.Before.DeprecatedStringLiteralToCharPtr;
    }

    public static boolean isMoreQualifiedThan(OCType type1, OCType type2) {
        return TypeProperties.isMoreQualifiedThan(type1.getCVQualifiers(), type2.getCVQualifiers());
    }

    public static boolean isMoreQualifiedThan(CVQualifiers Quals1, CVQualifiers Quals2) {
        return Quals1 != Quals2 && Quals1.isSuperset(Quals2);
    }

    public static boolean hasSimilarType(OCType T1, OCType T2, @NotNull OCResolveContext context) {
        while (TypeProperties.AreSimilarPointerTypes(T1, T2, context)) {
            T1 = ((OCPointerType)T1).getRefType();
            T2 = ((OCPointerType)T2).getRefType();
            T1 = T1.cloneWithoutCVQualifiers(context.getProject());
            T2 = T2.cloneWithoutCVQualifiers(context.getProject());
        }
        return T1.equals(T2, false, context);
    }

    public static Pair<OCType, CVQualifiers> getUnqualifiedArrayType(@NotNull OCType type, @NotNull Project project2) {
        if (!(type instanceof OCArrayType)) {
            return Pair.create((Object)type.cloneWithoutCVQualifiers(project2), (Object)((Object)type.getCVQualifiers()));
        }
        Pair<OCType, CVQualifiers> refPair = TypeProperties.getUnqualifiedArrayType(((OCArrayType)type).getRefType(), project2);
        return Pair.create((Object)OCArrayType.to((OCType)refPair.first, ((OCArrayType)type).getLengthSymbol()), (Object)((Object)type.getCVQualifiers().or((CVQualifiers)((Object)refPair.second))));
    }

    public static RefQualifier getRefQualifier(@NotNull OCType type) {
        if (type instanceof OCFunctionType) {
            if (((OCFunctionType)type).isLValueRef()) {
                return RefQualifier.RQ_LValue;
            }
            if (((OCFunctionType)type).isRValueRef()) {
                return RefQualifier.RQ_RValue;
            }
            return RefQualifier.RQ_None;
        }
        return RefQualifier.RQ_None;
    }

    public static enum RefQualifier {
        RQ_None,
        RQ_LValue,
        RQ_RValue;

    }

    static enum SameUnqualTypeResult {
        SAME,
        SAME_MAGIC,
        DIFFERENT;

    }
}

