/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.search.OCDirectInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCClassInheritorsSearch
extends QueryFactory<OCClassSymbol, SearchParameters> {
    private static final OCClassInheritorsSearch INSTANCE = new OCClassInheritorsSearch();

    private OCClassInheritorsSearch() {
    }

    @NotNull
    public static Query<OCClassSymbol> search(@NotNull OCClassDeclaration aClass) {
        Project project2 = aClass.getProject();
        return OCClassInheritorsSearch.search(aClass.getName(), aClass instanceof OCProtocol, (SearchScope)GlobalSearchScope.allScope((Project)project2), project2, aClass instanceof OCImplementation);
    }

    @NotNull
    public static Query<OCClassSymbol> search(OCClassSymbol aClass, @NotNull Project project2) {
        return OCClassInheritorsSearch.search(aClass.getName(), aClass instanceof OCProtocolSymbol, (SearchScope)GlobalSearchScope.allScope((Project)project2), project2, aClass instanceof OCImplementationSymbol);
    }

    @NotNull
    public static Query<OCClassSymbol> search(@Nullable String className, boolean isProtocol, @NotNull SearchScope scope, @NotNull Project project2, boolean myPreferImplementations) {
        return INSTANCE.createQuery(new SearchParameters(scope, className, isProtocol, project2, myPreferImplementations));
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCClassSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, @NotNull Processor<? super OCClassSymbol> consumer) {
            SearchScope scope = p.getScope();
            Project project2 = p.getProject();
            Stack names = new Stack();
            HashSet<Pair> processed = new HashSet<Pair>();
            names.push((Object)Pair.create((Object)p.getClassName(), (Object)p.isProtocol()));
            while (!names.isEmpty()) {
                ProgressManager.checkCanceled();
                Pair name2 = (Pair)names.pop();
                if (!processed.add(name2)) continue;
                Query<OCClassSymbol> search = OCDirectInheritorsSearch.search((String)name2.getFirst(), (SearchScope)GlobalSearchScope.allScope((Project)project2), project2, (Boolean)name2.getSecond(), p.isPreferImplementations());
                search.forEach(symbol -> {
                    names.push((Object)Pair.create((Object)symbol.getName(), (Object)(symbol instanceof OCProtocolSymbol)));
                    VirtualFile file = symbol.getContainingFile();
                    return file == null || !scope.contains(file) || consumer.process(symbol);
                });
            }
        }
    }

    public static class SearchParameters {
        private final SearchScope myScope;
        private final String myClassName;
        private final Project myProject;
        private final boolean myProtocol;
        private final boolean myPreferImplementations;

        public SearchParameters(@NotNull SearchScope scope, @Nullable String className, boolean protocol, @NotNull Project project2, boolean preferImplementations) {
            this.myScope = scope;
            this.myClassName = className;
            this.myProtocol = protocol;
            this.myProject = project2;
            this.myPreferImplementations = preferImplementations;
        }

        @NotNull
        public SearchScope getScope() {
            return this.myScope;
        }

        @Nullable
        public String getClassName() {
            return this.myClassName;
        }

        @NotNull
        public Project getProject() {
            return this.myProject;
        }

        public boolean isProtocol() {
            return this.myProtocol;
        }

        public boolean isPreferImplementations() {
            return this.myPreferImplementations;
        }
    }
}

