/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDirectInheritorsSearch
extends QueryFactory<OCClassSymbol, SearchParameters> {
    private static final OCDirectInheritorsSearch INSTANCE = new OCDirectInheritorsSearch();

    private OCDirectInheritorsSearch() {
    }

    @NotNull
    public static Query<OCClassSymbol> search(@NotNull OCClassDeclaration aClass) {
        Project project2 = aClass.getProject();
        return OCDirectInheritorsSearch.search(aClass.getName(), (SearchScope)GlobalSearchScope.allScope((Project)project2), project2, aClass instanceof OCProtocol, aClass instanceof OCImplementation);
    }

    @NotNull
    public static Query<OCClassSymbol> search(@Nullable String className, @NotNull SearchScope scope, @NotNull Project project2, boolean protocol, boolean preferImplementations) {
        return INSTANCE.createQuery(new SearchParameters(scope, className, protocol, project2, preferImplementations));
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultSearcher());
    }

    private static class DefaultSearcher
    extends QueryExecutorBase<OCClassSymbol, SearchParameters> {
        private DefaultSearcher() {
        }

        public void processQuery(final @NotNull SearchParameters p, final @NotNull Processor<? super OCClassSymbol> consumer) {
            final String superName = p.getClassName();
            final SearchScope scope = p.getScope();
            final boolean isProtocol = p.isProtocol();
            final boolean preferImplementations = p.isPreferImplementations();
            OCGlobalProjectSymbolsCache.processTopLevelSymbols(p.getProject(), (Processor<? super OCSymbol>)new Processor<OCSymbol>(){

                private boolean acceptsInterface(OCInterfaceSymbol symbol) {
                    VirtualFile file = symbol.getContainingFile();
                    if (file != null && scope.contains(file)) {
                        if (isProtocol) {
                            List<String> protocols = symbol.getProtocolNames();
                            for (String protocol : protocols) {
                                if (!Comparing.equal((String)superName, (String)protocol)) continue;
                                return true;
                            }
                        } else if (Comparing.equal((String)superName, (String)symbol.getSuperClassName())) {
                            return true;
                        }
                    }
                    return false;
                }

                public boolean process(OCSymbol symbol) {
                    ProgressManager.checkCanceled();
                    if (symbol instanceof OCInterfaceSymbol) {
                        if (!this.acceptsInterface((OCInterfaceSymbol)symbol)) {
                            return true;
                        }
                        if (preferImplementations) {
                            OCImplementationSymbol implSymbol = ((OCInterfaceSymbol)symbol).getImplementation(p.getProject());
                            if (implSymbol != null) {
                                consumer.process((Object)implSymbol);
                            } else {
                                consumer.process((Object)((OCClassSymbol)symbol));
                            }
                        } else {
                            consumer.process((Object)((OCClassSymbol)symbol));
                        }
                    } else if (symbol instanceof OCProtocolSymbol) {
                        List<String> protocols = ((OCProtocolSymbol)symbol).getProtocolNames();
                        for (String protocol : protocols) {
                            if (!Comparing.equal((String)superName, (String)protocol)) continue;
                            return consumer.process((Object)((OCClassSymbol)symbol));
                        }
                    }
                    return true;
                }
            }, null);
        }
    }

    public static class SearchParameters {
        private final SearchScope myScope;
        private final String myClassName;
        private final boolean isProtocol;
        private final Project myProject;
        private final boolean myPreferImplementations;

        public SearchParameters(@NotNull SearchScope scope, @Nullable String className, boolean protocol, @NotNull Project project2, boolean preferImplementations) {
            this.myScope = scope;
            this.myClassName = className;
            this.isProtocol = protocol;
            this.myProject = project2;
            this.myPreferImplementations = preferImplementations;
        }

        @NotNull
        public SearchScope getScope() {
            return this.myScope;
        }

        @Nullable
        public String getClassName() {
            return this.myClassName;
        }

        @NotNull
        public Project getProject() {
            return this.myProject;
        }

        public boolean isProtocol() {
            return this.isProtocol;
        }

        public boolean isPreferImplementations() {
            return this.myPreferImplementations;
        }
    }
}

