/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.names.OCDumbTypeNameVisitor;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class OCDirectStructInheritorsSearch
extends QueryFactory<OCStructSymbol, OCStructInheritorsSearch.SearchParameters> {
    public static final OCDirectStructInheritorsSearch INSTANCE = new OCDirectStructInheritorsSearch();

    private OCDirectStructInheritorsSearch() {
    }

    public static Query<OCStructSymbol> search(OCStructLike struct) {
        Project project2 = struct.getProject();
        return OCDirectStructInheritorsSearch.search(((OCStructSymbol)struct.getSymbol()).getResolvedQualifiedName(OCResolveContext.forPsi(struct)), GlobalSearchScope.allScope((Project)project2), struct.getContainingFile(), project2);
    }

    public static Query<OCStructSymbol> search(OCQualifiedName structName, GlobalSearchScope scope, @NotNull PsiFile file, Project project2) {
        return INSTANCE.createQuery(new OCStructInheritorsSearch.SearchParameters(scope, structName, file, project2));
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultSearcher());
    }

    private static class DefaultSearcher
    extends QueryExecutorBase<OCStructSymbol, OCStructInheritorsSearch.SearchParameters> {
        private DefaultSearcher() {
        }

        public void processQuery(final @NotNull OCStructInheritorsSearch.SearchParameters p, final @NotNull Processor<? super OCStructSymbol> consumer) {
            final OCQualifiedName superName = p.getStructName();
            if (superName == null || superName.getName() == null) {
                return;
            }
            final GlobalSearchScope scope = p.getScope();
            final HashSet aliases = new HashSet();
            Processor<String> processor2 = new Processor<String>(){

                public boolean process(String s) {
                    if (!aliases.contains(s)) {
                        aliases.add(s);
                        OCGlobalProjectSymbolsCache.processAliasNamesForType(p.getProject(), s, this);
                    }
                    return true;
                }
            };
            processor2.process((Object)superName.getName());
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(p.getProject(), (Processor<? super OCSymbol>)new Processor<OCSymbol>(){

                private boolean acceptsStruct(OCStructSymbol symbol) {
                    if (scope.accept(symbol.getContainingFile())) {
                        OCResolveContext context = OCResolveContext.forSymbol(symbol, p.getProject());
                        for (OCType base : symbol.getBaseCppClasses(context)) {
                            OCType resolvedType;
                            ProgressManager.checkCanceled();
                            if (!aliases.contains(new OCDumbTypeNameVisitor(0, p.getProject()).getName(base)) || !((resolvedType = base.resolve(context)) instanceof OCStructType)) continue;
                            for (OCStructSymbol resolvedBase : ((OCStructType)resolvedType).getStructs()) {
                                if (!Comparing.equal((Object)superName, (Object)resolvedBase.getResolvedQualifiedName(context))) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                }

                public boolean process(OCSymbol symbol) {
                    ProgressManager.checkCanceled();
                    if (symbol instanceof OCStructSymbol) {
                        if (!this.acceptsStruct((OCStructSymbol)symbol)) {
                            return true;
                        }
                        consumer.process((Object)((OCStructSymbol)symbol));
                    }
                    return true;
                }
            }, null);
        }
    }
}

