/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.QueryFactory;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.search.OCDirectStructInheritorsSearch;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class OCStructInheritorsSearch
extends QueryFactory<OCStructSymbol, SearchParameters> {
    public static final OCStructInheritorsSearch INSTANCE = new OCStructInheritorsSearch();

    private OCStructInheritorsSearch() {
    }

    public static Query<OCStructSymbol> search(OCStruct struct) {
        Project project2 = struct.getProject();
        OCStructSymbol symbol = (OCStructSymbol)struct.getSymbol();
        OCQualifiedName structName = symbol != null ? symbol.getResolvedQualifiedName(OCResolveContext.forPsi(struct)) : null;
        return OCStructInheritorsSearch.search(structName, GlobalSearchScope.allScope((Project)project2), struct.getContainingFile(), project2);
    }

    public static Query<OCStructSymbol> search(OCStructSymbol struct, @NotNull PsiElement context) {
        Project project2 = context.getProject();
        OCQualifiedName structName = struct.getResolvedQualifiedName(OCResolveContext.forPsi(context));
        return OCStructInheritorsSearch.search(structName, GlobalSearchScope.allScope((Project)project2), context.getContainingFile(), project2);
    }

    public static Query<OCStructSymbol> search(OCQualifiedName structName, GlobalSearchScope scope, PsiFile file, Project project2) {
        return INSTANCE.createQuery(new SearchParameters(scope, structName, file, project2));
    }

    static {
        INSTANCE.registerExecutor((QueryExecutor)new DefaultExecutor());
    }

    private static class DefaultExecutor
    extends QueryExecutorBase<OCStructSymbol, SearchParameters> {
        private DefaultExecutor() {
        }

        public void processQuery(@NotNull SearchParameters p, @NotNull Processor<? super OCStructSymbol> consumer) {
            GlobalSearchScope scope = p.getScope();
            Project project2 = p.getProject();
            Stack names = new Stack();
            HashSet<OCQualifiedName> processed = new HashSet<OCQualifiedName>();
            HashSet accepted = new HashSet();
            names.push((Object)p.getStructName());
            while (!names.isEmpty()) {
                ProgressManager.checkCanceled();
                OCQualifiedName name2 = (OCQualifiedName)names.pop();
                if (!processed.add(name2)) continue;
                Query<OCStructSymbol> search = OCDirectStructInheritorsSearch.search(name2, GlobalSearchScope.allScope((Project)project2), p.getFile(), project2);
                search.forEach(symbol -> {
                    OCQualifiedName qualifiedName = symbol.getResolvedQualifiedName(OCResolveContext.forSymbol(symbol, project2));
                    names.push((Object)qualifiedName);
                    return !scope.contains(symbol.getContainingFile()) || !accepted.add(qualifiedName) || consumer.process(symbol);
                });
            }
        }
    }

    public static class SearchParameters {
        private GlobalSearchScope myScope;
        private OCQualifiedName myStructName;
        private PsiFile myFile;
        private Project myProject;

        public SearchParameters(GlobalSearchScope scope, OCQualifiedName structName, PsiFile file, Project project2) {
            this.myScope = scope;
            this.myStructName = structName;
            this.myFile = file;
            this.myProject = project2;
        }

        public GlobalSearchScope getScope() {
            return this.myScope;
        }

        public OCQualifiedName getStructName() {
            return this.myStructName;
        }

        public PsiFile getFile() {
            return this.myFile;
        }

        public Project getProject() {
            return this.myProject;
        }
    }
}

