/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSearchScope {
    private static final NotNullLazyKey<GlobalSearchScope, Project> PROJECT_SOURCES_SCOPE = NotNullLazyKey.create((String)"PROJECT_SOURCES_SCOPE", project2 -> OCSearchScope.createProjectSourcesScope(project2));
    private static final Key<CachedValue<Collection<VirtualFile>>> EXPLICIT_PROJECT_SOURCE_FILES = Key.create((String)"EXPLICIT_PROJECT_SOURCE_FILES");
    private static final Key<CachedValue<Map<VirtualFile, Boolean>>> IMPORTED_HEADERS = Key.create((String)"IMPORTED_HEADERS");

    @NotNull
    public static GlobalSearchScope getGotoSymbolScope(@NotNull Project project2, boolean includeNonProjectFiles) {
        return includeNonProjectFiles ? ProjectScope.getAllScope((Project)project2) : OCSearchScope.getProjectSourcesScope(project2);
    }

    @NotNull
    public static GlobalSearchScope getProjectSourcesScope(@NotNull Project project2) {
        return (GlobalSearchScope)PROJECT_SOURCES_SCOPE.getValue((UserDataHolder)project2);
    }

    @NotNull
    private static DelegatingGlobalSearchScope createProjectSourcesScope(final @NotNull Project project2) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        final Condition sourceCondition = file -> OCSearchScope.isInExplicitProjectSources(index, file);
        final Condition projectCondition = file -> OCSearchScope.isInProject(index, file);
        return new DelegatingGlobalSearchScope(ProjectScope.getContentScope((Project)project2)){

            @NotNull
            public String getDisplayName() {
                return "Project Source Files";
            }

            public boolean contains(@NotNull VirtualFile file) {
                ApplicationManager.getApplication().assertReadAccessAllowed();
                return sourceCondition.value((Object)file) || projectCondition.value((Object)file) && OCSearchScope.isImportedFromSource(project2, file, (Condition<VirtualFile>)sourceCondition);
            }
        };
    }

    private static boolean isImportedFromSource(@NotNull Project project2, @NotNull VirtualFile header, @NotNull Condition<VirtualFile> sourceCondition) {
        Map<VirtualFile, Boolean> cache = OCSearchScope.getImportedHeadersCache(project2);
        if (!cache.containsKey(header)) {
            boolean imported = SymbolTableProvider.isSourceFile(header) && !OCImportGraph.processIncludingFiles(project2, header, false, true, (Processor<? super VirtualFile>)((Processor)includer -> !sourceCondition.value(includer)));
            cache.put(header, imported);
        }
        return cache.get(header);
    }

    @NotNull
    private static Map<VirtualFile, Boolean> getImportedHeadersCache(@NotNull Project project2) {
        return (Map)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, IMPORTED_HEADERS, () -> {
            ConcurrentHashMap result = new ConcurrentHashMap();
            return CachedValueProvider.Result.create(result, OCSearchScope.getProjectSourcesCacheDependencies(project2, false));
        }, false);
    }

    @NotNull
    public static Collection<VirtualFile> getExplicitlySpecifiedProjectSourceFiles(@NotNull Project project2) {
        return (Collection)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, EXPLICIT_PROJECT_SOURCE_FILES, () -> {
            THashSet result = new THashSet();
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project2);
            final ProjectFileIndex index = rootManager.getFileIndex();
            final FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
            for (VirtualFile eachSourceRoot : rootManager.getContentSourceRoots()) {
                ProgressManager.checkCanceled();
                VfsUtilCore.visitChildrenRecursively((VirtualFile)eachSourceRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (Set)result){
                    final /* synthetic */ Set val$result;
                    {
                        this.val$result = set;
                        super(x0);
                    }

                    public boolean visitFile(@NotNull VirtualFile each) {
                        ProgressManager.checkCanceled();
                        if (index.isExcluded(each) || typeRegistry.isFileIgnored(each)) {
                            return false;
                        }
                        if (!each.isDirectory() && OCSearchScope.isInExplicitProjectSources(index, each)) {
                            this.val$result.add(each);
                        }
                        return true;
                    }
                });
            }
            return CachedValueProvider.Result.create(Collections.unmodifiableCollection(result), OCSearchScope.getProjectSourcesCacheDependencies(project2, true));
        }, false);
    }

    @NotNull
    public static Collection<?> getProjectSourcesCacheDependencies(@NotNull Project project2, boolean explicitRootsOnly) {
        List baseDeps = Arrays.asList(VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootManager.getInstance((Project)project2));
        return explicitRootsOnly ? baseDeps : ContainerUtil.append(baseDeps, (Object[])new ModificationTracker[]{OCImportGraph.getModificationTracker(project2)});
    }

    @Contract(value="null, _->false")
    public static boolean isInProjectSources(@Nullable OCSymbol symbol, Project project2) {
        return OCSearchScope.isInProjectSources((PsiElement)OCSearchScope.getContainingFile(symbol, project2));
    }

    @Nullable
    private static PsiFile getContainingFile(@Nullable OCSymbol symbol, @NotNull Project project2) {
        if (symbol == null || symbol.getKind() == OCSymbolKind.BUILTIN_SYMBOL) {
            return null;
        }
        return symbol.getContainingPsiFile(project2);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSources(@Nullable PsiElement element) {
        return element != null && OCSearchScope.isInProjectSources(element.getProject(), OCSearchScope.getVirtualFile(element));
    }

    public static boolean isInProjectSources(@NotNull Project project2, @Nullable VirtualFile file) {
        return file != null && OCSearchScope.getProjectSourcesScope(project2).contains(file);
    }

    private static boolean isInExplicitProjectSources(@NotNull ProjectFileIndex index, @NotNull VirtualFile file) {
        return index.isInSourceContent(file) && !index.isInLibrary(file);
    }

    private static boolean isInProject(@NotNull ProjectFileIndex index, @NotNull VirtualFile file) {
        return index.isInContent(file) && !index.isInLibrary(file);
    }

    public static boolean isInProjectNonSources(@NotNull Project project2, @Nullable VirtualFile file) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        return file != null && OCSearchScope.isInProject(index, file) && !OCSearchScope.getProjectSourcesScope(project2).contains(file);
    }

    @Contract(value="null->false")
    public static boolean isInProjectSourcesOrLibraries(@Nullable PsiElement element) {
        return element != null && OCSearchScope.isInProjectSourcesOrLibraries(element.getProject(), OCSearchScope.getVirtualFile(element));
    }

    public static boolean isInProjectSourcesOrLibraries(@NotNull Project project2, @Nullable VirtualFile file) {
        if (file == null) {
            return false;
        }
        return OCSearchScope.getProjectSourcesScope(project2).contains(file) || ProjectScope.getLibrariesScope((Project)project2).contains(file);
    }

    @Contract(value="null, _->false")
    public static boolean isInLibraries(@Nullable OCSymbol symbol, @NotNull Project project2) {
        return OCSearchScope.isInLibraries((PsiElement)OCSearchScope.getContainingFile(symbol, project2));
    }

    @Contract(value="null->false")
    public static boolean isInLibraries(@Nullable PsiElement element) {
        VirtualFile file = OCSearchScope.getVirtualFile(element);
        if (file == null) {
            return false;
        }
        return OCSearchScope.isInLibraries(file, element.getProject());
    }

    public static boolean isInLibraries(@NotNull VirtualFile file, @NotNull Project project2) {
        return ProjectScope.getLibrariesScope((Project)project2).contains(file);
    }

    @Nullable
    private static VirtualFile getVirtualFile(@Nullable PsiElement element) {
        if (element == null || !element.isValid()) {
            return null;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PsiCodeFragment) {
            PsiElement context = file.getContext();
            file = context == null ? null : context.getContainingFile();
        }
        return file == null ? null : OCInclusionContextUtil.getVirtualFile(file);
    }
}

