/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.search.OCClassInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesDialog;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesOptions;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFindUsagesHandler
extends FindUsagesHandler {
    private boolean myDeleteMode;

    public OCFindUsagesHandler(@NotNull PsiElement psiElement) {
        super(psiElement);
    }

    public OCFindUsagesHandler(@NotNull PsiElement psiElement, boolean isDeleteMode) {
        super(psiElement);
        this.myDeleteMode = isDeleteMode;
    }

    private String getActionName() {
        return this.myDeleteMode ? "delete" : "find usages of";
    }

    @NotNull
    public PsiElement[] getPrimaryElements() {
        OCSymbol symbol;
        PsiElement element = this.getPsiElement();
        if (element instanceof OCFile) {
            symbol = ((OCFile)element).getSameNamedClass();
        } else if (element instanceof OCSymbolDeclarator) {
            symbol = ((OCSymbolDeclarator)element).getSymbol();
        } else {
            return super.getPrimaryElements();
        }
        if (symbol instanceof OCCompilerGeneratedConstructorSymbol) {
            symbol = ((OCCompilerGeneratedConstructorSymbol)symbol).getStruct();
        }
        HashSet<PsiElement> result = new HashSet<PsiElement>();
        CommonProcessors.CollectProcessor psiCollector = new CommonProcessors.CollectProcessor(result);
        Processor collector = symbol1 -> {
            this.processSymbol((OCSymbol)symbol1, (Processor<PsiElement>)psiCollector);
            return true;
        };
        if (symbol instanceof OCSymbolWithParent) {
            OCSearchUtil.Ancestor ancestor = OCSearchUtil.findSomeAncestor((OCSymbolWithParent)symbol, this.getProject());
            if (ancestor != null) {
                OCCompilationContext context = OCCompilationContext.create(element);
                String subject = symbol.getKindLowercase(context);
                String message = symbol.getNameWithKindUppercase(context) + " overrides " + subject + " in " + ancestor.getSymbol().getParent().getNameWithKindLowercase(context) + (ancestor.isOutOfProject() ? " which is out of project" : "");
                if (this.myDeleteMode && ancestor.isOutOfProject()) {
                    int code = Messages.showYesNoDialog((Project)this.getProject(), (String)(message + ". Do you want to proceed the refactoring?"), (String)"Warning", (Icon)Messages.getQuestionIcon());
                    if (code != 0) {
                        return PsiElement.EMPTY_ARRAY;
                    }
                } else {
                    int code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoDialog((String)(message + "\n\nDo you want to " + this.getActionName() + " the base " + subject + "?"), (String)"Method search", (Icon)Messages.getQuestionIcon());
                    if (code == 0) {
                        OCSearchUtil.processMemberAncestors((OCSymbolWithParent)symbol, (Processor<? super OCSymbolWithParent>)collector, !this.myDeleteMode, this.getProject());
                    } else {
                        result.add(element);
                    }
                }
            } else {
                result.add(element);
            }
            if (this.myDeleteMode) {
                boolean isGeneratedFromProperty = false;
                if (symbol instanceof OCMethodSymbol) {
                    OCMethodSymbol method = (OCMethodSymbol)symbol;
                    OCMethodSymbol associatedSymbol = method.getAssociatedSymbol(this.getProject());
                    boolean bl = isGeneratedFromProperty = associatedSymbol != null && associatedSymbol.getGeneratedFromProperty() != null;
                }
                if (!isGeneratedFromProperty) {
                    OCSearchUtil.processMembersHierarchy((OCSymbolWithParent)symbol, collector, false, true, true, this.getProject());
                }
            }
        } else if (symbol != null) {
            if (this.myDeleteMode) {
                if (element instanceof OCMethodSelectorPart) {
                    psiCollector.process((Object)element);
                } else {
                    symbol.processSameSymbols((Processor<OCSymbol>)collector, this.getProject());
                }
            } else {
                psiCollector.process((Object)element);
            }
        }
        if (symbol != null) {
            Project project2 = element.getProject();
            symbol = symbol.getDefinitionSymbol(project2);
            if (this.myDeleteMode && symbol instanceof OCClassSymbol) {
                result.clear();
                String categoryName = ((OCClassSymbol)symbol).getCategoryName();
                symbol.processSameSymbols((Processor<OCSymbol>)((Processor)curSymbol -> {
                    if (categoryName != null && !categoryName.equals(((OCClassSymbol)curSymbol).getCategoryName())) {
                        return true;
                    }
                    OCFile file = curSymbol.getContainingOCFile(project2);
                    if (file != null && curSymbol.equals(file.getSameNamedClass()) && !file.hasExtraTopLevelDefinitions()) {
                        result.add(file);
                    } else if (!result.contains(file)) {
                        this.processSymbol((OCSymbol)curSymbol, (Processor<PsiElement>)psiCollector);
                    }
                    return true;
                }), project2);
            }
            if (result.isEmpty()) {
                result.add(element);
            }
            return PsiUtilCore.toPsiElementArray(result);
        }
        return super.getPrimaryElements();
    }

    void processSecondaryElements(AssociatedElementProcessor processor2) {
        block15: {
            Object symbol;
            PsiElement element;
            block14: {
                element = this.getPsiElement();
                if (!(element instanceof OCSymbolDeclarator)) {
                    return;
                }
                symbol = ((OCSymbolDeclarator)element).getSymbol();
                if (!(symbol instanceof OCInstanceVariableSymbol)) break block14;
                OCPropertySymbol property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty(element.getProject());
                if (property == null) break block15;
                if (((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar(this.getProject())) {
                    processor2.process(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol, this.getProject()));
                }
                if (processor2.proceedProperty(property)) {
                    this.processSymbol(property, processor2);
                    this.processSynthesizes(property, processor2);
                }
                break block15;
            }
            if (symbol instanceof OCPropertySymbol) {
                OCInstanceVariableSymbol ivar = ((OCPropertySymbol)symbol).getAssociatedIvar(element.getProject());
                if (ivar != null) {
                    if (ivar.isClang4ImplicitIvar(this.getProject())) {
                        processor2.process(new OCSymbolHolderVirtualPsiElement(ivar, this.getProject()));
                    } else if (processor2.proceedIvar(ivar)) {
                        this.processSymbol(ivar, processor2);
                    }
                }
                this.processSynthesizes((OCPropertySymbol)symbol, processor2);
            } else if (symbol instanceof OCClassSymbol && processor2.proceedDerivedClasses()) {
                for (OCClassSymbol clazz : OCClassInheritorsSearch.search((OCClassSymbol)symbol, this.getProject()).findAll()) {
                    this.processSymbol(clazz, processor2);
                }
            } else if (symbol instanceof OCStructSymbol && ((OCElement)element).getContainingOCFile().isCpp() && processor2.proceedDerivedClasses()) {
                for (OCStructSymbol struct : OCStructInheritorsSearch.search((OCStructSymbol)symbol, element).findAll()) {
                    this.processSymbol(struct, processor2);
                }
            }
        }
    }

    private void processSynthesizes(OCPropertySymbol symbol, Processor<PsiElement> processor2) {
        if (this.myDeleteMode) {
            symbol.processSynthesizes((Processor<? super OCSynthesizeSymbol>)((Processor)symbol1 -> {
                this.processSymbol((OCSymbol)symbol1, processor2);
                return true;
            }), this.getProject());
        }
    }

    @NotNull
    public PsiElement[] getSecondaryElements() {
        final HashSet result = new HashSet();
        if (this.myDeleteMode) {
            this.processSecondaryElements(new AssociatedElementProcessor(){

                @Override
                public boolean proceedProperty(OCPropertySymbol property) {
                    String message = "Do you want to " + OCFindUsagesHandler.this.getActionName() + " the " + property.getNameWithKindLowercase(OCCompilationContext.create(OCFindUsagesHandler.this.getPsiElement())) + " as well?";
                    return ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((String)message, (String)"Properties search", (Icon)Messages.getQuestionIcon()) == 0;
                }

                @Override
                public boolean proceedIvar(OCInstanceVariableSymbol ivar) {
                    if (ivar.getGeneratedFromProperty() != null) {
                        return true;
                    }
                    String message = "Do you want to " + OCFindUsagesHandler.this.getActionName() + " the " + ivar.getNameWithKindLowercase(OCCompilationContext.create(OCFindUsagesHandler.this.getPsiElement())) + " as well?";
                    return ApplicationManager.getApplication().isUnitTestMode() || Messages.showYesNoDialog((String)message, (String)"Instance variables search", (Icon)Messages.getQuestionIcon()) == 0;
                }

                @Override
                public boolean proceedDerivedClasses() {
                    return false;
                }

                public boolean process(PsiElement element) {
                    result.add(element);
                    return true;
                }
            });
        } else {
            final OCFindUsagesOptions options = OCFindUsagesOptions.getInstance(this.getProject());
            this.processSecondaryElements(new AssociatedElementProcessor(){

                @Override
                public boolean proceedProperty(OCPropertySymbol property) {
                    return options.isSearchForProperties;
                }

                @Override
                public boolean proceedIvar(OCInstanceVariableSymbol ivar) {
                    return options.isSearchForIvars;
                }

                @Override
                public boolean proceedDerivedClasses() {
                    return options.isSearchForDerivedClasses;
                }

                public boolean process(PsiElement element) {
                    result.add(element);
                    return true;
                }
            });
        }
        return PsiUtilCore.toPsiElementArray(result);
    }

    private void processSymbol(OCSymbol symbol, Processor<PsiElement> processor2) {
        if (symbol == null) {
            return;
        }
        PsiElement def = symbol.locateDefinition(this.getProject());
        if (def != null) {
            processor2.process((Object)def);
        }
    }

    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        Object symbol;
        if (isSingleFile) {
            return false;
        }
        return !(psiElement instanceof OCSymbolDeclarator) || (symbol = ((OCSymbolDeclarator)psiElement).getSymbol()) == null || !symbol.getKind().isLocal();
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        return OCFindUsagesOptions.getInstance(this.getProject());
    }

    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        return new OCFindUsagesDialog(this.getPsiElement(), this.getProject(), OCFindUsagesOptions.getInstance(this.getProject()), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
    }

    static interface AssociatedElementProcessor
    extends Processor<PsiElement> {
        public boolean proceedProperty(OCPropertySymbol var1);

        public boolean proceedIvar(OCInstanceVariableSymbol var1);

        public boolean proceedDerivedClasses();
    }
}

