/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesHandler;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesProvider;
import org.jetbrains.annotations.NotNull;

public class OCFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement element) {
        return element.isValid() && new OCFindUsagesProvider().canFindUsagesFor(element);
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (this.canFindUsages(element)) {
            return new OCFindUsagesHandler(OCFindUsagesHandlerFactory.toDeclaration(element)){};
        }
        return null;
    }

    private static PsiElement toDeclaration(PsiElement element) {
        if (!(element instanceof OCSymbolDeclarator)) {
            return element;
        }
        Object symbol = ((OCSymbolDeclarator)element).getSymbol();
        if (symbol == null || !symbol.isDefinition()) {
            return element;
        }
        Project project2 = element.getProject();
        if ((symbol = symbol.getAssociatedSymbol(project2)) == null) {
            return element;
        }
        PsiElement declaration = symbol.locateDefinition(project2);
        return declaration != null ? declaration : element;
    }
}

