/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.ide.fileTemplates.impl.FileTemplateHighlighter;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.valueEditors.TextFieldValueEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.settings.NamingConvention;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamingConventionConfigurable
implements CodeStyleConfigurable {
    @NotNull
    private final CodeStyleSettings mySettings;
    private final EditorTextField myHeaderGuardStylePattern = new HeaderGuardEditorTextField("${PROJECT_NAME}_${FILE_NAME}_${EXT}");
    private final NamingConventionGroup myNamespacesGroup = new NamingConventionGroup();
    private final NamingConventionGroup myMacrosGroup = new NamingConventionGroup();
    private final NamingConventionGroup myClassesAndStructsGroup = new NamingConventionGroup();
    private final NamingConventionGroup myEnumsGroup = new NamingConventionGroup();
    private final NamingConventionGroup myEnumeratorsGroup = new NamingConventionGroup();
    private final NamingConventionGroup myTypedefsGroup = new NamingConventionGroup();
    private final NamingConventionGroup myUnionsGroup = new NamingConventionGroup();
    private final NamingConventionGroup myMethodsGroup = new NamingConventionGroup();
    private final NamingConventionGroup myFieldsGroup = new NamingConventionGroup();
    private final NamingConventionGroup myGlobalFunctionsGroup = new NamingConventionGroup();
    private final NamingConventionGroup myGlobalVariablesGroup = new NamingConventionGroup();
    private final NamingConventionGroup myParametersGroup = new NamingConventionGroup();
    private final NamingConventionGroup myLocalVariablesGroup = new NamingConventionGroup();
    private final GridLayoutManager myGridLayoutManager = new GridLayoutManager(15, 5);

    public OCNamingConventionConfigurable(@NotNull CodeStyleSettings settings) {
        this.mySettings = settings;
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return "Naming Convention";
    }

    @Nullable
    public JComponent createComponent() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBorder(JBUI.Borders.empty((int)5));
        this.myGridLayoutManager.setVGap(1);
        this.myGridLayoutManager.setHGap(1);
        JPanel panel = new JPanel((LayoutManager)this.myGridLayoutManager);
        int row = 0;
        this.addHeaderGuardComponent(panel, row++);
        OCNamingConventionConfigurable.addRow("Namespaces", this.myNamespacesGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Macros", this.myMacrosGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Classes And Structs", this.myClassesAndStructsGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Enums", this.myEnumsGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Enumerators", this.myEnumeratorsGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Typedefs", this.myTypedefsGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Unions", this.myUnionsGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Methods", this.myMethodsGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Fields", this.myFieldsGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Global Functions", this.myGlobalFunctionsGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Global Variables", this.myGlobalVariablesGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Parameters", this.myParametersGroup, panel, row++);
        OCNamingConventionConfigurable.addRow("Local Variables", this.myLocalVariablesGroup, panel, row++);
        panel.add((Component)new Spacer(), OCNamingConventionConfigurable.getVSpacerGridConstraints(row, 0));
        mainPanel.add(panel);
        return mainPanel;
    }

    public boolean isModified() {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)this.mySettings.getCustomSettings(OCCodeStyleSettings.class);
        return !this.myHeaderGuardStylePattern.getText().equals(ocSettings.HEADER_GUARD_STYLE_PATTERN) || this.isModified(this.myNamespacesGroup, ocSettings.NAMESPACES_NAMING_CONVENTION) || this.isModified(this.myMacrosGroup, ocSettings.MACROS_NAMING_CONVENTION) || this.isModified(this.myClassesAndStructsGroup, ocSettings.CLASSES_AND_STRUCTS_NAMING_CONVENTION) || this.isModified(this.myEnumsGroup, ocSettings.ENUMS_NAMING_CONVENTION) || this.isModified(this.myEnumeratorsGroup, ocSettings.ENUMERATORS_NAMING_CONVENTION) || this.isModified(this.myTypedefsGroup, ocSettings.TYPEDEFS_NAMING_CONVENTION) || this.isModified(this.myUnionsGroup, ocSettings.UNIONS_NAMING_CONVENTION) || this.isModified(this.myMethodsGroup, ocSettings.METHODS_NAMING_CONVENTION) || this.isModified(this.myFieldsGroup, ocSettings.FIELDS_NAMING_CONVENTION) || this.isModified(this.myGlobalFunctionsGroup, ocSettings.GLOBAL_FUNCTIONS_NAMING_CONVENTION) || this.isModified(this.myGlobalVariablesGroup, ocSettings.GLOBAL_VARIABLES_NAMING_CONVENTION) || this.isModified(this.myParametersGroup, ocSettings.PARAMETERS_NAMING_CONVENTION) || this.isModified(this.myLocalVariablesGroup, ocSettings.LOCAL_VARIABLES_NAMING_CONVENTION);
    }

    public void apply() throws ConfigurationException {
        this.apply(this.mySettings);
    }

    public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        ocSettings.HEADER_GUARD_STYLE_PATTERN = this.myHeaderGuardStylePattern.getText();
        OCNamingConventionConfigurable.apply(this.myNamespacesGroup, ocSettings.NAMESPACES_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myMacrosGroup, ocSettings.MACROS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myClassesAndStructsGroup, ocSettings.CLASSES_AND_STRUCTS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myEnumsGroup, ocSettings.ENUMS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myEnumeratorsGroup, ocSettings.ENUMERATORS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myTypedefsGroup, ocSettings.TYPEDEFS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myUnionsGroup, ocSettings.UNIONS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myMethodsGroup, ocSettings.METHODS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myFieldsGroup, ocSettings.FIELDS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myGlobalFunctionsGroup, ocSettings.GLOBAL_FUNCTIONS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myGlobalVariablesGroup, ocSettings.GLOBAL_VARIABLES_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myParametersGroup, ocSettings.PARAMETERS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.apply(this.myLocalVariablesGroup, ocSettings.LOCAL_VARIABLES_NAMING_CONVENTION);
        OCInspectionUtil.restartCodeAnalyzer();
    }

    public void reset(@NotNull CodeStyleSettings settings) {
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        this.myHeaderGuardStylePattern.setText(ocSettings.HEADER_GUARD_STYLE_PATTERN);
        OCNamingConventionConfigurable.reset(this.myNamespacesGroup, ocSettings.NAMESPACES_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myMacrosGroup, ocSettings.MACROS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myClassesAndStructsGroup, ocSettings.CLASSES_AND_STRUCTS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myEnumsGroup, ocSettings.ENUMS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myEnumeratorsGroup, ocSettings.ENUMERATORS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myTypedefsGroup, ocSettings.TYPEDEFS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myUnionsGroup, ocSettings.UNIONS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myMethodsGroup, ocSettings.METHODS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myFieldsGroup, ocSettings.FIELDS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myGlobalFunctionsGroup, ocSettings.GLOBAL_FUNCTIONS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myGlobalVariablesGroup, ocSettings.GLOBAL_VARIABLES_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myParametersGroup, ocSettings.PARAMETERS_NAMING_CONVENTION);
        OCNamingConventionConfigurable.reset(this.myLocalVariablesGroup, ocSettings.LOCAL_VARIABLES_NAMING_CONVENTION);
    }

    private void addHeaderGuardComponent(JPanel panel, int row) {
        panel.add((Component)new JLabel("Header Guard"), OCNamingConventionConfigurable.getFixedGridConstraints(row, 0, 1));
        panel.add((Component)this.myHeaderGuardStylePattern, OCNamingConventionConfigurable.getFixedGridConstraints(row, 1, 3));
        panel.add((Component)ContextHelpLabel.create((String)"You can use predefined variables such as:<br><b>${PROJECT_NAME}</b>, <b>${PROJECT_REL_PATH}</b>, <b>${FILE_NAME}</b>, <b>${EXT}</b> and <b>${UUID}</b>.<br>All the predefined variables from the <i>Editor/File and Code Templates</i> (<i>Files tab</i>)<br>are also available (e.g. <b>${USER}</b>, <b>${DATE}</b>, etc.)"), OCNamingConventionConfigurable.getFixedGridConstraints(row, 4, 1));
    }

    private static void addRow(@NotNull String name2, @NotNull NamingConventionGroup group, @NotNull JPanel panel, int row) {
        panel.add((Component)new JLabel(name2), OCNamingConventionConfigurable.getFixedGridConstraints(row, 0, 1));
        panel.add((Component)group.myPrefixTextField, OCNamingConventionConfigurable.getFixedGridConstraints(row, 1, 1));
        panel.add((Component)group.myNamingConventionStyleComboBox, OCNamingConventionConfigurable.getFixedGridConstraints(row, 2, 1));
        panel.add((Component)group.mySuffixTextField, OCNamingConventionConfigurable.getFixedGridConstraints(row, 3, 1));
        panel.add((Component)new Spacer(), OCNamingConventionConfigurable.getHSpacerGridConstraints(row, 4));
    }

    @NotNull
    private static GridConstraints getHSpacerGridConstraints(int row, int column) {
        return new GridConstraints(row, column, 1, 1, 0, 0, 4, 0, null, null, null);
    }

    @NotNull
    private static GridConstraints getVSpacerGridConstraints(int row, int column) {
        return new GridConstraints(row, column, 1, 1, 0, 0, 0, 4, null, null, null);
    }

    @NotNull
    private static GridConstraints getFixedGridConstraints(int row, int column, int colSpan) {
        return new GridConstraints(row, column, 1, colSpan, 8, 0, 0, 0, null, null, null);
    }

    private boolean isModified(@NotNull NamingConventionGroup group, @NotNull NamingConvention namingConvention) {
        return this.isModified((JTextField)group.myPrefixTextField, namingConvention.getCustomPrefix()) || this.isModified(group.myNamingConventionStyleComboBox, (Object)namingConvention.getNamingConventionStyle()) || this.isModified((JTextField)group.mySuffixTextField, namingConvention.getCustomSuffix());
    }

    private static void apply(@NotNull NamingConventionGroup group, @NotNull NamingConvention result) {
        result.setCustomPrefix((String)group.myPrefixTextFieldEditor.getValue());
        result.setNamingConventionStyle((NamingConventionStyle)((Object)Objects.requireNonNull(group.myNamingConventionStyleComboBox.getSelectedItem())));
        result.setCustomSuffix((String)group.mySuffixTextFieldEditor.getValue());
    }

    private static void reset(@NotNull NamingConventionGroup group, @NotNull NamingConvention namingConvention) {
        group.myPrefixTextField.setText(namingConvention.getCustomPrefix());
        group.myNamingConventionStyleComboBox.setSelectedItem((Object)namingConvention.getNamingConventionStyle());
        group.mySuffixTextField.setText(namingConvention.getCustomSuffix());
    }

    private static ComboBox<NamingConventionStyle> createNamingConventionComboBox() {
        return new ComboBox((Object[])new NamingConventionStyle[]{NamingConventionStyle.LOWERCASE, NamingConventionStyle.CAMEL_CASE, NamingConventionStyle.PASCAL_CASE, NamingConventionStyle.SNAKE_CASE, NamingConventionStyle.UPPER_SNAKE_CASE, NamingConventionStyle.SCREAMING_SNAKE_CASE, NamingConventionStyle.UPPERCASE});
    }

    private class HeaderGuardEditorTextField
    extends EditorTextField {
        HeaderGuardEditorTextField(String text) {
            super(text);
        }

        protected EditorEx createEditor() {
            EditorEx editor = super.createEditor();
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            editor.setHighlighter((EditorHighlighter)new LayeredLexerEditorHighlighter((SyntaxHighlighter)new FileTemplateHighlighter(), scheme));
            this.setPreferredWidth(((NamingConventionGroup)((OCNamingConventionConfigurable)OCNamingConventionConfigurable.this).myNamespacesGroup).myPrefixTextField.getPreferredSize().width + ((NamingConventionGroup)((OCNamingConventionConfigurable)OCNamingConventionConfigurable.this).myNamespacesGroup).myNamingConventionStyleComboBox.getPreferredSize().width + ((NamingConventionGroup)((OCNamingConventionConfigurable)OCNamingConventionConfigurable.this).myNamespacesGroup).mySuffixTextField.getPreferredSize().width + OCNamingConventionConfigurable.this.myGridLayoutManager.getHGap() * 2);
            return editor;
        }
    }

    private static class NamingConventionGroup {
        private final JBTextField myPrefixTextField = new JBTextField(12);
        private final ComboBox<NamingConventionStyle> myNamingConventionStyleComboBox;
        private final JBTextField mySuffixTextField;
        private final TextFieldEditor myPrefixTextFieldEditor;
        private final TextFieldEditor mySuffixTextFieldEditor;

        NamingConventionGroup() {
            this.myPrefixTextField.getEmptyText().setText("Custom Prefix");
            this.myNamingConventionStyleComboBox = OCNamingConventionConfigurable.createNamingConventionComboBox();
            this.mySuffixTextField = new JBTextField(12);
            this.mySuffixTextField.getEmptyText().setText("Custom Suffix");
            this.myPrefixTextFieldEditor = new TextFieldEditor(true, (JTextField)this.myPrefixTextField, "Prefix", "");
            this.mySuffixTextFieldEditor = new TextFieldEditor(false, (JTextField)this.mySuffixTextField, "Suffix", "");
        }
    }

    static class TextFieldEditor
    extends TextFieldValueEditor<String> {
        private final boolean myIsPrefix;

        TextFieldEditor(boolean isPrefix, @NotNull JTextField field, @Nullable String valueName, @NotNull String defaultValue) {
            super(field, valueName, (Object)defaultValue);
            this.myIsPrefix = isPrefix;
        }

        @NotNull
        public String parseValue(@Nullable String text) throws InvalidDataException {
            if (text == null) {
                return (String)this.getDefaultValue();
            }
            if (text.isEmpty()) {
                return text;
            }
            if (this.myIsPrefix && !Character.isLetter(text.charAt(0)) && text.charAt(0) != '_') {
                throw new InvalidDataException("Prefix must start with letter or '_' symbol");
            }
            if (!text.chars().allMatch(c -> Character.isLetterOrDigit(c) || c == 95)) {
                throw new InvalidDataException(this.getValueName() + " must contain only letters or digits or '_' symbols");
            }
            return text;
        }

        public String valueToString(@NotNull String value) {
            return value;
        }

        public boolean isValid(@NotNull String value) {
            return this.validateInput(value);
        }

        private boolean validateInput(@NotNull String value) {
            return value.trim().chars().allMatch(c -> c == 95 || (this.myIsPrefix ? Character.isLetter(c) : Character.isLetterOrDigit(c)));
        }
    }
}

