/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.NamingConvention;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.formatter.OCPredefinedCodeStyleBase;
import org.jetbrains.annotations.NotNull;

public class OCGNUCodeStyle
extends OCPredefinedCodeStyleBase {
    public OCGNUCodeStyle() {
        super("GNU", "gnu");
    }

    @Override
    public void apply(@NotNull CodeStyleSettings settings) {
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)OCLanguage.getInstance());
        CommonCodeStyleSettings.IndentOptions indentOptions = commonSettings.getIndentOptions();
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        this.applyNamingConvention(ocSettings);
        commonSettings.KEEP_LINE_BREAKS = true;
        commonSettings.KEEP_BLANK_LINES_IN_DECLARATIONS = 1;
        commonSettings.KEEP_BLANK_LINES_IN_CODE = 1;
        commonSettings.KEEP_BLANK_LINES_BEFORE_RBRACE = 1;
        commonSettings.BLANK_LINES_BEFORE_IMPORTS = 0;
        commonSettings.BLANK_LINES_AFTER_IMPORTS = 0;
        commonSettings.BLANK_LINES_AROUND_CLASS = 0;
        commonSettings.BLANK_LINES_AROUND_FIELD = 0;
        commonSettings.BLANK_LINES_AROUND_METHOD = 0;
        commonSettings.BLANK_LINES_BEFORE_METHOD_BODY = 0;
        commonSettings.BLANK_LINES_AROUND_FIELD_IN_INTERFACE = 0;
        commonSettings.BLANK_LINES_AROUND_METHOD_IN_INTERFACE = 0;
        commonSettings.SPECIAL_ELSE_IF_TREATMENT = true;
        commonSettings.ALIGN_MULTILINE_BINARY_OPERATION = true;
        commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
        commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
        commonSettings.SPACE_AFTER_COMMA = true;
        commonSettings.SPACE_BEFORE_COMMA = false;
        commonSettings.SPACE_WITHIN_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_BRACKETS = false;
        commonSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_METHOD_PARENTHESES = true;
        commonSettings.SPACE_WITHIN_SWITCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_CATCH_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_TRY_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_FOR_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_WHILE_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_IF_PARENTHESES = false;
        commonSettings.SPACE_WITHIN_METHOD_PARENTHESES = false;
        commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_CATCH_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_TRY_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_FOR_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_WHILE_PARENTHESES = true;
        commonSettings.SPACE_BEFORE_IF_PARENTHESES = true;
        commonSettings.FINALLY_ON_NEW_LINE = true;
        commonSettings.CATCH_ON_NEW_LINE = true;
        commonSettings.WHILE_ON_NEW_LINE = true;
        commonSettings.ELSE_ON_NEW_LINE = true;
        commonSettings.FOR_BRACE_FORCE = 0;
        commonSettings.WHILE_BRACE_FORCE = 0;
        commonSettings.DOWHILE_BRACE_FORCE = 0;
        commonSettings.IF_BRACE_FORCE = 0;
        commonSettings.SPACE_BEFORE_SYNCHRONIZED_LBRACE = true;
        commonSettings.SPACE_BEFORE_FINALLY_LBRACE = true;
        commonSettings.SPACE_BEFORE_CATCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_TRY_LBRACE = true;
        commonSettings.SPACE_BEFORE_SWITCH_LBRACE = true;
        commonSettings.SPACE_BEFORE_DO_LBRACE = true;
        commonSettings.SPACE_BEFORE_FOR_LBRACE = true;
        commonSettings.SPACE_BEFORE_WHILE_LBRACE = true;
        commonSettings.SPACE_BEFORE_ELSE_LBRACE = true;
        commonSettings.SPACE_BEFORE_IF_LBRACE = true;
        commonSettings.SPACE_BEFORE_METHOD_LBRACE = true;
        commonSettings.SPACE_BEFORE_CLASS_LBRACE = true;
        commonSettings.BINARY_OPERATION_WRAP = 1;
        commonSettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE = true;
        commonSettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE = true;
        commonSettings.ASSIGNMENT_WRAP = 0;
        ocSettings.INDENT_CLASS_MEMBERS = 2;
        ocSettings.INDENT_VISIBILITY_KEYWORDS = 1;
        commonSettings.BRACE_STYLE = 4;
        commonSettings.CLASS_BRACE_STYLE = 1;
        ocSettings.BLOCK_BRACE_PLACEMENT = 2;
        ocSettings.METHOD_BRACE_PLACEMENT = 2;
        ocSettings.FUNCTION_BRACE_PLACEMENT = 2;
        ocSettings.NAMESPACE_BRACE_PLACEMENT = 2;
        ocSettings.FUNCTION_NON_TOP_AFTER_RETURN_TYPE_WRAP = 1;
        ocSettings.FUNCTION_TOP_AFTER_RETURN_TYPE_WRAP = 1;
        ocSettings.FUNCTION_PARAMETERS_WRAP = 0;
        ocSettings.FUNCTION_PARAMETERS_ALIGN_MULTILINE = true;
        ocSettings.FUNCTION_PARAMETERS_NEW_LINE_AFTER_LPAR = false;
        ocSettings.FUNCTION_PARAMETERS_NEW_LINE_BEFORE_RPAR = false;
        ocSettings.FUNCTION_PARAMETERS_COMMA_ON_NEXT_LINE = false;
        ocSettings.FUNCTION_CALL_ARGUMENTS_WRAP = 0;
        ocSettings.FUNCTION_CALL_ARGUMENTS_ALIGN_MULTILINE = true;
        ocSettings.FUNCTION_CALL_ARGUMENTS_NEW_LINE_AFTER_LPAR = false;
        ocSettings.FUNCTION_CALL_ARGUMENTS_NEW_LINE_BEFORE_RPAR = false;
        ocSettings.FUNCTION_CALL_ARGUMENTS_COMMA_ON_NEXT_LINE = false;
        ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_WRAP = 0;
        ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_NEW_LINE_AFTER_COLON = 0;
        ocSettings.SPACE_WITHIN_FUNCTION_DECLARATION_PARENTHESES = false;
        ocSettings.SPACE_WITHIN_EMPTY_FUNCTION_DECLARATION_PARENTHESES = false;
        ocSettings.SPACE_WITHIN_FUNCTION_CALL_PARENTHESES = false;
        ocSettings.SPACE_AFTER_INIT_LIST_COLON = true;
        ocSettings.SPACE_BEFORE_POINTER_IN_DECLARATION = true;
        ocSettings.SPACE_AFTER_POINTER_IN_DECLARATION = false;
        ocSettings.SPACE_AFTER_REFERENCE_IN_RVALUE = false;
        ocSettings.SPACE_AROUND_PM_OPERATORS = false;
        assert (indentOptions != null);
        indentOptions.INDENT_SIZE = 2;
        indentOptions.CONTINUATION_INDENT_SIZE = 4;
        indentOptions.TAB_SIZE = 4;
        indentOptions.KEEP_INDENTS_ON_EMPTY_LINES = false;
        super.apply(settings);
    }

    protected void applyNamingConvention(@NotNull OCCodeStyleSettings settings) {
        settings.HEADER_GUARD_STYLE_PATTERN = "_${FILE_NAME}_${EXT}_";
        settings.NAMESPACES_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.MACROS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SCREAMING_SNAKE_CASE, "");
        settings.CLASSES_AND_STRUCTS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.ENUMS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.ENUMERATORS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.TYPEDEFS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.UNIONS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.METHODS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.FIELDS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.GLOBAL_FUNCTIONS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.GLOBAL_VARIABLES_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.PARAMETERS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.LOCAL_VARIABLES_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
    }
}

