/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings.formatter;

import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.settings.NamingConvention;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.formatter.OCGoogleCodeStyle;
import org.jetbrains.annotations.NotNull;

public class OCLLVMCodeStyle
extends OCGoogleCodeStyle {
    public OCLLVMCodeStyle() {
        super("LLVM", "llvm");
    }

    public OCLLVMCodeStyle(@NotNull String name2, @NotNull String id) {
        super(name2, id);
    }

    @Override
    protected void customize(@NotNull CodeStyleSettings settings) {
        super.customize(settings);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)OCLanguage.getInstance());
        OCCodeStyleSettings ocSettings = (OCCodeStyleSettings)settings.getCustomSettings(OCCodeStyleSettings.class);
        OCLLVMCodeStyle.applyNamingConvention(ocSettings);
        commonSettings.KEEP_CONTROL_STATEMENT_IN_ONE_LINE = false;
        commonSettings.INDENT_CASE_FROM_SWITCH = false;
        ocSettings.INDENT_VISIBILITY_KEYWORDS = 0;
        ocSettings.TEMPLATE_DECLARATION_FUNCTION_WRAP = 1;
        ocSettings.TEMPLATE_DECLARATION_STRUCT_WRAP = 1;
        ocSettings.CLASS_CONSTRUCTOR_INIT_LIST_WRAP = 1;
        ocSettings.SPACE_BEFORE_PROTOCOLS_BRACKETS = true;
    }

    private static void applyNamingConvention(@NotNull OCCodeStyleSettings settings) {
        settings.HEADER_GUARD_STYLE_PATTERN = "${PROJECT_NAME}_${PROJECT_REL_PATH}_${FILE_NAME}_${EXT}";
        settings.NAMESPACES_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SNAKE_CASE, "");
        settings.MACROS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.SCREAMING_SNAKE_CASE, "");
        settings.CLASSES_AND_STRUCTS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.PASCAL_CASE, "");
        settings.ENUMS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.PASCAL_CASE, "");
        settings.ENUMERATORS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.PASCAL_CASE, "");
        settings.TYPEDEFS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.PASCAL_CASE, "");
        settings.UNIONS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.PASCAL_CASE, "");
        settings.METHODS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
        settings.FIELDS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.PASCAL_CASE, "");
        settings.GLOBAL_FUNCTIONS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.CAMEL_CASE, "");
        settings.GLOBAL_VARIABLES_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.PASCAL_CASE, "");
        settings.PARAMETERS_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.PASCAL_CASE, "");
        settings.LOCAL_VARIABLES_NAMING_CONVENTION = new NamingConvention("", NamingConventionStyle.PASCAL_CASE, "");
    }
}

