/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ForeignLeafType;
import com.intellij.lang.NodeStructure;
import com.intellij.lang.TokenWrapper;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolAttribute;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuilderDriverBase<T, FILE extends PsiFile> {
    private static final String LOG_UNRESOLVED_SYMBOLS_PROPERTY = "appCode.LogUnresolvedSymbols";
    protected static final boolean LOG_UNRESOLVED_SYMBOLS = Comparing.equal((String)System.getProperty("appCode.LogUnresolvedSymbols"), (String)"true");
    public static final NamedNodeStructure<ASTNode> AST_NAMED_NODE_STRUCTURE = new NamedNodeStructure<ASTNode>(){

        public int getStartOffset(@NotNull ASTNode node) {
            return node.getStartOffset();
        }

        public int getEndOffset(@NotNull ASTNode node) {
            return node.getTextRange().getEndOffset();
        }

        public IElementType getTokenType(@NotNull ASTNode node) {
            return node.getElementType();
        }

        @Override
        public String getNodeText(ASTNode node) {
            return node.getText();
        }
    };
    @NotNull
    protected final OCInclusionContext context;
    protected final String text;
    protected final FlyweightCapableTreeStructure<T> structure;
    protected final NodeStructure<T> nodeStructure;
    protected final Processor<OCSymbol> builder;
    protected final Project project;
    protected final OCLanguageKind myLanguageKind;
    protected final VirtualFile myVirtualFile;

    protected int offset(@NotNull T node) {
        return this.nodeStructure.getStartOffset(node);
    }

    @Nullable
    protected T getChildByType(@NotNull T parent, @NotNull IElementType type) {
        for (T child : this.getChildren(parent)) {
            if (this.type(child) != type) continue;
            return child;
        }
        return null;
    }

    @NotNull
    protected List<T> getChildrenByType(@NotNull T parent, @NotNull IElementType elementType) {
        ArrayList result = ContainerUtil.newArrayList();
        for (T child : this.getChildren(parent)) {
            if (this.type(child) != elementType) continue;
            result.add(child);
        }
        return result;
    }

    protected BuilderDriverBase(@NotNull OCInclusionContext context, @Nullable String text, @NotNull FlyweightCapableTreeStructure<T> structure, @NotNull NodeStructure<T> nodeStructure, @NotNull Processor<OCSymbol> builder, @Nullable VirtualFile virtualFile, @NotNull Project project2) {
        this.context = context;
        this.text = text;
        this.structure = structure;
        this.nodeStructure = nodeStructure;
        this.builder = builder;
        this.project = project2;
        this.myLanguageKind = context.getLanguageKind();
        this.myVirtualFile = virtualFile;
    }

    @NotNull
    protected Iterable<T> getChildren(@NotNull T node) {
        final Ref childrenRef = Ref.create(null);
        final int count = this.structure.getChildren(node, childrenRef);
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int idx = 0;

                    @Override
                    public boolean hasNext() {
                        return !childrenRef.isNull() && this.idx < count;
                    }

                    @Override
                    public T next() {
                        ProgressManager.checkCanceled();
                        return ((Object[])childrenRef.get())[this.idx++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @NotNull
    protected IElementType type(@NotNull T child) {
        IElementType type = this.nodeStructure.getTokenType(child);
        if (type instanceof ForeignLeafType) {
            type = ((ForeignLeafType)type).getDelegate();
        }
        return type;
    }

    @NotNull
    protected String nodeText(@NotNull T node) {
        String text = this.nodeText(node, null, false);
        assert (text != null);
        return text;
    }

    @Nullable
    protected String nodeText(@NotNull T node, @Nullable StringBuilder acc, boolean withDirectives) {
        IElementType unwrappedType = this.type(node);
        IElementType tt = this.nodeStructure.getTokenType(node);
        if (!withDirectives && (OCElementTypes.DIRECTIVES.contains(unwrappedType) || OCElementTypes.MACRO_CALL == unwrappedType)) {
            return "";
        }
        if (OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(unwrappedType)) {
            if (acc != null) {
                acc.append(" ");
            }
            return " ";
        }
        if (tt instanceof ForeignLeafType) {
            String value = ((ForeignLeafType)tt).getValue();
            if (acc != null) {
                acc.append(value);
            }
            return value;
        }
        if (node instanceof ForeignLeafPsiElement) {
            String value = ((ForeignLeafPsiElement)node).getText();
            if (acc != null) {
                acc.append(value);
            }
            return value;
        }
        if (tt instanceof TokenWrapper) {
            if (this.text != null) {
                return this.text.substring(this.nodeStructure.getStartOffset(node), this.nodeStructure.getEndOffset(node));
            }
            return ((NamedNodeStructure)this.nodeStructure).getNodeText(node);
        }
        List children = ContainerUtil.collect(this.getChildren(node).iterator());
        if (children.size() == 1) {
            return this.nodeText(children.get(0), acc, withDirectives);
        }
        if (children.size() > 1) {
            boolean needReturnString = false;
            if (acc == null) {
                needReturnString = true;
                acc = new StringBuilder();
            }
            for (Object child : children) {
                this.nodeText(child, acc, withDirectives);
            }
            return needReturnString ? acc.toString() : null;
        }
        String value = this.text != null ? this.text.substring(this.nodeStructure.getStartOffset(node), this.nodeStructure.getEndOffset(node)) : ((NamedNodeStructure)this.nodeStructure).getNodeText(node);
        if (acc != null) {
            acc.append(value);
        }
        return value;
    }

    public static class DeclarationContext<T> {
        private OCSymbolKind declaratorType;
        protected Object parent;
        private int lambdaParameterIndex = -1;
        private OCLambdaExpressionSymbol lambda;
        protected OCSymbolWithQualifiedName myParentSymbol;
        private OCVisibility visibility;
        protected boolean isDeclarationWithoutDeclarators;
        protected boolean isDeclarationWithoutType;
        protected boolean isStructuredBindingDeclaration = false;
        protected boolean isDeductionGuide = false;
        protected T myStructuredBindingInitializer = null;
        protected int myDeclaratorIndex = -1;
        private boolean isBaseClause;
        private boolean isTemplateValueParameter;
        private boolean isLambdaInitCapture;
        private List<String> attributes;
        private PsiElement localContext;
        protected T myKRParamterList;
        protected T myDeductionGuideTypeElement;
        private ASTNode forCollection;
        private Stack<List<Pair<OCSymbolReference, Long>>> referencesInDeclaration = new Stack();
        private Stack<T> declarations = new Stack();
        private List<T> myTemplateParameters = new ArrayList<T>();
        private boolean myIsTemplateSymbol;
        private boolean myInsideTemplateArguments;
        private boolean mySpecialization;
        private boolean myAssumeNonNull;
        private int myModifiers = 0;

        public DeclarationContext(OCSymbolKind declaratorType, Object parent, OCSymbolWithQualifiedName parentSymbol, OCVisibility visibility, PsiElement localContext, boolean assumeNonNull) {
            this.declaratorType = declaratorType;
            this.parent = parent;
            this.myParentSymbol = parentSymbol;
            this.visibility = visibility;
            this.localContext = localContext;
            this.myAssumeNonNull = assumeNonNull;
        }

        public DeclarationContext(OCSymbolKind declaratorType) {
            this.declaratorType = declaratorType;
        }

        public DeclarationContext() {
        }

        public OCSymbolKind getDeclaratorType() {
            return this.declaratorType;
        }

        public void setDeclaratorType(OCSymbolKind declaratorType) {
            this.declaratorType = declaratorType;
        }

        public Object getParent() {
            return this.parent;
        }

        public OCSymbolWithQualifiedName getParentSymbol() {
            return this.myParentSymbol;
        }

        public OCVisibility getVisibility() {
            return this.isFriend() ? OCVisibility.HACK_MORE_VISIBLE_THAN_PUBLIC : this.visibility;
        }

        public boolean isFriend() {
            return this.hasModifier(OCSymbolAttribute.FRIEND);
        }

        public boolean isVirtual() {
            return this.hasModifier(OCSymbolAttribute.VIRTUAL);
        }

        public boolean isConstexpr() {
            return this.hasModifier(OCSymbolAttribute.CONSTEXPR);
        }

        public boolean isBaseClause() {
            return this.isBaseClause;
        }

        public void setBaseClause(boolean isBaseClause) {
            this.isBaseClause = isBaseClause;
        }

        public boolean isTemplateValueParameter() {
            return this.isTemplateValueParameter;
        }

        public void setTemplateValueParameter(boolean isTemplateValueParameter) {
            this.isTemplateValueParameter = isTemplateValueParameter;
        }

        public void addModifier(@NotNull OCSymbolAttribute modifier) {
            this.myModifiers |= modifier.getMask();
        }

        int getModifiers() {
            return this.myModifiers;
        }

        public boolean hasModifier(@NotNull OCSymbolAttribute modifier) {
            return (this.myModifiers & modifier.getMask()) != 0;
        }

        public List<String> getAttributes() {
            return this.attributes;
        }

        public void addAttributes(List<String> attributes) {
            if (this.attributes == null) {
                this.attributes = attributes;
            } else {
                this.attributes.addAll(attributes);
            }
        }

        public PsiElement getLocalContext() {
            return this.localContext;
        }

        public void setLocalContext(@Nullable PsiElement localContext) {
            this.localContext = localContext;
        }

        public List<T> getTemplateParameters() {
            return this.myTemplateParameters;
        }

        public void setDeclarationWithoutDeclarators(boolean declarationWithoutDeclarators) {
            this.isDeclarationWithoutDeclarators = declarationWithoutDeclarators;
        }

        public void setDeclarationWithoutType(boolean declarationWithoutType) {
            this.isDeclarationWithoutType = declarationWithoutType;
        }

        public void setStructuredBindingDeclaration(boolean structuredBindingDeclaration) {
            this.isStructuredBindingDeclaration = structuredBindingDeclaration;
        }

        public void setStructuredBindingInitializer(@Nullable T node) {
            this.myStructuredBindingInitializer = node;
        }

        public void setDeductionGuide(boolean deductionGuide) {
            this.isDeductionGuide = deductionGuide;
        }

        public void setDeclaratorIndex(int declaratorIndex) {
            this.myDeclaratorIndex = declaratorIndex;
        }

        public ASTNode getForCollection() {
            return this.forCollection;
        }

        public void setForCollection(ASTNode forCollection) {
            this.forCollection = forCollection;
        }

        @NotNull
        public List<Pair<OCSymbolReference, Long>> getReferencesInDeclaration() {
            return (List)this.referencesInDeclaration.peek();
        }

        public void addSymbolReference(@NotNull Pair<OCSymbolReference, Long> reference) {
            if (!this.referencesInDeclaration.isEmpty()) {
                ((List)this.referencesInDeclaration.peek()).add(reference);
            }
        }

        public void pushDeclaration(T declaration) {
            this.declarations.push(declaration);
            this.referencesInDeclaration.push(new ArrayList());
        }

        public void popDeclaration() {
            this.referencesInDeclaration.pop();
            this.declarations.pop();
        }

        public T getCurrentDeclaration() {
            if (this.declarations.isEmpty()) {
                return null;
            }
            return (T)this.declarations.peek();
        }

        public boolean isTemplateSymbol() {
            return this.myIsTemplateSymbol;
        }

        public void setTemplateSymbol(boolean templateSymbol) {
            this.myIsTemplateSymbol = templateSymbol;
        }

        public boolean isInsideTemplateArguments() {
            return this.myInsideTemplateArguments;
        }

        public void setInsideTemplateArguments(boolean insideTemplateArguments) {
            this.myInsideTemplateArguments = insideTemplateArguments;
        }

        public boolean isSpecialization() {
            return this.mySpecialization;
        }

        public void setSpecialization(boolean classSpecialization) {
            this.mySpecialization = classSpecialization;
        }

        public boolean isAssumeNonNull() {
            return this.myAssumeNonNull;
        }

        public void setAssumeNonNull(boolean assumeNonNull) {
            this.myAssumeNonNull = assumeNonNull;
        }

        @Nullable
        public OCLambdaExpressionSymbol getLambda() {
            return this.lambda;
        }

        public void setLambda(OCLambdaExpressionSymbol lambda2) {
            this.lambda = lambda2;
        }

        public int getLambdaParameterIndex() {
            return this.lambdaParameterIndex;
        }

        public void setLambdaParameterIndex(int lambdaParameterIndex) {
            this.lambdaParameterIndex = lambdaParameterIndex;
        }

        public boolean isLambdaInitCapture() {
            return this.isLambdaInitCapture;
        }

        public void setLambdaInitCapture(boolean lambdaInitCapture) {
            this.isLambdaInitCapture = lambdaInitCapture;
        }
    }

    public static interface NamedNodeStructure<T>
    extends NodeStructure<T> {
        public String getNodeText(T var1);
    }
}

