/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAttributes {
    public static final String ATTRIBUTE_UNUSED = "unused";
    public static final String ATTRIBUTE_USED = "used";
    public static final String ATTRIBUTE_IBOUTLET = "iboutlet";
    public static final String ATTRIBUTE_IBOUTLET_COLLECTION = "iboutletcollection";
    public static final String ATTRIBUTE_IBACTION = "ibaction";
    public static final String ATTRIBUTE_RETURNS_RETAINED = "ns_returns_retained";
    public static final String ATTRIBUTE_OVERLOADABLE = "overloadable";
    public static final String ATTRIBUTE_DEPRECATED = "deprecated";
    public static final String ATTRIBUTE_UNAVAILABLE = "unavailable";
    public static final String ATTRIBUTE_TRANSPARENT_UNION = "transparent_union";
    public static final String ATTRIBUTE_SWIFT_NAME = "swift_name";
    public static final String ATTRIBUTE_SWIFT_WRAPPER = "swift_wrapper";
    public static final String ATTRIBUTE_UNUSED_MACRO = "__unused";
    public static final String ATTRIBUTE_MIN_IOS_VERSION = "__min_ios_version";
    public static final String ATTRIBUTE_MIN_MACOS_VERSION = "__min_macos_version";
    public static final String ATTRIBUTE_RETURNS_RETAINED_MACRO = "NS_RETURNS_RETAINED";
    public static final String ATTRIBUTE_MODE = "mode";

    public static boolean hasAttribute(@NotNull Collection<String> attributes, @NotNull String attribute) {
        return attributes.contains(attribute) || attributes.contains(OCAttributes.wrapWithUnderscores(attribute));
    }

    @Nullable
    public static String getAttributeParameter(@NotNull Collection<String> attributes, @NotNull String attribute) {
        String plainAttributePrefix = OCAttributes.attributeParameterPrefix(attribute);
        String underscoredAttributePrefix = OCAttributes.attributeParameterPrefix(OCAttributes.wrapWithUnderscores(attribute));
        for (String curAttribute : attributes) {
            if (curAttribute.startsWith(plainAttributePrefix)) {
                return curAttribute.substring(plainAttributePrefix.length());
            }
            if (!curAttribute.startsWith(underscoredAttributePrefix)) continue;
            return curAttribute.substring(underscoredAttributePrefix.length());
        }
        return null;
    }

    @NotNull
    public static String attributeParameterPrefix(@NotNull String attribute) {
        return attribute + '#';
    }

    @NotNull
    public static String wrapWithUnderscores(@NotNull String attribute) {
        if (StringUtil.startsWithChar((CharSequence)attribute, (char)'_')) {
            return attribute;
        }
        return "__" + attribute + "__";
    }

    @NotNull
    public static String trimUnderscores(@NotNull String attribute) {
        if (attribute.length() <= 4 || !attribute.startsWith("__") || !attribute.endsWith("__")) {
            return attribute;
        }
        return attribute.substring(2, attribute.length() - 2);
    }
}

