/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedNameWithArguments
extends OCQualifiedName {
    @NotNull
    private List<OCTypeArgument> myArguments;

    public OCQualifiedNameWithArguments(@Nullable OCQualifiedName qualifier, @Nullable String name2, @NotNull List<OCTypeArgument> arguments) {
        super(qualifier, name2);
        this.myArguments = arguments;
    }

    public OCQualifiedNameWithArguments() {
    }

    public OCQualifiedNameWithArguments(@NotNull OCQualifiedName qualifiedName, @NotNull List<OCTypeArgument> arguments) {
        this(qualifiedName.getQualifier(), qualifiedName.getName(), arguments);
    }

    @NotNull
    public List<OCTypeArgument> getArguments() {
        return this.myArguments;
    }

    @Override
    public OCQualifiedName dropArguments() {
        return OCQualifiedName.with(this.myQualifier != null ? this.myQualifier.dropArguments() : null, this.myName);
    }

    @Override
    @NotNull
    public OCQualifiedName changeQualifier(@Nullable OCQualifiedName qualifier) {
        return new OCQualifiedNameWithArguments(qualifier, this.myName, this.myArguments);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.myArguments.hashCode();
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCQualifiedName first, @NotNull OCQualifiedName second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCQualifiedNameWithArguments f = (OCQualifiedNameWithArguments)first;
        OCQualifiedNameWithArguments s = (OCQualifiedNameWithArguments)second;
        return c.equalLists(f.myArguments, s.myArguments);
    }

    @Override
    public final boolean canThisNamePartBeInterned() {
        return false;
    }

    @Override
    protected boolean resolvedEqualsStep(@NotNull OCQualifiedName other, @NotNull OCResolveContext context) {
        if (!super.resolvedEqualsStep(other, context)) {
            return false;
        }
        assert (other instanceof OCQualifiedNameWithArguments);
        List<OCTypeArgument> otherArguments = ((OCQualifiedNameWithArguments)other).myArguments;
        if (this.myArguments.size() != otherArguments.size()) {
            return false;
        }
        for (Pair pair2 : ContainerUtil.zip(this.myArguments, otherArguments)) {
            if (((OCTypeArgument)pair2.first).equals(pair2.second, context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getCanonicalName(@NotNull OCType.Presentation presentation, boolean includeGlobalQualifier, @NotNull OCResolveContext context, int templateDepth) {
        return super.getCanonicalName(presentation, includeGlobalQualifier, context, templateDepth) + OCQualifiedNameWithArguments.getArgumentsText(this.myArguments, (Function<OCTypeArgument, String>)((Function)argument -> argument.getNameForPresentation(presentation, context, includeGlobalQualifier, templateDepth + 1)), templateDepth);
    }

    @Override
    public String getShortName(int templateDepth) {
        return super.getShortName(templateDepth) + OCQualifiedNameWithArguments.getArgumentsText(this.myArguments, (Function<OCTypeArgument, String>)((Function)argument -> argument.getShortName(templateDepth + 1)), templateDepth);
    }

    private static String getArgumentsText(List<OCTypeArgument> arguments, Function<OCTypeArgument, String> argFunc, int templateDepth) {
        StringBuilder builder = new StringBuilder();
        builder.append('<');
        if (templateDepth < 10) {
            String args = StringUtil.join(arguments, argFunc, (String)", ");
            if (args.startsWith("::")) {
                builder.append(" ");
            }
            builder.append(args);
        } else {
            builder.append("...");
        }
        builder.append('>');
        return builder.toString();
    }

    @Override
    public OCQualifiedName cloneWithOffset(@NotNull OCSymbolReference reference) {
        List<OCTypeArgument> arguments = this.myArguments.stream().map(arg -> arg instanceof OCType ? OCTypeUtils.changeTypeReferences((OCType)arg, reference) : arg).collect(Collectors.toList());
        return new OCQualifiedNameWithArguments(super.cloneWithOffset(reference), arguments);
    }
}

