/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCAttributes;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCSymbol
extends OCTypeOwner,
Serializable,
DeepEqual.Equality,
PsiElementNavigationItem,
Comparable,
DataProvider {
    public static final String UNNAMED = "<unnamed>";
    public static final Condition<OCSymbol> NON_PREDEFINITION_CONDITION = symbol -> !symbol.isPredeclaration();
    public static final Condition<OCSymbol> NON_FANTOM_SYMBOL_CONDITION = symbol -> symbol.getContainingFile() != null || symbol.getOffset() != 0;
    public static final Comparator<OCSymbol> PRESENTABLE_NAME_COMPARATOR = Comparator.comparing(OCSymbol::getPresentableName);
    public static final String ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE = "\"not available in automatic reference counting mode\"";

    @NotNull
    public String getName();

    @Nullable
    public VirtualFile getContainingFile();

    @Nullable
    public PsiElement locateDefinition(@NotNull Project var1);

    @NotNull
    public OCSymbolKind getKind();

    public long getComplexOffset();

    public int hashCodeExcludingOffset();

    @NotNull
    default public OCType getType() {
        return OCUnknownType.INSTANCE;
    }

    @Override
    @NotNull
    default public OCType getResolvedType(@NotNull OCResolveContext context) {
        return this.getType().resolve(context);
    }

    default public OCType getResolvedType(@NotNull OCResolveContext context, boolean ignoringImports) {
        return this.getType().resolve(context, ignoringImports);
    }

    public boolean isGlobal();

    default public boolean isCallable() {
        return this.getKind().isCallable();
    }

    default public boolean isDefinition() {
        return !this.isPredeclaration();
    }

    default public boolean isPredeclaration() {
        return this.getKind().isPredeclaration();
    }

    @NotNull
    default public List<String> getAttributes() {
        return Collections.emptyList();
    }

    default public boolean isUnnamed() {
        return UNNAMED.equals(this.getName());
    }

    default public void compact() {
    }

    @NotNull
    default public String getSignature(@NotNull Project project2) {
        return this.getPresentableName();
    }

    @NotNull
    default public String getPresentableName() {
        return this.getName();
    }

    @Nullable
    default public String getLocationString() {
        VirtualFile file = this.getContainingFile();
        if (file != null) {
            return file.getName();
        }
        return null;
    }

    default public boolean isSynthetic() {
        return false;
    }

    @NotNull
    default public String getNameWithKindLowercase(@NotNull OCCompilationContext context) {
        return this.getKindLowercase(context) + " '" + this.getPresentableName() + "'";
    }

    @NotNull
    default public String getNameWithKindUppercase(@NotNull OCCompilationContext context) {
        return this.getKindUppercase(context) + " '" + this.getPresentableName() + "'";
    }

    default public String getKindLowercase(@NotNull OCCompilationContext context) {
        return StringUtil.decapitalize((String)this.getKindUppercase(context));
    }

    @NotNull
    default public String getKindUppercase(@NotNull OCCompilationContext context) {
        return this.getKind().getNameUppercase();
    }

    @Nullable
    default public OCSymbol getDefinitionSymbol(@NotNull Project project2) {
        if (this.isPredeclaration()) {
            return OCSymbolBase.findSymbolDefinition(this.getName(), this.getKind(), project2, this.getContainingFile());
        }
        return this;
    }

    default public boolean processAssociatedSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project2) {
        OCSymbol associatedSymbol = this.getAssociatedSymbol(project2);
        return associatedSymbol == null || processor2.process((Object)associatedSymbol);
    }

    @Nullable
    default public OCSymbol getAssociatedSymbol(@NotNull Project project2) {
        return null;
    }

    default public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project2) {
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(project2, (Processor<? super OCSymbol>)((Processor)symbol -> symbol.getClass() != this.getClass() || processor2.process(symbol)), this.getName());
    }

    @Nullable
    default public PsiFile getContainingPsiFile(@NotNull Project project2) {
        VirtualFile containingFile = this.getContainingFile();
        if (containingFile != null && containingFile.isValid()) {
            return PsiManager.getInstance((Project)project2).findFile(containingFile);
        }
        return null;
    }

    @Nullable
    default public OCFile getContainingOCFile(@NotNull Project project2) {
        PsiFile file = this.getContainingPsiFile(project2);
        return file instanceof OCFile ? (OCFile)file : null;
    }

    default public int getOffset() {
        return OCSymbolOffsetUtil.getTextOffset(this.getComplexOffset());
    }

    default public void setComplexOffset(long complexOffset) {
    }

    @Nullable
    default public ComplexTextRange getScope() {
        return null;
    }

    default public void setScope(@NotNull ComplexTextRange scope) {
    }

    default public void updateOffset(int start, int lengthShift) {
        if (this.getOffset() > start) {
            this.setComplexOffset(OCSymbolOffsetUtil.shift(this.getComplexOffset(), lengthShift));
        }
        if (this.getScope() != null) {
            this.setScope(OCSymbolOffsetUtil.shift(this.getScope(), start, lengthShift));
        }
    }

    @Nullable
    default public Icon getIcon(@NotNull Project project2) {
        if (Registry.is((String)"psi.deferIconLoading")) {
            return IconDeferrer.getInstance().defer(this.getBaseIcon(), (Object)this, symbol -> this.computeFullIconNow(null, project2));
        }
        return this.computeFullIconNow(null, project2);
    }

    @Nullable
    default public Icon getBaseIcon() {
        return this.getKind().getIcon();
    }

    @Nullable
    default public Icon computeFullIconNow(@Nullable PsiElement symbolElement, @NotNull Project project2) {
        return this.getBaseIcon();
    }

    default public boolean isSameSymbol(@Nullable OCSymbol symbol, @NotNull Project project2) {
        return this.equals(symbol);
    }

    @NotNull
    default public OCType getEffectiveType(@NotNull Project project2) {
        return this.getType();
    }

    @NotNull
    default public OCType getEffectiveResolvedType(@NotNull OCResolveContext context) {
        return this.getResolvedType(context);
    }

    default public boolean isDeprecated() {
        return this.hasAttribute("deprecated");
    }

    @NotNull
    default public String getDeprecatedMessage(@NotNull OCCompilationContext context) {
        String message = this.getNameWithKindUppercase(context) + " is deprecated";
        String parameters = this.getAttributeParameters("deprecated");
        return parameters != null ? message + ": " + StringUtil.unquoteString((String)parameters) : message;
    }

    default public boolean isUnavailable() {
        return this.hasAttribute("unavailable") && !ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable"));
    }

    @NotNull
    default public String getUnavailableMessage(@NotNull OCCompilationContext context) {
        String message = this.getNameWithKindUppercase(context) + " is unavailable";
        String parameters = this.getAttributeParameters("unavailable");
        return parameters != null ? message + ": " + StringUtil.unquoteString((String)parameters) : message;
    }

    default public boolean isForbiddenByARC(@NotNull PsiElement context) {
        return this.hasAttribute("unavailable") && ATTRIBUTE_FORBIDDEN_BY_ARC_MESSAGE.equals(this.getAttributeParameters("unavailable")) && OCCompilerFeatures.isArcEnabled(context.getContainingFile());
    }

    default public boolean isTransparentUnion() {
        return this.hasAttribute("transparent_union");
    }

    default public boolean hasAttribute(@NotNull String attribute) {
        return OCAttributes.hasAttribute(this.getAttributes(), attribute);
    }

    @Nullable
    default public String getAttributeParameters(@NotNull String attribute) {
        return OCAttributes.getAttributeParameter(this.getAttributes(), attribute);
    }

    @NotNull
    default public OCSymbol getDelegate() {
        return this;
    }

    @NotNull
    default public String getPresentableText() {
        return this.getPresentableName();
    }

    @Deprecated
    default public Object getData(@NotNull @NonNls String dataId) {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    @Nullable
    default public PsiElement getTargetElement() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    @Nullable
    default public ItemPresentation getPresentation() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public void navigate(boolean requestFocus) {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public boolean canNavigate() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public boolean canNavigateToSource() {
        throw new UnsupportedOperationException("Use OCSymbolNavigationItem instead!");
    }

    @Deprecated
    default public int compareTo(@NotNull Object o) {
        throw new UnsupportedOperationException("Please provide an external comparator to wherever it's used");
    }
}

