/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.lang.symbols.MaybeVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolBase
implements OCSymbol,
MaybeVirtualFileOwner {
    @Nullable
    protected transient VirtualFile myFile;
    protected long myComplexOffset;

    public OCSymbolBase(@Nullable VirtualFile file, long complexOffset) {
        this.myFile = file;
        this.myComplexOffset = complexOffset;
    }

    public OCSymbolBase() {
    }

    @NotNull
    public static String getSymbolName(@Nullable OCSymbol symbol) {
        return symbol == null ? "<unnamed>" : symbol.getName();
    }

    @NotNull
    public static String getTagOfStructLike(OCSymbol symbol) {
        String kind = symbol.getKind().getNameLowercase() + " ";
        String name2 = symbol.getPresentableName();
        if (name2.startsWith(kind)) {
            return name2.substring(kind.length());
        }
        return name2;
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(@Nullable String name2, @NotNull OCSymbolKind symbolKind, @NotNull Project project2, @Nullable VirtualFile context) {
        return OCSymbolBase.findSymbolDefinition(name2, symbolKind, project2, context, null);
    }

    @Nullable
    public static <T extends OCSymbol> T findSymbolDefinition(@Nullable String name2, @NotNull OCSymbolKind symbolKind, @NotNull Project project2, @Nullable VirtualFile context, @Nullable Condition<T> condition) {
        return (T)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project2, name2, (Condition<? super OCSymbol>)((Condition)symbol -> symbol.getKind() == symbolKind && !symbol.isPredeclaration() && (condition == null || condition.value(symbol))), context);
    }

    @Override
    public void init(@Nullable VirtualFile file) {
        this.myFile = file;
    }

    @Override
    public boolean isGlobal() {
        return false;
    }

    protected Class<? extends PsiElement> getPsiElementClass() {
        return this.getKind().getPsiElementClass();
    }

    @Override
    @Nullable
    public PsiElement locateDefinition(@NotNull Project project2) {
        return OCSymbolBase.doLocateDefinition(this, project2, this.getPsiElementClass());
    }

    @Nullable
    public static <T extends PsiElement> T doLocateDefinition(@NotNull OCSymbol symbol, @NotNull Project project2, @NotNull Class<T> elementClass) {
        VirtualFile file = symbol.getContainingFile();
        if (file == null || !file.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
        if (psiFile == null) {
            return null;
        }
        PsiElement cur = psiFile.findElementAt(symbol.getOffset());
        if (cur == null) {
            return null;
        }
        cur = PsiTreeUtil.getDeepestLast((PsiElement)cur);
        while (cur != null) {
            long symbolComplexOffset;
            long curComplexOffset = OCSymbolOffsetUtil.getComplexOffset(cur);
            if (curComplexOffset == (symbolComplexOffset = symbol.getComplexOffset())) {
                T definitionAtPrev;
                T definitionAtCur = OCSymbolBase.findParentDefinition(cur, elementClass, symbolComplexOffset);
                if (definitionAtCur != null) {
                    return definitionAtCur;
                }
                if (symbol.isUnnamed() && (definitionAtPrev = OCSymbolBase.findParentDefinition(PsiTreeUtil.prevLeaf((PsiElement)cur), elementClass, symbolComplexOffset)) != null) {
                    return definitionAtPrev;
                }
                return null;
            }
            if (OCSymbolOffsetUtil.getTextOffset(curComplexOffset) != OCSymbolOffsetUtil.getTextOffset(symbolComplexOffset)) {
                return null;
            }
            cur = PsiTreeUtil.prevLeaf((PsiElement)cur);
        }
        return null;
    }

    @Nullable
    private static <T extends PsiElement> T findParentDefinition(@Nullable PsiElement cur, @NotNull Class<T> elementClass, long symbolComplexOffset) {
        if (cur == null) {
            return null;
        }
        PsiElement parent = cur;
        do {
            if (!elementClass.isInstance(parent) || OCSymbolOffsetUtil.getVirtualComplexOffset(parent) != symbolComplexOffset) continue;
            return (T)parent;
        } while ((parent = PsiTreeUtil.getParentOfType((PsiElement)parent, elementClass, (boolean)true)) != null);
        return null;
    }

    public String toString() {
        return (Object)((Object)this.getKind()) + "[" + this.getPresentableName() + "]@" + (this.getContainingFile() != null ? this.getContainingFile().getName() + ":" : "") + this.getOffset();
    }

    @Override
    @Nullable
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @Override
    public long getComplexOffset() {
        return this.myComplexOffset;
    }

    @Override
    public void setComplexOffset(long complexOffset) {
        this.myComplexOffset = complexOffset;
    }

    public int hashCode() {
        int result = this.hashCodeExcludingOffset();
        result = 31 * result + this.getOffset();
        return result;
    }
}

