/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolImpl
extends OCSymbolBase
implements OCSymbol {
    @NotNull
    protected String myName;
    @NotNull
    private volatile List<String> myAttributes;

    public OCSymbolImpl(@Nullable VirtualFile file, long complexOffset, @Nullable String name2, @NotNull List<String> attributes) {
        super(file, complexOffset);
        this.myName = name2 == null ? "<unnamed>" : OCNamesInternary.intern(name2);
        this.myAttributes = attributes;
    }

    public OCSymbolImpl() {
    }

    @Override
    @NotNull
    public List<String> getAttributes() {
        return this.myAttributes;
    }

    public void addAttributes(List<String> attributes) {
        if (this.myAttributes.isEmpty()) {
            this.myAttributes = attributes;
        } else {
            ArrayList<String> newAttributes = new ArrayList<String>(this.myAttributes.size() + attributes.size());
            newAttributes.addAll(this.myAttributes);
            newAttributes.addAll(attributes);
            this.myAttributes = newAttributes;
        }
    }

    @Override
    public void compact() {
        this.myAttributes = ContainerUtil.trimToSize(this.myAttributes);
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        OCSymbolImpl f = (OCSymbolImpl)first;
        OCSymbolImpl s = (OCSymbolImpl)second;
        if (f.myComplexOffset != s.myComplexOffset) {
            return false;
        }
        if (!f.myName.equals(s.myName)) {
            return false;
        }
        if (!Comparing.equal((Object)f.myFile, (Object)s.myFile)) {
            return false;
        }
        return f.myAttributes.equals(s.myAttributes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSymbolImpl symbol = (OCSymbolImpl)o;
        if (this.myComplexOffset != symbol.myComplexOffset) {
            return false;
        }
        if (!this.myAttributes.equals(symbol.myAttributes)) {
            return false;
        }
        VirtualFile file = this.myFile;
        if (file != null ? !file.equals(symbol.myFile) : symbol.myFile != null) {
            return false;
        }
        return this.myName.equals(symbol.myName);
    }

    @Override
    public int hashCodeExcludingOffset() {
        int result = OCSymbolOffsetUtil.getSubstOffset(this.myComplexOffset);
        result = 31 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        result = 31 * result + this.myName.hashCode();
        result = 31 * result + this.myAttributes.hashCode();
        return result;
    }
}

