/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithDecltype;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCDebugUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolReference
implements Serializable,
DeepEqual.Equality<OCSymbolReference> {
    public static final int MAX_RESOLVE_NESTING_DEPTH = 256;
    public static final int MAX_DEPENDENT_RESOLVE_NESTING_DEPTH = 6;
    public static final OCElementType[] TYPE_TOKENS = new OCElementType[]{OCTokenTypes.STRUCT_KEYWORD, OCTokenTypes.ENUM_KEYWORD, OCTokenTypes.UNION_KEYWORD, OCTokenTypes.CLASS_KEYWORD};
    @NotNull
    protected OCQualifiedName myQualifiedName;
    @NotNull
    protected SymbolFilter myFilter;
    private static final Key<CachedValue<Map<ReferenceInfo, ResultInfo>>>[] RESOLVE_CACHES = new Key[12];

    @NotNull
    public SymbolFilter getFilter() {
        return this.myFilter;
    }

    public OCSymbolReference(@NotNull OCQualifiedName qualifiedName, @NotNull SymbolFilter filter) {
        this.myQualifiedName = qualifiedName;
        this.myFilter = filter;
    }

    public OCSymbolReference() {
    }

    @NotNull
    public OCQualifiedName getQualifiedName() {
        return this.myQualifiedName;
    }

    @Nullable
    public abstract VirtualFile getVirtualFile();

    public abstract long getOffset();

    public abstract OCSymbolReference cloneWithOffset(@NotNull OCSymbolReference var1);

    public abstract OCSymbolReference cloneWithArguments(@NotNull List<OCTypeArgument> var1);

    public boolean processPossibleSymbols(Processor<OCSymbol> processor2, boolean filterByTemplates, @NotNull OCResolveContext context) {
        List<OCSymbol> symbols = this.resolveToSymbols(false, false, true, context);
        if (symbols.isEmpty() && !filterByTemplates) {
            symbols = this.resolveToSymbols(false, false, false, context);
        }
        return ContainerUtil.process(symbols, processor2);
    }

    public boolean processPossibleSymbols(Processor<OCSymbol> processor2, @NotNull OCResolveContext context) {
        return this.processPossibleSymbols(processor2, true, context);
    }

    @NotNull
    public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
        return this.resolveToSymbols(context, false, true);
    }

    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean processTypedefs, boolean onlyTypes, @NotNull OCResolveContext context) {
        return this.resolveToSymbols(processTypedefs, onlyTypes, true, context);
    }

    @NotNull
    public List<OCSymbol> resolveToSymbols(boolean processTypedefs, boolean onlyTypes, boolean resolveSpecialization, @NotNull OCResolveContext context) {
        List<OCSymbol> symbols = this.resolveToSymbols(context, onlyTypes, resolveSpecialization);
        return OCSymbolReference.lookupUsingsAndTypedefs(processTypedefs, onlyTypes, context, symbols, this, true, resolveSpecialization);
    }

    @NotNull
    public static List<OCSymbol> lookupUsingsAndTypedefs(boolean processTypedefs, boolean onlyTypes, @NotNull OCResolveContext context, @NotNull List<OCSymbol> symbols, @NotNull OCSymbolReference reference, boolean processTypeParameters, boolean resolveSpecialization) {
        OCQualifiedName qualifiedName = reference.getQualifiedName();
        List<OCTypeArgument> args = null;
        if (qualifiedName instanceof OCQualifiedNameWithArguments) {
            args = ((OCQualifiedNameWithArguments)qualifiedName).getArguments();
        }
        UsingAndTypedefSymbolsResolver resolver = new UsingAndTypedefSymbolsResolver(processTypedefs, processTypeParameters, resolveSpecialization, onlyTypes, args, reference, context);
        ContainerUtil.process(symbols, (Processor)resolver);
        return resolver.getAnswer();
    }

    public static GlobalReference getDummyGlobalReference(@NotNull OCQualifiedName qualifiedName) {
        return new GlobalReference(qualifiedName, null, null, -1L, SymbolFilter.NONE);
    }

    public static GlobalReference getGlobalReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset) {
        return new GlobalReference(qualifiedName, symbolContext, file, complexOffset, SymbolFilter.NONE);
    }

    public static GlobalReference getGlobalReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset, SymbolFilter filter) {
        return new GlobalReference(qualifiedName, symbolContext, file, complexOffset, filter);
    }

    public static BaseClauseReference getBaseClauseReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset) {
        return new BaseClauseReference(qualifiedName, symbolContext, file, complexOffset, SymbolFilter.NONE);
    }

    public static TemplateArgumentsReference getTemplateArgsReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset, boolean specialization) {
        return new TemplateArgumentsReference(qualifiedName, symbolContext, file, complexOffset, SymbolFilter.NONE, specialization);
    }

    public static LocalReference getLocalReference(@NotNull OCQualifiedName qualifiedName, PsiElement localContext) {
        return new LocalReference(qualifiedName, localContext, SymbolFilter.NONE);
    }

    public static LocalReference getLocalReference(@NotNull OCQualifiedName qualifiedName, PsiElement localContext, SymbolFilter filter) {
        return new LocalReference(qualifiedName, localContext, filter);
    }

    public static LocalReference getLocalReference(String name2, PsiElement element) {
        return OCSymbolReference.getLocalReference(OCQualifiedName.with(name2), element, SymbolFilter.NONE);
    }

    public static LocalReference getLocalReference(@NotNull OCNamespaceQualifierOwner element, SymbolFilter filter) {
        OCQualifiedName qualifiedName = OCSymbolReferenceResolver.getQualifiedName(element);
        return OCSymbolReference.getLocalReference(qualifiedName, element, filter);
    }

    public static LambdaLocalReference getLambdaLocalReference(@NotNull OCQualifiedName qualifiedName, long offset, @NotNull OCLambdaExpressionSymbol lambda2, @NotNull OCSymbolReference parentScopeReference) {
        return new LambdaLocalReference(qualifiedName, offset, lambda2, SymbolFilter.NONE, parentScopeReference);
    }

    public abstract OCSymbolReference getSymbolReferenceToQualifier();

    @NotNull
    protected SymbolKindFilter getFilterForQualifier() {
        return this.myFilter == SymbolKindFilter.ONLY_NAMESPACE ? SymbolKindFilter.ONLY_NAMESPACE : SymbolKindFilter.ONLY_NAMESPACE_LIKE;
    }

    @NotNull
    public OCSymbolReference applyTypeArguments(List<OCTypeArgument> arguments) {
        return this.createReferenceInSameContext(new OCQualifiedNameWithArguments(this.getQualifiedName(), arguments));
    }

    @NotNull
    public abstract OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OCSymbolReference that = (OCSymbolReference)o;
        if (!this.myQualifiedName.equals(that.myQualifiedName)) {
            return false;
        }
        return this.myFilter.equals(that.myFilter);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
        return c.equalObjects(first.myQualifiedName, second.myQualifiedName);
    }

    public int hashCode() {
        return this.myQualifiedName.hashCode();
    }

    @NotNull
    List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context, boolean onlyTypes, boolean resolveSpecialization) {
        PsiFile file = context.getFile();
        if (file == null) {
            return Collections.emptyList();
        }
        boolean ignoreImports = context.isProcessNonImported();
        Object dependency = this.getCacheDependency(file.getProject());
        Map cache = (Map)OCSymbolReference.getCache(file, onlyTypes, ignoreImports, true, dependency).getValue();
        Map cache2 = (Map)OCSymbolReference.getCache(file, onlyTypes, ignoreImports, false, dependency).getValue();
        OCTypeSubstitution substitution = context.getSubstitution();
        substitution = substitution.getMinimalDependentSubstitution(this, context);
        OCResolveUtil.checkCanceled();
        ResultInfo cachedResolve = (ResultInfo)cache.get(new ReferenceInfo(this, substitution, resolveSpecialization));
        if (cachedResolve == null) {
            GlobalReference globalRef;
            Set<OCTypeParameterSymbol> oldDependencies = context.getTypeDependencies();
            context.clearTypeDependencies();
            ResultInfo cachedResolve2 = null;
            GlobalReference refWithoutOffset = null;
            if (context.useSecondCache() && this instanceof GlobalReference && (cachedResolve2 = (ResultInfo)cache2.get(new ReferenceInfo(refWithoutOffset = new GlobalReference(this.myQualifiedName, (globalRef = (GlobalReference)this).myVirtualFileOrSymbolContext, 0L, this.myFilter), substitution, resolveSpecialization))) != null && (this.getOffset() == -1L || !ContainerUtil.exists(cachedResolve2.symbols, symbol -> symbol.getComplexOffset() >= this.getOffset()))) {
                cachedResolve = cachedResolve2;
            }
            if (cachedResolve == null) {
                List<OCSymbol> results = this.doResolve(context, onlyTypes, resolveSpecialization);
                Set<OCTypeParameterSymbol> dependencies = context.getTypeDependencies();
                dependencies = !dependencies.isEmpty() ? dependencies : null;
                cachedResolve = new ResultInfo(results, dependencies, this.getOffset());
            }
            context.addTypeDependencies(oldDependencies);
            cache.put(new ReferenceInfo(this, substitution, resolveSpecialization), cachedResolve);
            if (refWithoutOffset != null && cachedResolve2 == null && !cachedResolve.symbols.isEmpty() && ContainerUtil.exists(cachedResolve.symbols, symbol -> symbol.isDefinition())) {
                cache2.put(new ReferenceInfo(refWithoutOffset, substitution, resolveSpecialization), cachedResolve);
            }
        } else if (cachedResolve.typeDependencies != null) {
            context.addTypeDependencies(cachedResolve.typeDependencies);
        }
        OCDebugUtil.tryDebugWaitForSymbols(cachedResolve.symbols);
        return Collections.unmodifiableList(cachedResolve.symbols);
    }

    protected Object getCacheDependency(@NotNull Project project2) {
        return FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker();
    }

    @NotNull
    private static CachedValue<Map<ReferenceInfo, ResultInfo>> getCache(@NotNull PsiFile file, boolean onlyTypes, boolean ignoreImports, boolean useOffsets, @NotNull Object dependency) {
        Key<CachedValue<Map<ReferenceInfo, ResultInfo>>> cacheKey = OCSymbolReference.getCacheKey(onlyTypes, ignoreImports, useOffsets, dependency);
        CachedValue<Map<ReferenceInfo, ResultInfo>> cache = (CachedValue<Map<ReferenceInfo, ResultInfo>>)file.getUserData(cacheKey);
        if (cache == null) {
            cache = OCSymbolReference.createCache(file.getProject(), dependency);
            file.putUserData(cacheKey, cache);
        }
        return cache;
    }

    @NotNull
    private static CachedValue<Map<ReferenceInfo, ResultInfo>> createCache(@NotNull Project project2, @NotNull Object dependency) {
        return CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
            ConcurrentMap cache = ContainerUtil.newConcurrentMap();
            return CachedValueProvider.Result.create((Object)cache, (Object[])new Object[]{dependency});
        }, false);
    }

    @NotNull
    private static Key<CachedValue<Map<ReferenceInfo, ResultInfo>>> getCacheKey(boolean onlyTypes, boolean ignoreImports, boolean useOffsets, Object dependency) {
        int cacheIndex = (ignoreImports ? 0 : (onlyTypes ? 1 : 2)) * 4 + (dependency == PsiModificationTracker.MODIFICATION_COUNT ? 0 : 1) * 2 + (useOffsets ? 0 : 1);
        return RESOLVE_CACHES[cacheIndex];
    }

    @NotNull
    public List<OCSymbol> doResolve(@NotNull OCResolveContext context, boolean onlyTypes, boolean resolveSpecialization) {
        List res = (List)OCLongActionUtil.execWithTimeoutProgressInDispatch("progressbar.long.resolve.description", "cidr.resolve.in.ui.timeout", context.getProject(), () -> {
            ProgressManager.checkCanceled();
            if (context.getNestingDepth() > 256) {
                return Collections.emptyList();
            }
            OCSymbolReferenceResolver referenceResolver = new OCSymbolReferenceResolver(onlyTypes, context);
            SymbolFilter filter = this.myFilter;
            NameWithToken nameWithToken = OCSymbolReference.removeTypeToken(this.myQualifiedName.getName());
            String name2 = nameWithToken.name;
            if (nameWithToken.typeToken != null) {
                filter = SymbolKindFilter.parse(nameWithToken.typeToken);
            }
            if (this.myQualifiedName instanceof OCQualifiedNameWithDecltype) {
                OCType resolvedType = ((OCQualifiedNameWithDecltype)this.myQualifiedName).getAutoType().resolve(context);
                if (resolvedType instanceof OCStructType) {
                    return Collections.singletonList(((OCStructType)resolvedType).getSymbol());
                }
                if (resolvedType instanceof OCTypeParameterType) {
                    OCTypeParameterSymbol symbol = ((OCTypeParameterType)resolvedType).getSymbol();
                    OCTypeParameterTypeSymbol qualifierTypeParameter = symbol instanceof OCTypeParameterTypeSymbol ? (OCTypeParameterTypeSymbol)symbol : null;
                    OCSymbolImpl candidate = new OCTypeParameterTypeSymbol(null, 0L, name2, qualifierTypeParameter, null, Collections.emptyList(), null, false, true, true);
                    if (filter.accept(candidate)) {
                        return Collections.singletonList(candidate);
                    }
                    candidate = new OCDeclaratorSymbolImpl(name2, new OCMagicType(name2), OCSymbolKind.TEMPLATE_VALUE_PARAMETER);
                    if (filter.accept(candidate)) {
                        return Collections.singletonList(candidate);
                    }
                }
                return Collections.emptyList();
            }
            OCQualifiedName qualifier = this.myQualifiedName.getQualifier();
            boolean hasArguments = this.myQualifiedName instanceof OCQualifiedNameWithArguments;
            boolean skipImmediateContext = this instanceof BaseClauseReference;
            Object collectorResults = new SmartList();
            final Set set = OCTypeUtils.newSymbolWithSubstitutionSet();
            CommonProcessors.CollectProcessor<OCSymbol> collector = new CommonProcessors.CollectProcessor<OCSymbol>((Collection)collectorResults){

                protected boolean accept(OCSymbol symbol) {
                    return set.add(symbol);
                }
            };
            GlobalReference globalRef = (GlobalReference)OCSymbolReferenceResolver.getGlobalReferenceFromLocal(this);
            OCResolveUtil.ResolveFilteringProcessor<OCSymbol> processor2 = OCSymbolReferenceResolver.createResolveFilteringProcessor((Processor<OCSymbol>)collector, globalRef, context);
            boolean findQualifiedContainers = false;
            if (qualifier != null) {
                if (qualifier.equals(OCQualifiedName.GLOBAL)) {
                    referenceResolver.processSymbolsForGlobalRef(name2, filter, null, skipImmediateContext, processor2, hasArguments, false, globalRef);
                } else {
                    findQualifiedContainers = qualifier.getQualifier() == null || qualifier.getQualifier().equals(OCQualifiedName.GLOBAL);
                    OCSymbolReference qualifierRef = this.getSymbolReferenceToQualifier();
                    int templateSubstitutionsCnt = context.getTemplateSubstitutionsCnt();
                    List<OCSymbol> iterable = context.resolveToSymbols(qualifierRef, true, true, onlyTypes);
                    processor2.allowResolveBelowIf(context.getTemplateSubstitutionsCnt() > templateSubstitutionsCnt);
                    boolean old = OCResolveContext.setNonImportedFlag(context, false);
                    OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = referenceResolver.getFilteredByKindProcessor(filter, processor2);
                    if (qualifierRef.getQualifiedName().equals(OCQualifiedName.with(name2))) {
                        for (OCSymbol symbol : iterable) {
                            if (!(symbol instanceof OCStructSymbol) || symbol.getName().equals(name2)) continue;
                            ((OCStructSymbol)symbol).processConstructors(orderedProcessor, context);
                        }
                    }
                    ContainerUtil.process(iterable, (Processor)new SymbolMembersProcessor(name2, orderedProcessor, false, onlyTypes, context, qualifierRef));
                    while (qualifierRef.getQualifiedName().getQualifier() != null) {
                        PsiFile file;
                        List<Object> containers = (qualifierRef = qualifierRef.getSymbolReferenceToQualifier()).getQualifiedName().equals(OCQualifiedName.GLOBAL) ? ((file = context.getFile()) instanceof OCFile ? Collections.singletonList(((OCFile)file).getMembersContainer(onlyTypes)) : Collections.emptyList()) : context.resolveToSymbols(qualifierRef, true, true, onlyTypes);
                        for (OCSymbol symbol : containers) {
                            if (!(symbol instanceof OCMembersContainer)) continue;
                            ((OCMembersContainer)((Object)symbol)).processMembers(name2, arg_0 -> OCSymbolReference.lambda$null$3((CommonProcessors.CollectProcessor)collector, arg_0));
                        }
                    }
                    orderedProcessor.finish();
                    OCResolveContext.setNonImportedFlag(context, old);
                    if (findQualifiedContainers && !ContainerUtil.exists((Iterable)collectorResults, c -> c instanceof OCNamespaceSymbol)) {
                        findQualifiedContainers = false;
                    }
                }
            }
            if (qualifier == null || findQualifiedContainers) {
                if (this instanceof LocalReference) {
                    PsiElement localContext = ((LocalReference)this).getLocalContext();
                    if (localContext != null && localContext.isValid()) {
                        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = referenceResolver.getFilteredByKindProcessor(filter, (Processor<OCSymbol>)collector);
                        if (!findQualifiedContainers) {
                            referenceResolver.processSymbolsForLocalRef(name2, localContext, orderedProcessor);
                        }
                        if (orderedProcessor.finish() && (this.myQualifiedName.myName == null || !ContainerUtil.exists((Iterable)collector.getResults(), OCResolveUtil::stopNameLookup))) {
                            GlobalReference globalReference = (GlobalReference)OCSymbolReferenceResolver.getGlobalReferenceFromLocal(OCQualifiedName.with(name2), localContext, filter);
                            OCSymbolWithQualifiedName symbolContext = globalReference.getSymbolContext();
                            referenceResolver.processSymbolsForGlobalRef(name2, filter, symbolContext, skipImmediateContext, processor2, hasArguments, findQualifiedContainers, globalReference);
                        }
                    }
                } else {
                    OCSymbolWithQualifiedName symbolContext = ((GlobalReference)this).getSymbolContext();
                    referenceResolver.processSymbolsForGlobalRef(name2, filter, symbolContext, skipImmediateContext, (Processor<OCSymbol>)collector, hasArguments, findQualifiedContainers, (GlobalReference)this);
                }
            }
            if (resolveSpecialization) {
                collectorResults = this.resolveWithTypeArguments(context, (List<OCSymbol>)collectorResults);
            }
            return collectorResults;
        });
        return res == null ? Collections.emptyList() : res;
    }

    @NotNull
    public static NameWithToken removeTypeToken(@Nullable String name2) {
        String typeToken = null;
        if (name2 != null) {
            String nameWithoutTypeQualifiers = name2;
            boolean changes = true;
            while (changes) {
                changes = false;
                for (OCElementType oCElementType : OCTokenTypes.TYPE_QUALIFIERS.getTypes()) {
                    String tokenName = oCElementType.getName();
                    if (!nameWithoutTypeQualifiers.startsWith(tokenName + " ")) continue;
                    nameWithoutTypeQualifiers = nameWithoutTypeQualifiers.substring(tokenName.length() + 1);
                    changes = true;
                }
            }
            for (OCElementType oCElementType : TYPE_TOKENS) {
                if (!nameWithoutTypeQualifiers.startsWith(oCElementType.getName() + " ")) continue;
                name2 = name2.substring(0, name2.length() - nameWithoutTypeQualifiers.length()) + nameWithoutTypeQualifiers.substring(oCElementType.getName().length() + 1);
                typeToken = oCElementType.getName();
                break;
            }
        }
        return new NameWithToken(name2, typeToken);
    }

    @NotNull
    private List<OCSymbol> resolveWithTypeArguments(@NotNull OCResolveContext resolver, @NotNull List<OCSymbol> symbols) {
        if (!resolver.isObjc() || ContainerUtil.find(symbols, OCInterfaceSymbol.IS_GENERIC_OBJC_CLASS) == null) {
            return this.resolveTemplateSpecialization(resolver, symbols);
        }
        ArrayList<OCClassSymbol> genericSymbols = new ArrayList<OCClassSymbol>();
        ArrayList<OCSymbol> templateSymbols = new ArrayList<OCSymbol>();
        for (OCSymbol symbol : symbols) {
            if (symbol instanceof OCClassSymbol) {
                genericSymbols.add((OCClassSymbol)symbol);
                continue;
            }
            templateSymbols.add(symbol);
        }
        return ContainerUtil.concat(this.resolveGenerics(resolver, genericSymbols), this.resolveTemplateSpecialization(resolver, templateSymbols));
    }

    @NotNull
    private List<OCClassSymbol> resolveGenerics(@NotNull OCResolveContext resolver, @NotNull List<OCClassSymbol> symbols) {
        if (symbols.isEmpty()) {
            return symbols;
        }
        List<Object> arguments = this.myQualifiedName instanceof OCQualifiedNameWithArguments ? ((OCQualifiedNameWithArguments)this.myQualifiedName).getArguments() : Collections.emptyList();
        SmartList results = new SmartList();
        for (OCClassSymbol symbol : symbols) {
            if (!OCInterfaceSymbol.IS_GENERIC_OBJC_CLASS.value((Object)symbol)) {
                results.add(symbol);
                continue;
            }
            Map<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = OCTypeUtils.newTypeParameterMap();
            Iterator<Object> typeArgumentIterator = arguments.iterator();
            for (OCGenericParameterSymbol typeParameter : ((OCInterfaceSymbol)symbol).getGenericParameters()) {
                OCTypeArgument argument;
                OCTypeArgument oCTypeArgument = argument = typeArgumentIterator.hasNext() ? (OCTypeArgument)typeArgumentIterator.next() : typeParameter.getDefaultValue();
                if (argument instanceof OCType) {
                    argument = ((OCType)argument).transformType(new OCTypeResolveVisitor(resolver));
                }
                substitutionMap.put(typeParameter, argument);
            }
            results.add(OCSimpleTypeSubstitution.create(substitutionMap).substitute(symbol));
        }
        return results;
    }

    @NotNull
    private List<OCSymbol> resolveTemplateSpecialization(@NotNull OCResolveContext resolver, @NotNull List<OCSymbol> symbols) {
        if (symbols.isEmpty()) {
            return symbols;
        }
        if (!(this.myQualifiedName instanceof OCQualifiedNameWithArguments)) {
            if (resolver.isProcessNonImported()) {
                return symbols;
            }
            if (this instanceof GlobalReference && symbols.size() == 1) {
                OCSymbol symbol = symbols.get(0);
                for (OCSymbolWithQualifiedName context = ((GlobalReference)this).getSymbolContext(); context != null; context = context.getParent()) {
                    if (!context.equals(symbol)) continue;
                    return symbols;
                }
            }
            return ContainerUtil.filter(symbols, s -> !(s instanceof OCStructSymbol) || ((OCStructSymbol)s).getTemplateSpecialization() == null);
        }
        List<OCTypeArgument> arguments = ((OCQualifiedNameWithArguments)this.myQualifiedName).getArguments();
        SmartList results = new SmartList();
        ArrayList<OCSymbol> candidates = new ArrayList<OCSymbol>(symbols);
        ArrayList<OCTemplateSymbol> templateSymbols = new ArrayList<OCTemplateSymbol>();
        for (OCSymbol candidate : candidates) {
            switch (OCSymbolReference.shouldCheckSpecialization(candidate)) {
                case ALWAYS_CHECK: {
                    templateSymbols.add((OCTemplateSymbol)candidate);
                    break;
                }
                case NEVER_CHECK: {
                    results.add(candidate);
                    break;
                }
            }
        }
        for (OCTemplateSymbol spec : OCSimpleTypeSubstitution.resolveTemplateSpecialization(templateSymbols, arguments, resolver)) {
            OCTemplateSymbol afterSubstitution = resolver.getSubstitution().substitute(spec, resolver);
            results.add(afterSubstitution);
        }
        return results;
    }

    private static SpecializationCheckType shouldCheckSpecialization(@NotNull OCSymbol symbol) {
        OCSymbolKind kind = symbol.getKind();
        if (kind == OCSymbolKind.TEMPLATE_TYPE_PARAMETER || kind == OCSymbolKind.SYMBOL_USING_SYMBOL || kind == OCSymbolKind.CPP_DEDUCTION_GUIDE) {
            return SpecializationCheckType.NEVER_CHECK;
        }
        if (symbol instanceof OCTemplateSymbol) {
            return SpecializationCheckType.ALWAYS_CHECK;
        }
        return SpecializationCheckType.SKIP;
    }

    private static /* synthetic */ boolean lambda$null$3(CommonProcessors.CollectProcessor collector, Object symbol1) {
        if (symbol1 instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)symbol1).isQualifiedContainer()) {
            collector.process((Object)((OCSymbol)symbol1));
        }
        return true;
    }

    static {
        for (int i = 0; i < RESOLVE_CACHES.length; ++i) {
            OCSymbolReference.RESOLVE_CACHES[i] = Key.create((String)("SYMBOL_RESOLVE_CACHE_IN_FILE" + i));
        }
    }

    public static class UsingAndTypedefSymbolsResolver
    implements Processor<OCSymbol> {
        private final Set<OCSymbol> myProcessedSymbols = OCTypeUtils.newSymbolWithSubstitutionSet();
        private final ArrayList<OCSymbol> myAnswer = new ArrayList();
        private OCSymbolReference myOriginalReference;
        @NotNull
        private OCResolveContext myMemoization;
        private final boolean myProcessTypdefs;
        private final boolean myProcessTypeParameters;
        private boolean myResolveSpecialization;
        private final boolean myOnlyTypes;
        private List<OCTypeArgument> myArguments;

        public UsingAndTypedefSymbolsResolver(boolean processTypedefs, boolean processTypeParameters, boolean resolveSpecialization, boolean onlyTypes, @Nullable List<OCTypeArgument> arguments, @Nullable OCSymbolReference originalReference, @NotNull OCResolveContext context) {
            this.myProcessTypdefs = processTypedefs;
            this.myProcessTypeParameters = processTypeParameters;
            this.myResolveSpecialization = resolveSpecialization;
            this.myOnlyTypes = onlyTypes;
            this.myOriginalReference = originalReference;
            this.myMemoization = context;
            this.myArguments = arguments;
        }

        public boolean process(OCSymbol symbol) {
            if (this.myProcessedSymbols.add(symbol)) {
                OCFile currentFile = (OCFile)this.myMemoization.getFile();
                if (currentFile == null) {
                    return true;
                }
                if (symbol instanceof OCUsingSymbol) {
                    OCSymbolReference reference = ((OCUsingSymbol)symbol).getSymbolReference();
                    if (this.myArguments != null) {
                        reference = reference.applyTypeArguments(this.myArguments);
                    }
                    if (this.myOriginalReference != null) {
                        reference = reference.cloneWithOffset(this.myOriginalReference);
                    }
                    OCResolveContext contextForUsing = this.myMemoization.substitute(((OCUsingSymbol)symbol).getSubstitution());
                    List symbols = ContainerUtil.map(contextForUsing.doResolveToSymbols(reference, this.myOnlyTypes, false), s -> s instanceof OCFunctionSymbol ? ((OCFunctionSymbol)s).setProperty(OCFunctionSymbol.Property.IS_FROM_USING) : s);
                    if (this.myResolveSpecialization) {
                        symbols = reference.resolveTemplateSpecialization(contextForUsing, symbols);
                    }
                    ContainerUtil.process((List)symbols, (Processor)this);
                } else if (symbol.getKind().isTypedefOrAlias() && this.myProcessTypdefs) {
                    this.processType(symbol, symbol.getType());
                } else if (symbol instanceof OCNamespaceAliasSymbol && this.myProcessTypdefs) {
                    OCSymbolReference reference = ((OCNamespaceAliasSymbol)symbol).getNamespaceReference();
                    ContainerUtil.process(this.myMemoization.doResolveToSymbols(reference, this.myOnlyTypes, true), (Processor)this);
                } else if (symbol instanceof OCTypeParameterSymbol && this.myProcessTypeParameters) {
                    OCTypeArgument argument = this.myMemoization.getSubstitution().getSubstitutionFor((OCTypeParameterSymbol)((Object)symbol));
                    if (symbol instanceof OCTypeParameterTypeSymbol && argument instanceof OCType) {
                        this.processType(symbol, (OCType)argument);
                        this.myMemoization.incTemplateSubstitutionsCnt();
                    } else {
                        this.myAnswer.add(symbol);
                    }
                } else {
                    this.myAnswer.add(symbol);
                }
            }
            return true;
        }

        protected void processType(OCSymbol symbol, OCType type) {
            if (type instanceof OCStructType) {
                this.myAnswer.addAll(((OCStructType)type).getStructs());
            } else if (type instanceof OCReferenceType) {
                OCSymbolReference reference = ((OCReferenceType)type).getReference(this.myMemoization).cloneWithOffset(this.myOriginalReference);
                OCResolveContext oldMemoization = this.myMemoization;
                if (symbol instanceof OCSymbolWithSubstitution) {
                    this.myMemoization = this.myMemoization.substitute(((OCSymbolWithSubstitution)((Object)symbol)).getSubstitution());
                }
                List symbols = this.myMemoization.doResolveToSymbols(reference, this.myOnlyTypes, false);
                if (this.myResolveSpecialization) {
                    symbols = reference.resolveTemplateSpecialization(this.myMemoization, symbols);
                }
                List<OCTypeArgument> oldArguments = this.myArguments;
                if (this.myArguments == null && reference.getQualifiedName() instanceof OCQualifiedNameWithArguments) {
                    this.myArguments = ((OCQualifiedNameWithArguments)reference.getQualifiedName()).getArguments();
                }
                ContainerUtil.process((List)symbols, (Processor)this);
                this.myArguments = oldArguments;
                this.myMemoization = oldMemoization;
            } else if (type instanceof OCAutoType) {
                OCExpressionSymbol expressionSymbol = ((OCAutoType)type).getExpressionSymbol();
                if (expressionSymbol != null) {
                    this.processType(expressionSymbol, expressionSymbol.getResolvedType(this.myMemoization.substitute(((OCAutoType)type).getSubstitution())));
                }
            } else if (type instanceof OCMagicType) {
                this.myAnswer.add(new OCTypeParameterTypeSymbol(null, 0L, symbol.getName(), null, Collections.emptyList(), null, false, true, true));
            }
        }

        @NotNull
        public List<OCSymbol> getAnswer() {
            if (this.myAnswer.size() == 0) {
                return Collections.emptyList();
            }
            this.myAnswer.trimToSize();
            return this.myAnswer;
        }
    }

    private static class SymbolMembersProcessor
    implements Processor<OCSymbol> {
        private final String myName;
        private final Processor<OCSymbol> myProcessor;
        private final boolean myOnlySimpleNamespaces;
        private final boolean myOnlyTypes;
        private OCResolveContext myMemoization;
        private OCSymbolReference myReference;
        private final THashSet<OCSymbol> myProcessed;

        SymbolMembersProcessor(@Nullable String name2, Processor<OCSymbol> processor2, boolean onlySimpleNamespaces, boolean onlyTypes, @NotNull OCResolveContext context, @Nullable OCSymbolReference reference) {
            this.myName = name2;
            this.myProcessor = processor2;
            this.myOnlySimpleNamespaces = onlySimpleNamespaces;
            this.myOnlyTypes = onlyTypes;
            this.myMemoization = context;
            this.myReference = reference;
            this.myProcessed = new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<OCSymbol>(){

                public int computeHashCode(OCSymbol object) {
                    return object.hashCode();
                }

                public boolean equals(OCSymbol o1, OCSymbol o2) {
                    return o1 == o2;
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean process(OCSymbol symbol) {
            if (!this.myProcessed.add((Object)symbol)) {
                return true;
            }
            OCResolveContext oldMemoization = this.myMemoization;
            try {
                this.myMemoization = this.myMemoization.useFor(symbol);
                if (symbol instanceof OCNamespaceSymbol) {
                    boolean bl = OCStructType.processMembersOfNamespace((OCNamespaceSymbol)symbol, this.myName, true, !this.myOnlySimpleNamespaces, true, this.myOnlyTypes, this.myProcessor, this.myReference, true, this.myMemoization);
                    return bl;
                }
                if (symbol instanceof OCTypeParameterSymbol) {
                    OCTypeParameterTypeSymbol qualifierTypeParameter;
                    OCTypeParameterTypeSymbol oCTypeParameterTypeSymbol = qualifierTypeParameter = symbol instanceof OCTypeParameterTypeSymbol ? (OCTypeParameterTypeSymbol)symbol : null;
                    if (!this.myProcessor.process((Object)new OCTypeParameterTypeSymbol(null, 0L, this.myName, qualifierTypeParameter, null, Collections.emptyList(), null, false, true, true))) {
                        boolean bl = false;
                        return bl;
                    }
                    if (!this.myProcessor.process((Object)new OCDeclaratorSymbolImpl(this.myName, new OCMagicType(this.myName), OCSymbolKind.TEMPLATE_VALUE_PARAMETER))) {
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.myMemoization = oldMemoization;
            }
        }
    }

    public static class NameWithToken {
        public final String name;
        public final String typeToken;

        public NameWithToken(String name2, String typeToken) {
            this.name = name2;
            this.typeToken = typeToken;
        }
    }

    private static class ResultInfo {
        final List<OCSymbol> symbols;
        final Set<OCTypeParameterSymbol> typeDependencies;
        final long offset;

        private ResultInfo(@NotNull List<OCSymbol> symbols, @Nullable Set<OCTypeParameterSymbol> typeDependencies, long offset) {
            this.symbols = symbols;
            this.typeDependencies = typeDependencies;
            this.offset = offset;
        }
    }

    private static class ReferenceInfo {
        @NotNull
        final OCSymbolReference symbolReference;
        @NotNull
        final OCTypeSubstitution substitution;
        private final boolean resolveSpecialization;

        private ReferenceInfo(@NotNull OCSymbolReference symbolReference, @NotNull OCTypeSubstitution substitution, boolean resolveSpecialization) {
            this.symbolReference = symbolReference;
            this.substitution = substitution;
            this.resolveSpecialization = resolveSpecialization;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ReferenceInfo info = (ReferenceInfo)o;
            if (this.resolveSpecialization != info.resolveSpecialization) {
                return false;
            }
            if (!this.symbolReference.equals(info.symbolReference)) {
                return false;
            }
            return this.substitution.equals(info.substitution);
        }

        public int hashCode() {
            int result = this.symbolReference.hashCode();
            result = 31 * result + this.substitution.hashCode();
            result = 31 * result + (this.resolveSpecialization ? 1 : 0);
            return result;
        }
    }

    public static class LambdaLocalReference
    extends OCSymbolReference {
        private OCLambdaExpressionSymbol myLambda;
        private long myOffset;
        private OCSymbolReference myParentScopeReference;

        public LambdaLocalReference() {
        }

        public LambdaLocalReference(@NotNull OCQualifiedName qualifiedName, long offset, @NotNull OCLambdaExpressionSymbol lambda2, @NotNull SymbolFilter filter, @NotNull OCSymbolReference parentScopeReference) {
            super(qualifiedName, filter);
            this.myOffset = offset;
            this.myLambda = lambda2;
            this.myParentScopeReference = parentScopeReference;
        }

        @Override
        protected Object getCacheDependency(@NotNull Project project2) {
            return PsiModificationTracker.MODIFICATION_COUNT;
        }

        @Override
        public OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new LambdaLocalReference(this.getQualifiedName().getQualifier(), this.myOffset, this.myLambda, filter, this.myParentScopeReference);
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myLambda.getContainingFile();
        }

        @Override
        public long getOffset() {
            return this.myOffset;
        }

        @Override
        public OCSymbolReference cloneWithOffset(@NotNull OCSymbolReference reference) {
            return this;
        }

        @Override
        public OCSymbolReference cloneWithArguments(@NotNull List<OCTypeArgument> arguments) {
            return new LambdaLocalReference(new OCQualifiedNameWithArguments(this.myQualifiedName, arguments), this.myOffset, this.myLambda, this.myFilter, this.myParentScopeReference);
        }

        @Override
        @NotNull
        public OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName name2) {
            return new LambdaLocalReference(name2, this.myOffset, this.myLambda, this.myFilter, this.myParentScopeReference);
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
            if (!super.deepEqualStep(c, first, second)) {
                return false;
            }
            LambdaLocalReference f = (LambdaLocalReference)first;
            LambdaLocalReference s = (LambdaLocalReference)second;
            if (!Comparing.equal((Object)f.myLambda, (Object)s.myLambda)) {
                return false;
            }
            return Comparing.equal((Object)f.myOffset, (Object)s.myOffset);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myLambda != null ? this.myLambda.hashCode() : 0);
            result = (int)((long)(31 * result) + this.myOffset);
            result = 31 * result + (this.myParentScopeReference != null ? this.myParentScopeReference.hashCode() : 0);
            return result;
        }

        @Override
        @NotNull
        public List<OCSymbol> doResolve(@NotNull OCResolveContext context, boolean onlyTypes, boolean resolveSpecialization) {
            OCSymbol symbol;
            if (this.myLambda != null && this.myQualifiedName.getQualifier() == null && (symbol = OCResolveUtil.resolveLambdaLocalSymbolInTable(this.myLambda.getLocalVarsAndParams(), this.myQualifiedName, this.myOffset)) != null) {
                return Collections.singletonList(symbol);
            }
            return this.myParentScopeReference.doResolve(context, onlyTypes, resolveSpecialization);
        }

        public String toString() {
            return "LAMBDA LOCAL (" + this.getQualifiedName() + ")";
        }
    }

    public static class TemplateArgumentsReference
    extends GlobalReference {
        private boolean isSpecialization;

        public TemplateArgumentsReference() {
        }

        public TemplateArgumentsReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset, SymbolFilter filter, boolean specialization) {
            super(qualifiedName, symbolContext, file, complexOffset, filter);
            this.isSpecialization = specialization;
        }

        @Override
        public OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new TemplateArgumentsReference(this.getQualifiedName().getQualifier(), this.getSymbolContext(), this.getVirtualFile(), this.getOffset(), filter, this.isSpecialization);
        }

        @Override
        @NotNull
        public OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName name2) {
            return new TemplateArgumentsReference(name2, this.getSymbolContext(), this.getVirtualFile(), this.getOffset(), this.myFilter, this.isSpecialization);
        }

        public boolean isSpecialization() {
            return this.isSpecialization;
        }

        @Override
        public String toString() {
            return "TEMPLATE (" + this.getQualifiedName() + "):" + this.getSymbolContext();
        }
    }

    public static class BaseClauseReference
    extends GlobalReference {
        public BaseClauseReference() {
        }

        public BaseClauseReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset, SymbolFilter filter) {
            super(qualifiedName, symbolContext, file, complexOffset, filter);
        }

        @Override
        public OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new BaseClauseReference(this.getQualifiedName().getQualifier(), this.getSymbolContext(), this.getVirtualFile(), this.getOffset(), filter);
        }

        @Override
        @NotNull
        public OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName name2) {
            return new BaseClauseReference(name2, this.getSymbolContext(), this.getVirtualFile(), this.getOffset(), this.myFilter);
        }

        @Override
        public String toString() {
            return "BASE CLAUSE (" + this.getQualifiedName() + "):" + this.getSymbolContext();
        }
    }

    public static class LocalReference
    extends OCSymbolReference {
        @Nullable
        private PsiElement myLocalContext;

        private LocalReference(@NotNull OCQualifiedName qualifiedName, @Nullable PsiElement localContext, SymbolFilter filter) {
            super(qualifiedName, filter);
            this.myLocalContext = localContext;
        }

        @Override
        protected Object getCacheDependency(@NotNull Project project2) {
            return PsiModificationTracker.MODIFICATION_COUNT;
        }

        @Nullable
        public PsiElement getLocalContext() {
            return this.myLocalContext;
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            return this.myLocalContext == null ? null : OCElementUtil.getVirtualFile(this.myLocalContext);
        }

        @Override
        public long getOffset() {
            return this.myLocalContext != null ? OCSymbolOffsetUtil.getComplexOffset(this.myLocalContext) : -1L;
        }

        @Override
        public OCSymbolReference getSymbolReferenceToQualifier() {
            SymbolKindFilter filter = this.getFilterForQualifier();
            return new LocalReference(this.getQualifiedName().getQualifier(), this.myLocalContext, filter);
        }

        @Override
        @NotNull
        public OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName name2) {
            return new LocalReference(name2, this.myLocalContext, this.myFilter);
        }

        @Override
        public OCSymbolReference cloneWithOffset(@NotNull OCSymbolReference reference) {
            return this;
        }

        @Override
        public OCSymbolReference cloneWithArguments(@NotNull List<OCTypeArgument> arguments) {
            return new LocalReference(new OCQualifiedNameWithArguments(this.myQualifiedName, arguments), this.myLocalContext, this.myFilter);
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
            if (!super.deepEqualStep(c, first, second)) {
                return false;
            }
            LocalReference f = (LocalReference)first;
            LocalReference s = (LocalReference)second;
            return Comparing.equal((Object)f.myLocalContext, (Object)s.myLocalContext);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myLocalContext != null ? this.myLocalContext.hashCode() : 0);
            return result;
        }

        @Override
        @NotNull
        public List<OCSymbol> doResolve(@NotNull OCResolveContext context, boolean onlyTypes, boolean resolveSpecialization) {
            OCSymbol thisSelfSuper;
            if (this.myLocalContext != null && (thisSelfSuper = OCThisSelfSuperSymbol.tryResolveThisSelfSuper(this.getQualifiedName().toString(), this.myLocalContext, context)) != null) {
                return Collections.singletonList(thisSelfSuper);
            }
            PsiElement oldElement = context.getElement();
            context.setElement(this.myLocalContext != null ? this.myLocalContext : oldElement);
            List<OCSymbol> symbols = super.doResolve(context, onlyTypes, resolveSpecialization);
            context.setElement(oldElement);
            return symbols;
        }

        public String toString() {
            return "LOCAL (" + this.getQualifiedName() + "):" + this.myLocalContext;
        }
    }

    public static class UsingReference
    extends GlobalReference {
        private long myUsingOffset;
        private VirtualFile myUsingFile;

        public UsingReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile usageFile, long usageOffset, SymbolFilter filter, @Nullable VirtualFile usingFile, long usingOffset) {
            super(qualifiedName, symbolContext, usageFile, usageOffset, filter);
            this.myUsingOffset = usingOffset;
            this.myUsingFile = usingFile;
        }

        public long getUsingOffset() {
            return this.myUsingOffset;
        }

        public VirtualFile getUsingFile() {
            return this.myUsingFile;
        }
    }

    public static class GlobalReference
    extends OCSymbolReference {
        @Nullable
        private transient Object myVirtualFileOrSymbolContext;
        private long myComplexOffset;

        public GlobalReference() {
        }

        private GlobalReference(@NotNull OCQualifiedName qualifiedName, @Nullable Object virtualFileOrSymbolContext, long complexOffset, @NotNull SymbolFilter filter) {
            super(qualifiedName, filter);
            if (virtualFileOrSymbolContext instanceof OCSymbolWithQualifiedName && this.resolvesBelow(qualifiedName, (OCSymbolWithQualifiedName)virtualFileOrSymbolContext, complexOffset)) {
                complexOffset = -1L;
            }
            this.myVirtualFileOrSymbolContext = virtualFileOrSymbolContext;
            this.myComplexOffset = complexOffset;
        }

        public GlobalReference(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, @Nullable VirtualFile file, long complexOffset, SymbolFilter filter) {
            super(qualifiedName, filter);
            if (this.resolvesBelow(qualifiedName, symbolContext, complexOffset)) {
                complexOffset = -1L;
            }
            if (symbolContext == null) {
                this.myVirtualFileOrSymbolContext = file;
            } else {
                this.myVirtualFileOrSymbolContext = symbolContext;
                VirtualFile contextFile = symbolContext.getContainingFile();
                if (contextFile == null || !contextFile.equals(file)) {
                    complexOffset = -1L;
                }
            }
            this.myComplexOffset = complexOffset;
        }

        private boolean resolvesBelow(@NotNull OCQualifiedName qualifiedName, @Nullable OCSymbolWithQualifiedName symbolContext, long complexOffset) {
            if (qualifiedName.getQualifier() instanceof OCQualifiedNameWithArguments) {
                return true;
            }
            if (symbolContext != null && complexOffset > symbolContext.getComplexOffset() && !(this instanceof TemplateArgumentsReference)) {
                for (OCSymbolWithQualifiedName parent = symbolContext; parent != null; parent = parent.getParent()) {
                    if (!(parent instanceof OCTemplateSymbol) || !((OCTemplateSymbol)((Object)parent)).isTemplateSymbol()) continue;
                    return true;
                }
            }
            return false;
        }

        @Nullable
        public OCSymbolWithQualifiedName getSymbolContext() {
            return this.myVirtualFileOrSymbolContext instanceof OCSymbolWithQualifiedName ? (OCSymbolWithQualifiedName)this.myVirtualFileOrSymbolContext : null;
        }

        @Override
        @Nullable
        public VirtualFile getVirtualFile() {
            if (this.myVirtualFileOrSymbolContext instanceof VirtualFile) {
                return (VirtualFile)this.myVirtualFileOrSymbolContext;
            }
            if (this.getSymbolContext() != null) {
                return this.getSymbolContext().getContainingFile();
            }
            return null;
        }

        @Override
        public long getOffset() {
            return this.myComplexOffset;
        }

        @Override
        public OCSymbolReference cloneWithOffset(@NotNull OCSymbolReference reference) {
            OCQualifiedName name2 = this.myQualifiedName.cloneWithOffset(reference);
            if (this.getVirtualFile() != null && !Comparing.equal((Object)this.getVirtualFile(), (Object)reference.getVirtualFile())) {
                return new GlobalReference(name2, this.myVirtualFileOrSymbolContext, -1L, this.myFilter);
            }
            if (reference.getOffset() > this.myComplexOffset || reference.getOffset() == -1L) {
                return new GlobalReference(name2, this.myVirtualFileOrSymbolContext, reference.getOffset(), this.myFilter);
            }
            return this;
        }

        @Override
        public OCSymbolReference cloneWithArguments(@NotNull List<OCTypeArgument> arguments) {
            return new GlobalReference(new OCQualifiedNameWithArguments(this.myQualifiedName, arguments), this.myVirtualFileOrSymbolContext, this.myComplexOffset, this.myFilter);
        }

        public void setSymbolContext(@Nullable OCSymbolWithQualifiedName symbolContext, long originalOffset) {
            VirtualFile oldVirtualFile = this.getVirtualFile();
            this.myVirtualFileOrSymbolContext = symbolContext;
            long l = this.myComplexOffset = this.resolvesBelow(this.myQualifiedName, symbolContext, originalOffset) ? -1L : originalOffset;
            if (this.myComplexOffset != -1L) {
                OCLog.LOG.assertTrue(Comparing.equal((Object)oldVirtualFile, (Object)this.getVirtualFile()), (Object)"Virtual file changed but the complex offset is not updated");
            }
        }

        @Override
        public OCSymbolReference getSymbolReferenceToQualifier() {
            return new GlobalReference(this.getQualifiedName().getQualifier(), this.myVirtualFileOrSymbolContext, this.myComplexOffset, this.getFilterForQualifier());
        }

        @Override
        @NotNull
        public OCSymbolReference createReferenceInSameContext(@NotNull OCQualifiedName name2) {
            return new GlobalReference(name2, this.myVirtualFileOrSymbolContext, this.myComplexOffset, this.myFilter);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            GlobalReference reference = (GlobalReference)o;
            if (this.myComplexOffset != reference.myComplexOffset) {
                return false;
            }
            return !(this.myVirtualFileOrSymbolContext != null ? !this.myVirtualFileOrSymbolContext.equals(reference.myVirtualFileOrSymbolContext) : reference.myVirtualFileOrSymbolContext != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myVirtualFileOrSymbolContext != null ? this.myVirtualFileOrSymbolContext.hashCode() : 0);
            result = 31 * result + (int)(this.myComplexOffset ^ this.myComplexOffset >>> 32);
            return result;
        }

        public String toString() {
            return "GLOBAL (" + this.getQualifiedName() + "):" + this.myVirtualFileOrSymbolContext + ": " + OCSymbolOffsetUtil.getTextOffset(this.myComplexOffset);
        }

        @Override
        public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCSymbolReference first, @NotNull OCSymbolReference second) {
            if (!super.deepEqualStep(c, first, second)) {
                return false;
            }
            GlobalReference f = (GlobalReference)first;
            GlobalReference s = (GlobalReference)second;
            if (f.myComplexOffset != s.myComplexOffset) {
                return false;
            }
            return !(this.myVirtualFileOrSymbolContext instanceof VirtualFile ? !Comparing.equal((Object)f.myVirtualFileOrSymbolContext, (Object)s.myVirtualFileOrSymbolContext) : !c.equalObjects(f.myVirtualFileOrSymbolContext, s.myVirtualFileOrSymbolContext));
        }

        @Nullable
        public Object getVirtualFileOrSymbolContext() {
            return this.myVirtualFileOrSymbolContext;
        }

        public void setVirtualFileOrSymbolContext(@Nullable Object virtualFileOrSymbolContext) {
            this.myVirtualFileOrSymbolContext = virtualFileOrSymbolContext;
        }
    }

    private static enum SpecializationCheckType {
        ALWAYS_CHECK,
        NEVER_CHECK,
        SKIP;

    }

    public static enum SymbolKindFilter implements SymbolFilter
    {
        NONE,
        ONLY_NAMESPACE,
        ONLY_NAMESPACE_LIKE,
        ONLY_STRUCT,
        ONLY_ENUM,
        ONLY_UNION;


        public static SymbolFilter parse(String name2) {
            if (name2 == null) {
                return NONE;
            }
            if (name2.equals("struct") || name2.equals("class")) {
                return ONLY_STRUCT;
            }
            if (name2.equals("enum")) {
                return ONLY_ENUM;
            }
            if (name2.equals("union")) {
                return ONLY_UNION;
            }
            return NONE;
        }

        @Override
        public boolean accept(OCSymbol symbol) {
            OCSymbolKind kind = symbol.getKind();
            switch (this) {
                case NONE: {
                    return true;
                }
                case ONLY_NAMESPACE: {
                    return kind == OCSymbolKind.NAMESPACE || kind == OCSymbolKind.NAMESPACE_ALIAS;
                }
                case ONLY_NAMESPACE_LIKE: {
                    return kind.canBeNamespace() || kind == OCSymbolKind.USING_SYMBOL_ALIAS || kind == OCSymbolKind.SYMBOL_USING_SYMBOL;
                }
                case ONLY_STRUCT: {
                    return kind == OCSymbolKind.STRUCT || kind == OCSymbolKind.USING_SYMBOL_ALIAS || kind == OCSymbolKind.SYMBOL_USING_SYMBOL;
                }
                case ONLY_ENUM: {
                    return kind == OCSymbolKind.ENUM || kind == OCSymbolKind.USING_SYMBOL_ALIAS || kind == OCSymbolKind.SYMBOL_USING_SYMBOL;
                }
                case ONLY_UNION: {
                    return kind == OCSymbolKind.UNION || kind == OCSymbolKind.USING_SYMBOL_ALIAS || kind == OCSymbolKind.SYMBOL_USING_SYMBOL;
                }
            }
            return false;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    public static class TrueSymbolFilter
    implements SymbolFilter {
        @Override
        public boolean accept(OCSymbol symbol) {
            return true;
        }

        public String toString() {
            return "*any symbol*";
        }
    }

    @FunctionalInterface
    public static interface SymbolFilter {
        public static final TrueSymbolFilter NONE = new TrueSymbolFilter();

        public boolean accept(OCSymbol var1);
    }
}

