/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedNameImpl;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNamespaceAliasSymbol
extends OCSymbolWithQualifiedNameImpl {
    private OCSymbolReference myNamespaceReference;
    @Nullable
    private ComplexTextRange myScope;

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCNamespaceAliasSymbol f = (OCNamespaceAliasSymbol)first;
        OCNamespaceAliasSymbol s = (OCNamespaceAliasSymbol)second;
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        return c.equalObjects(f.myNamespaceReference, s.myNamespaceReference);
    }

    public OCNamespaceAliasSymbol() {
    }

    public OCNamespaceAliasSymbol(@Nullable VirtualFile file, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName name2, OCSymbolReference ref, @Nullable ComplexTextRange scope) {
        super(file, offset, parent, name2, Collections.emptyList(), null);
        this.myScope = scope;
        this.myNamespaceReference = ref;
    }

    public OCSymbolReference getNamespaceReference() {
        return this.myNamespaceReference;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.NAMESPACE_ALIAS;
    }

    @Override
    @Nullable
    public ComplexTextRange getScope() {
        return this.myScope;
    }

    @Override
    public void setScope(@NotNull ComplexTextRange scope) {
        this.myScope = scope;
    }

    @Override
    public boolean isGlobal() {
        return this.myScope == null;
    }
}

