/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNumericType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.util.OCDebugUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCSymbolWithQualifiedNameImpl
extends OCSymbolImpl
implements OCSymbolWithQualifiedName {
    @NotNull
    private OCQualifiedName myQualifiedName;
    @Nullable
    protected OCSymbolWithQualifiedName myParent;
    @Nullable
    protected OCVisibility myVisibility;

    public OCSymbolWithQualifiedNameImpl() {
    }

    public OCSymbolWithQualifiedNameImpl(@Nullable VirtualFile file, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName qualifiedName, @NotNull List<String> attributes, @Nullable OCVisibility visibility) {
        super(file, offset, qualifiedName.getName(), attributes);
        this.myParent = parent;
        this.myQualifiedName = qualifiedName;
        this.myVisibility = visibility;
    }

    @Override
    @NotNull
    public OCQualifiedName getQualifiedName() {
        return this.myQualifiedName;
    }

    @Override
    @NotNull
    public String getNameWithParent(@NotNull OCResolveContext context) {
        if (this.myQualifiedName.getQualifier() != null) {
            return this.myQualifiedName.getFullName(context);
        }
        if (this.myParent != null) {
            return this.myParent.getName() + "::" + this.myName;
        }
        return this.myName;
    }

    @Override
    @Nullable
    public OCVisibility getVisibility() {
        return this.myVisibility;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCSymbolWithQualifiedNameImpl f = (OCSymbolWithQualifiedNameImpl)first;
        OCSymbolWithQualifiedNameImpl s = (OCSymbolWithQualifiedNameImpl)second;
        if (f.myVisibility != s.myVisibility) {
            return false;
        }
        if (!c.equalObjects(f.myQualifiedName, s.myQualifiedName)) {
            return false;
        }
        return c.equalObjects(f.myParent, s.myParent);
    }

    @Deprecated
    public static boolean resolvedNamesEqual(@NotNull Project project2, OCSymbolWithQualifiedName self, OCSymbolWithQualifiedName symbol) {
        if (self.equals(symbol)) {
            return true;
        }
        OCQualifiedName qualifiedName = symbol.getQualifiedName();
        if (!Comparing.equal((String)self.getQualifiedName().getName(), (String)qualifiedName.getName())) {
            return false;
        }
        if (self.isPredeclaration() || symbol.isPredeclaration()) {
            return true;
        }
        OCResolveContext context = OCResolveContext.forSymbol(self, project2);
        if (symbol instanceof OCStructSymbol && ((OCStructSymbol)symbol).isSpecialization() || self instanceof OCStructSymbol && ((OCStructSymbol)self).isSpecialization()) {
            return Comparing.equal((Object)self.getResolvedQualifiedNameWithoutInlineNamespaces(context), (Object)symbol.getResolvedQualifiedNameWithoutInlineNamespaces(context));
        }
        return Comparing.equal((Object)self.getResolvedQualifiedNameWithoutArguments(context), (Object)symbol.getResolvedQualifiedNameWithoutArguments(context));
    }

    public static boolean resolvedNamesEqual(OCSymbolWithQualifiedName self, OCSymbolWithQualifiedName symbol, @NotNull OCResolveContext context) {
        if (DeepEqual.equalObjects(self, symbol)) {
            return true;
        }
        OCQualifiedName qualifiedName = symbol.getQualifiedName();
        if (!Comparing.equal((String)self.getQualifiedName().getName(), (String)qualifiedName.getName())) {
            return false;
        }
        if (self.isPredeclaration() || symbol.isPredeclaration()) {
            return true;
        }
        OCQualifiedName n1 = self.getResolvedQualifiedName(false, context, true, true);
        OCQualifiedName n2 = symbol.getResolvedQualifiedName(false, context, true, true);
        return OCQualifiedName.areResolvedNamesEquals(n1, n2, context);
    }

    @Nullable
    public static OCQualifiedName getResolvedQualifiedName(@NotNull OCSymbolWithQualifiedName self, boolean withoutInlineNamespaces, @NotNull OCResolveContext context, boolean processTypesOnly, boolean appendArguments, boolean resolveArguments, boolean removeDefaultArguments, boolean treatNonMemberOperators, @Nullable Consumer<OCSymbolWithQualifiedName> observer) {
        OCQualifiedName result = null;
        if (self.getQualifiedName().isAbsolute()) {
            result = self.getQualifiedName();
        } else {
            OCStructSymbol operatorParent = treatNonMemberOperators ? context.getNonMemberOperatorParent(self) : null;
            OCQualifiedName qualifier = self.getQualifiedName().getQualifier();
            OCSymbolWithQualifiedName baseParent = self.getQualifierParent();
            if (qualifier != null && operatorParent == null) {
                OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(qualifier, baseParent, self.getContainingFile(), self.getComplexOffset(), OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
                List<OCSymbol> possibleSymbols = context.resolveToSymbols(reference, true, processTypesOnly);
                for (OCSymbol possibleSymbol : possibleSymbols) {
                    if (!(possibleSymbol instanceof OCNamespaceSymbol)) continue;
                    OCNamespaceSymbol parent = (OCNamespaceSymbol)possibleSymbol;
                    OCQualifiedName resolvedQualifier = parent.getResolvedQualifiedName(withoutInlineNamespaces, context, processTypesOnly, appendArguments, true, removeDefaultArguments, treatNonMemberOperators, observer);
                    OCQualifiedName name2 = OCQualifiedName.with(resolvedQualifier, self.getName());
                    if (result != null && result.getDepth() >= name2.getDepth()) continue;
                    result = name2;
                }
            } else {
                OCSymbolWithQualifiedName parent;
                OCSymbolWithQualifiedName oCSymbolWithQualifiedName = parent = operatorParent != null ? operatorParent : baseParent;
                while (withoutInlineNamespaces && parent instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)parent).isInlineNamespace() || parent instanceof OCStructSymbol && parent.isTransparentUnion()) {
                    parent = parent.getParent();
                }
                result = parent == null ? OCQualifiedName.with(OCQualifiedName.GLOBAL, self.getQualifiedName().getName()) : OCQualifiedName.with(parent.getResolvedQualifiedName(withoutInlineNamespaces, context, processTypesOnly, appendArguments, true, removeDefaultArguments, treatNonMemberOperators, observer), self.getName());
            }
        }
        if (observer != null) {
            observer.consume((Object)self);
        }
        if (self instanceof OCTemplateSymbol && appendArguments) {
            List<OCTypeArgument> arguments = OCTypeNameVisitor.getTypeArguments((OCTemplateSymbol)((Object)self), resolveArguments, false, removeDefaultArguments, context);
            if (!(result == null || arguments.isEmpty() && ((OCTemplateSymbol)((Object)self)).getTemplateSpecialization() == null)) {
                return new OCQualifiedNameWithArguments(result, arguments);
            }
        }
        return result;
    }

    public void setQualifier(OCQualifiedName qualifier) {
        this.myQualifiedName = this.myQualifiedName.changeQualifier(qualifier);
    }

    public static boolean isLocalInFile(@NotNull OCSymbolWithQualifiedName self, @NotNull OCResolveContext context) {
        if ((self instanceof OCDeclaratorSymbol || self instanceof OCFunctionSymbol) && self.isFriendOrStatic() && self.getContainingFile() != null && OCFileImpl.isSourceCodeFile(self.getContainingFile().getName())) {
            OCSymbolKind kind = self.getResolvedKind(context);
            return kind.isGlobalVariable() || kind.isFunction() && self.getParent() == null;
        }
        return false;
    }

    @Nullable
    public static OCSymbolWithQualifiedName getQualifierParent(@NotNull OCSymbolWithQualifiedName self) {
        OCSymbolWithQualifiedName result = self.getParent();
        if (self.isFriend()) {
            while (result instanceof OCStructSymbol) {
                result = result.getParent();
            }
        }
        return result;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return OCIcons.getVisibilityIcon(this.getVisibility(), super.getBaseIcon());
    }

    @Nullable
    public static OCSymbolWithQualifiedName getResolvedOwner(@NotNull OCSymbolWithQualifiedName self, @NotNull OCResolveContext context, boolean checkNonMemberOperators) {
        OCStructSymbol operatorParent;
        if (checkNonMemberOperators && (operatorParent = context.getNonMemberOperatorParent(self)) != null) {
            return operatorParent;
        }
        OCQualifiedName qualifier = self.getQualifiedName().getQualifier();
        OCSymbolWithQualifiedName baseParent = self.getQualifierParent();
        if (qualifier != null) {
            OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(qualifier, baseParent, self.getContainingFile(), self.getComplexOffset(), OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
            List<OCSymbol> possibleSymbols = reference.resolveToSymbols(true, true, true, context);
            for (OCSymbol possibleSymbol : possibleSymbols) {
                OCNamespaceSymbol namespace;
                if (!(possibleSymbol instanceof OCNamespaceSymbol) || (namespace = (OCNamespaceSymbol)possibleSymbol).isPredeclaration()) continue;
                CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
                namespace.processMembers(self.getName(), (Processor<? super OCSymbol>)processor2);
                if (!processor2.isFound()) continue;
                return namespace;
            }
            return null;
        }
        return baseParent;
    }

    @Override
    @Nullable
    public OCSymbolWithQualifiedName getParent() {
        return this.myParent;
    }

    @Override
    public OCSymbol dropSubstitution() {
        return OCTypeSubstitution.cloneWithSubstitution(this, OCTypeSubstitution.ID, this.getParent());
    }

    @Override
    @Nullable
    public OCSymbol getDefinitionSymbol(@NotNull Project project2) {
        if (this.isPredeclaration()) {
            CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
            this.processSameSymbols((Processor<OCSymbol>)new FilteringProcessor(OCSymbol.NON_PREDEFINITION_CONDITION, (Processor)processor2), project2);
            return (OCSymbol)processor2.getFoundValue();
        }
        return this;
    }

    @Override
    @NotNull
    public String getKindUppercase(@NotNull OCCompilationContext context) {
        OCResolveContext resolveContext = OCResolveContext.forSymbol(this, context.getProject());
        return this.getResolvedKind(resolveContext).getNameUppercase();
    }

    public static OCSymbolKind getResolvedKind(@NotNull OCSymbolWithQualifiedName self, @NotNull OCResolveContext context) {
        OCSymbolKind actualKind = self.getKind();
        if (actualKind.isGlobalVariable() && self.getQualifier() != null) {
            OCSymbolReference.GlobalReference reference = OCSymbolReference.getGlobalReference(self.getQualifier(), self.getParent(), self.getContainingFile(), self.getComplexOffset(), OCSymbolReference.SymbolKindFilter.ONLY_NAMESPACE_LIKE);
            List<OCSymbol> possibleSymbols = reference.resolveToSymbols(true, true, context);
            for (OCSymbol possibleSymbol : possibleSymbols) {
                if (!possibleSymbol.getKind().isStructLike()) continue;
                actualKind = OCSymbolKind.STRUCT_FIELD;
                break;
            }
        }
        return actualKind;
    }

    @Override
    public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project2) {
        return this.processSameSymbols(processor2, null, project2);
    }

    public static boolean processSameSymbols(final @NotNull OCSymbolWithQualifiedName self, final Processor<OCSymbol> processor2, @Nullable PsiFile file, @NotNull Project project2) {
        final Class<?> myClass = self.getClass();
        OCDebugUtil.tryDebugWaitForSymbol(self);
        if (!processor2.process((Object)self)) {
            return false;
        }
        if (!self.isGlobal() || self.isUnnamed()) {
            return true;
        }
        final OCResolveContext context = OCResolveContext.forSymbol(self, project2);
        Processor<OCSymbol> _processor = new Processor<OCSymbol>(){
            private OCQualifiedName myResolvedName;
            private OCType myResolvedType;

            public boolean process(OCSymbol symbol) {
                ProgressManager.checkCanceled();
                if (symbol.equals(self)) {
                    return true;
                }
                if (!symbol.getClass().equals(myClass)) {
                    return true;
                }
                if (!(symbol instanceof OCSymbolWithQualifiedName)) {
                    return true;
                }
                if (this.myResolvedName == null) {
                    this.myResolvedName = self.getResolvedQualifiedNameWithoutArguments(context);
                    if (this.myResolvedName == null) {
                        return false;
                    }
                }
                if (this.myResolvedType == null) {
                    this.myResolvedType = self.getType().resolve(context);
                }
                if (!OCSymbolWithQualifiedNameImpl.isSameSymbol(self, (OCSymbolWithQualifiedName)symbol, this.myResolvedName, this.myResolvedType, context)) {
                    return true;
                }
                OCDebugUtil.tryDebugWaitForSymbol(symbol);
                return processor2.process((Object)symbol);
            }
        };
        if (file != null) {
            OCQualifiedName name2 = self.getResolvedQualifiedName(context);
            if (name2 != null) {
                OCSymbolReference.GlobalReference ref = OCSymbolReference.getDummyGlobalReference(name2);
                return ref.processPossibleSymbols((Processor<OCSymbol>)((Processor)symbol -> symbol.equals(self) || processor2.process(symbol)), OCResolveContext.forPsi((PsiElement)file));
            }
            return true;
        }
        if (!self.isSynthetic()) {
            VirtualFile containingFile = self.getContainingFile();
            OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(_processor, symbol -> containingFile != null && containingFile.equals(symbol.getContainingFile()), Conditions.alwaysTrue());
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, orderedProcessor, self.getName());
            return orderedProcessor.finish();
        }
        return true;
    }

    @Override
    public boolean processAssociatedSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project2) {
        OCSymbol definitionSymbol;
        if (this.isPredeclaration() && (definitionSymbol = this.getDefinitionSymbol(project2)) != null && !processor2.process((Object)definitionSymbol)) {
            return false;
        }
        VirtualFile containingFile = this.getContainingFile();
        OCCommonProcessors.OrderedProcessor<OCSymbol> orderedProcessor = new OCCommonProcessors.OrderedProcessor<OCSymbol>(symbol -> symbol == this || processor2.process(symbol), symbol -> {
            VirtualFile curContainingFile = symbol.getContainingFile();
            return containingFile != null && curContainingFile != null && containingFile.getNameWithoutExtension().equals(curContainingFile.getNameWithoutExtension());
        }, Conditions.alwaysTrue());
        OCSearchUtil.processPredeclarations(this, orderedProcessor, project2);
        return orderedProcessor.finish();
    }

    @Override
    public boolean isSameSymbol(@Nullable OCSymbol symbol, @NotNull Project project2) {
        return this.isSameSymbol(symbol, OCResolveContext.forSymbol(this, project2));
    }

    public static boolean isSameSymbol(@NotNull OCSymbolWithQualifiedName self, @Nullable OCSymbol symbol, @NotNull OCResolveContext context) {
        if (symbol instanceof OCSymbolWithQualifiedName) {
            return OCSymbolWithQualifiedNameImpl.isSameSymbol(self, (OCSymbolWithQualifiedName)symbol, self.getResolvedQualifiedName(false, context, true, false), self.getType().resolve(context), context);
        }
        return false;
    }

    public static boolean isSameSymbol(@Nullable OCSymbolWithQualifiedName symbol1, @Nullable OCSymbolWithQualifiedName symbol2, @NotNull OCResolveContext context) {
        return symbol1 == null && symbol2 == null || symbol1 != null && symbol2 != null && symbol1.isSameSymbol((OCSymbol)symbol2, context);
    }

    private static boolean canBeEqual(@Nullable OCType t1, @Nullable OCType t2, boolean checkCV) {
        if (t1 == null || t2 == null) {
            return t1 == t2;
        }
        if (checkCV && t1.getCVQualifiers() != t2.getCVQualifiers()) {
            return false;
        }
        if (t1 instanceof OCReferenceType || t2 instanceof OCReferenceType) {
            return true;
        }
        if (t1 instanceof OCUnknownType || t2 instanceof OCUnknownType) {
            return false;
        }
        if (t1 instanceof OCMagicType || t2 instanceof OCMagicType) {
            return true;
        }
        if (t1 instanceof OCVoidType || t2 instanceof OCVoidType) {
            return t1 instanceof OCVoidType && t2 instanceof OCVoidType;
        }
        if (t1 instanceof OCObjectType || t2 instanceof OCObjectType) {
            return t1 instanceof OCObjectType && t2 instanceof OCObjectType;
        }
        if (t1 instanceof OCStructType || t2 instanceof OCStructType) {
            return t1 instanceof OCStructType && t2 instanceof OCStructType;
        }
        if (t1 instanceof OCNumericType || t2 instanceof OCNumericType) {
            return t1 instanceof OCNumericType && t2 instanceof OCNumericType && ((OCNumericType)t1).getCTypeId() == ((OCNumericType)t2).getCTypeId();
        }
        if (t1 instanceof OCFunctionType || t2 instanceof OCFunctionType) {
            if (!(t1 instanceof OCFunctionType) || !(t2 instanceof OCFunctionType)) {
                return false;
            }
            OCFunctionType ft1 = (OCFunctionType)t1;
            OCFunctionType ft2 = (OCFunctionType)t2;
            if (ft1.isVararg() != ft2.isVararg()) {
                return false;
            }
            List<OCType> types1 = ft1.getParameterTypes();
            List<OCType> types2 = ft2.getParameterTypes();
            if (types1.size() != types2.size()) {
                return false;
            }
            for (int i = 0; i < types1.size(); ++i) {
                if (OCSymbolWithQualifiedNameImpl.canBeEqual(types1.get(i), types2.get(i), false)) continue;
                return false;
            }
            return true;
        }
        if (t1 instanceof OCCppReferenceType) {
            if (!(t2 instanceof OCCppReferenceType)) {
                return false;
            }
            if (((OCCppReferenceType)t1).isRvalueRef() != ((OCCppReferenceType)t2).isRvalueRef()) {
                return false;
            }
            if (((OCCppReferenceType)t1).isReferenceToConst() != ((OCCppReferenceType)t2).isReferenceToConst()) {
                return false;
            }
            return OCSymbolWithQualifiedNameImpl.canBeEqual(((OCCppReferenceType)t1).getRefType(), ((OCCppReferenceType)t2).getRefType(), checkCV);
        }
        if (t1 instanceof OCPointerType) {
            if (!(t2 instanceof OCPointerType)) {
                return false;
            }
            return OCSymbolWithQualifiedNameImpl.canBeEqual(((OCPointerType)t1).getRefType(), ((OCPointerType)t2).getRefType(), checkCV);
        }
        return true;
    }

    private static boolean isSameSymbol(@NotNull OCSymbolWithQualifiedName self, OCSymbolWithQualifiedName symbol, @Nullable OCQualifiedName resolvedName, OCType resolvedType, @NotNull OCResolveContext context) {
        boolean friends;
        if (self.equals(symbol)) {
            return true;
        }
        if (self.getKind().isLocal() || symbol.getKind().isLocal()) {
            return false;
        }
        if (resolvedName == null) {
            return false;
        }
        OCResolveContext otherContext = OCResolveContext.forSymbol(symbol, context.getProject());
        if (!Comparing.equal((Object)self.getContainingFile(), (Object)symbol.getContainingFile()) && self.isLocalInFile(context) && symbol.isLocalInFile(otherContext)) {
            return false;
        }
        boolean bl = friends = self.isFriend() || symbol.isFriend();
        if (friends && !self.getName().equals(symbol.getName())) {
            return false;
        }
        if (symbol instanceof OCFunctionSymbol) {
            if (self instanceof OCFunctionSymbol) {
                if (symbol.isFriend() && symbol.isPredeclaration() && ((OCFunctionSymbol)symbol).isCppOperator()) {
                    return false;
                }
                if (!OCSymbolWithQualifiedNameImpl.canBeEqual(((OCFunctionSymbol)self).getTypeWithoutSubstitution(), ((OCFunctionSymbol)symbol).getTypeWithoutSubstitution(), true)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!resolvedName.equals(symbol.getResolvedQualifiedName(false, otherContext, true, false))) {
            return false;
        }
        if (symbol instanceof OCFunctionSymbol) {
            if (((OCFunctionSymbol)symbol).getParameterSymbols().size() != ((OCFunctionSymbol)self).getParameterSymbols().size()) {
                return ((OCFunctionSymbol)symbol).getType().hasNoParameters() && ((OCFunctionSymbol)self).getType().hasNoParameters();
            }
            OCType symbolType = symbol.getResolvedType(otherContext);
            OCTypeEqualityAfterResolvingVisitor typeEqualityVisitor = new OCTypeEqualityAfterResolvingVisitor(symbolType, true, context);
            if (resolvedType instanceof OCFunctionType && symbolType instanceof OCFunctionType) {
                return typeEqualityVisitor.isFunctionSignatureEqual(resolvedType);
            }
            return resolvedType.accept(typeEqualityVisitor);
        }
        return true;
    }

    @Override
    @Nullable
    public String getLocationString() {
        String result;
        if (this.isGlobal() && (result = this.guessLocationString()) != null) {
            return result;
        }
        return this.myFile == null ? null : this.myFile.getName();
    }

    @Nullable
    private String guessLocationString() {
        String result;
        ArrayList<String> guessedNameParts = new ArrayList<String>(2);
        boolean global = false;
        for (OCQualifiedName qualifier = this.myQualifiedName.getQualifier(); qualifier != null; qualifier = qualifier.getQualifier()) {
            if (qualifier == OCQualifiedName.GLOBAL) {
                global = true;
                break;
            }
            guessedNameParts.add(qualifier.getName());
        }
        if (!global) {
            for (OCSymbolWithQualifiedName parent = this.getQualifierParent(); parent != null; parent = parent.getQualifierParent()) {
                if (parent instanceof OCNamespaceSymbol && ((OCNamespaceSymbol)parent).isInlineNamespace()) continue;
                guessedNameParts.add(parent.getName());
            }
        }
        if (!(result = ContainerUtil.reverse(guessedNameParts).stream().filter(s -> s != null && !s.isEmpty() && !s.equals("<unnamed>") && !OCSymbolWithQualifiedNameImpl.isPossibleVersioningNamespace(s)).collect(Collectors.joining("::"))).isEmpty()) {
            return result;
        }
        return null;
    }

    private static boolean isPossibleVersioningNamespace(@NotNull String s) {
        return s.startsWith("__") || s.startsWith("_") && s.length() > 1 && Character.isUpperCase(s.charAt(1));
    }

    @Override
    public OCSymbol getAssociatedSymbol(@NotNull Project project2) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processAssociatedSymbols((Processor<OCSymbol>)finder, project2);
        return (OCSymbol)finder.getFoundValue();
    }
}

