/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedNameImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class OCTemplateSymbolImpl
extends OCSymbolWithQualifiedNameImpl
implements OCTemplateSymbol {
    OCTemplateSymbolImpl() {
    }

    OCTemplateSymbolImpl(@Nullable VirtualFile file, long offset, @Nullable OCSymbolWithQualifiedName parent, @NotNull OCQualifiedName qualifiedName, @NotNull List<String> attributes, @Nullable OCVisibility visibility) {
        super(file, offset, parent, qualifiedName, attributes, visibility);
    }

    public static int getRequiredTemplateArgumentsCnt(@NotNull OCTemplateSymbol symbol) {
        int requiredArgumentsCnt = 0;
        for (OCTypeParameterSymbol param : symbol.getTemplateParameters()) {
            if (param.getDefaultValue() != null) break;
            ++requiredArgumentsCnt;
        }
        return symbol.isVariadicTemplate() ? requiredArgumentsCnt - 1 : requiredArgumentsCnt;
    }

    @Override
    public int getRequiredTemplateArgumentsCnt() {
        return OCTemplateSymbolImpl.getRequiredTemplateArgumentsCnt(this);
    }

    @Override
    public boolean isSpecialization() {
        return this.getTemplateSpecialization() != null;
    }

    @Override
    public boolean isExplicitInstantiation() {
        return this.isTemplateSymbol() && this.getTemplateParameters().isEmpty();
    }

    public static boolean isVariadicTemplate(@NotNull OCTemplateSymbol symbol) {
        List<OCTypeParameterSymbol> templateParameters = symbol.getTemplateParameters();
        for (int i = templateParameters.size() - 1; i >= 0; --i) {
            if (!templateParameters.get(i).isVariadic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isVariadicTemplate() {
        return OCTemplateSymbolImpl.isVariadicTemplate(this);
    }
}

