/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.cpp;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTypeParameterTypeSymbol
extends OCSymbolImpl
implements OCTypeParameterSymbol<OCType> {
    @Nullable
    private OCType myDefaultValue;
    private OCTypeParameterTypeSymbol myQualifierTypeParameter;
    private ComplexTextRange myScope;
    private int myProperties;
    private static final int PROP_VARIADIC = 1;
    private static final int PROP_SPELLED_WITH_TYPENAME_KEYWORD = 2;
    private static final int PROP_SYNTHETIC = 4;

    public OCTypeParameterTypeSymbol() {
    }

    public OCTypeParameterTypeSymbol(@Nullable VirtualFile file, long offset, @Nullable String name2, @Nullable OCTypeParameterTypeSymbol qualifierTypeParameter, @Nullable OCType defaultValue, @NotNull List<String> attributes, ComplexTextRange scope, boolean variadic, boolean isSpelledWithTypenameKeyword, boolean isSynthetic) {
        super(file, offset, name2, attributes);
        this.myQualifierTypeParameter = qualifierTypeParameter;
        this.myScope = scope;
        this.myDefaultValue = defaultValue;
        this.myProperties = (variadic ? 1 : 0) | (isSpelledWithTypenameKeyword ? 2 : 0) | (isSynthetic ? 4 : 0);
    }

    public OCTypeParameterTypeSymbol(@Nullable VirtualFile file, long offset, @Nullable String name2, @Nullable OCType defaultValue, @NotNull List<String> attributes, ComplexTextRange scope, boolean variadic, boolean isSpelledWithTypenameKeyword, boolean isSynthetic) {
        this(file, offset, name2, null, defaultValue, attributes, scope, variadic, isSpelledWithTypenameKeyword, isSynthetic);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCTypeParameterTypeSymbol f = (OCTypeParameterTypeSymbol)first;
        OCTypeParameterTypeSymbol s = (OCTypeParameterTypeSymbol)second;
        if (!c.equalObjects(f.myQualifierTypeParameter, s.myQualifierTypeParameter)) {
            return false;
        }
        if (!Comparing.equal((Object)f.myScope, (Object)s.myScope)) {
            return false;
        }
        if (!c.equalObjects(f.myDefaultValue, s.myDefaultValue)) {
            return false;
        }
        return this.myProperties == f.myProperties;
    }

    @Override
    @NotNull
    public OCType getType() {
        return new OCTypeParameterType(this);
    }

    @Override
    public boolean isSynthetic() {
        return (this.myProperties & 4) != 0;
    }

    public OCTypeParameterTypeSymbol getQualifierTypeParameter() {
        return this.myQualifierTypeParameter;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.TEMPLATE_TYPE_PARAMETER;
    }

    @Override
    @Nullable
    public OCType getDefaultValue() {
        return this.myDefaultValue;
    }

    @Override
    public boolean isVariadic() {
        return (this.myProperties & 1) != 0;
    }

    public boolean isSpelledWithTypenameKeyword() {
        return (this.myProperties & 2) != 0;
    }

    @Override
    @Nullable
    public ComplexTextRange getScope() {
        return this.myScope;
    }

    @Override
    public void setScope(@NotNull ComplexTextRange scope) {
        this.myScope = scope;
    }
}

