/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCInitializerList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInitializerListExpressionSymbol
extends OCExpressionSymbol
implements OCInitializerList {
    public static final int ITEMS_IN_PRESENTATION = 3;
    private List<OCExpressionSymbol> myInitializers;

    public OCInitializerListExpressionSymbol() {
    }

    public OCInitializerListExpressionSymbol(@Nullable VirtualFile file, long offset, List<OCExpressionSymbol> initializers) {
        super(file, offset);
        this.myInitializers = initializers;
    }

    @Override
    public void compact() {
        super.compact();
        this.myInitializers = ContainerUtil.trimToSize(this.myInitializers);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCInitializerListExpressionSymbol firstSymbol = (OCInitializerListExpressionSymbol)first;
        OCInitializerListExpressionSymbol secondSymbol = (OCInitializerListExpressionSymbol)second;
        return c.equalObjects(firstSymbol.myInitializers, secondSymbol.myInitializers);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return this.myInitializers.size() == 1 ? (T)this.myInitializers.get(0).evaluate(evaluator) : null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (!OCCompilerFeatures.supportsInitializerLists(context.getFile())) {
            return OCUnknownType.INSTANCE;
        }
        return OCInitializerListExpressionSymbol.getCompoundInitializerType(OCArgumentsList.expandVariadicExpressions(this.myInitializers, context), context).resolve(context);
    }

    @NotNull
    public List<OCExpressionSymbol> getInitializerExpressions() {
        return this.myInitializers != null ? this.myInitializers : Collections.emptyList();
    }

    @NotNull
    public OCArgumentsList<OCExpressionSymbol> getArgumentList(@Nullable OCResolveContext context) {
        return OCArgumentsList.expandVariadicExpressions(this.myInitializers, context);
    }

    @NotNull
    private static OCType getCompoundInitializerType(@NotNull OCArgumentsList<? extends OCTypeOwner> arguments, @NotNull OCResolveContext context) {
        OCType type = null;
        for (OCType exprType : arguments.getTypes()) {
            type = type == null ? exprType : type.getLeastCommonType(exprType, context);
        }
        List<OCTypeArgument> typeArguments = type != null ? Collections.singletonList(type) : Collections.emptyList();
        return OCReferenceType.fromQualifiedName(new OCQualifiedNameWithArguments(OCQualifiedName.parse("std::initializer_list"), typeArguments));
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return "{" + this.myInitializers.stream().limit(3L).map(OCSymbol::getPresentableName).collect(Collectors.joining(", ")) + (this.myInitializers.size() > 3 ? ", ..." : "") + "}";
    }

    @Override
    public boolean isListInitializer() {
        return true;
    }
}

