/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLiteralExpressionSymbol
extends OCExpressionSymbol {
    @NotNull
    private Object myValue;
    private IElementType myTokenType;
    private Object myChildTextElements;

    public OCLiteralExpressionSymbol() {
    }

    public OCLiteralExpressionSymbol(@NotNull Object value, IElementType tokenType, @Nullable List<String> textElements) {
        super(null, 0L);
        this.myValue = value;
        this.myTokenType = tokenType;
        this.myChildTextElements = textElements != null && textElements.size() == 1 ? OCNamesInternary.intern(textElements.get(0)) : textElements;
    }

    @NotNull
    public Object getValue() {
        return this.myValue;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCLiteralExpressionSymbol firstSymbol = (OCLiteralExpressionSymbol)first;
        OCLiteralExpressionSymbol secondSymbol = (OCLiteralExpressionSymbol)second;
        return c.equalObjects(firstSymbol.myValue, secondSymbol.myValue);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (this.myValue instanceof Boolean) {
            return evaluator.evalBool((Boolean)this.myValue);
        }
        if (this.myValue instanceof Number) {
            return evaluator.evalInteger((Number)this.myValue);
        }
        return null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        PsiFile file = context.getFile();
        List<String> childTextElements = this.myChildTextElements instanceof String ? Collections.singletonList((String)this.myChildTextElements) : (List<String>)this.myChildTextElements;
        return file != null ? OCLiteralExpressionImpl.getLiteralType(this.myTokenType, childTextElements, file) : OCUnknownType.INSTANCE;
    }

    @Override
    @Nullable
    public OCTypeArgument evaluateToTypeArgument(@NotNull OCResolveContext resolver) {
        return new OCExpressionTypeArgument(this);
    }

    @NotNull
    public IElementType getTokenType() {
        return this.myTokenType;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if (this.myChildTextElements instanceof List) {
            return StringUtil.join((Collection)((List)this.myChildTextElements), (String)" ");
        }
        if (this.myChildTextElements instanceof String) {
            return (String)this.myChildTextElements;
        }
        return this.myValue.toString();
    }
}

