/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCQualifiedExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCQualifiedExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myQualifier;
    private String myMemberName;
    private boolean isDeref;
    private List<OCTypeArgument> myTypeArguments;
    private OCExpressionSymbol myParent;

    public OCQualifiedExpressionSymbol() {
    }

    public OCQualifiedExpressionSymbol(@Nullable VirtualFile file, long offset, @NotNull OCExpressionSymbol qualifier, @NotNull String memberName, boolean deref, @NotNull List<OCTypeArgument> typeArguments) {
        super(file, offset);
        this.myQualifier = qualifier;
        this.myMemberName = memberName;
        this.isDeref = deref;
        this.myTypeArguments = typeArguments;
    }

    public void setParent(OCExpressionSymbol parent) {
        this.myParent = parent;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCQualifiedExpressionSymbol firstSymbol = (OCQualifiedExpressionSymbol)first;
        OCQualifiedExpressionSymbol secondSymbol = (OCQualifiedExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myQualifier, secondSymbol.myQualifier)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myMemberName, secondSymbol.myMemberName)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.myTypeArguments, secondSymbol.myTypeArguments)) {
            return false;
        }
        if (!c.equalObjects(firstSymbol.isDeref, secondSymbol.isDeref)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myParent, secondSymbol.myParent);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        return (OCType)this.getResolvedSymbolAndType((OCResolveContext)context).second;
    }

    @Nullable
    public OCSymbol getResolvedMember(@NotNull OCResolveContext context) {
        return (OCSymbol)this.getResolvedSymbolAndType((OCResolveContext)context).first;
    }

    @NotNull
    public Pair<OCSymbol, OCType> getResolvedSymbolAndType(@NotNull OCResolveContext context) {
        OCType qualifierType = this.myQualifier.getResolvedType(context);
        PsiFile file = context.getFile();
        if (qualifierType instanceof OCCppReferenceType) {
            qualifierType = ((OCCppReferenceType)qualifierType).getRefType();
        }
        if (this.isDeref != qualifierType instanceof OCPointerType) {
            return Pair.create(null, (Object)OCUnknownType.INSTANCE);
        }
        if (qualifierType instanceof OCPointerType) {
            qualifierType = ((OCPointerType)qualifierType).getRefType();
        }
        if (qualifierType instanceof OCStructType && ((OCStructType)qualifierType).getKind() != OCSymbolKind.ENUM) {
            if (this.myMemberName.startsWith("~")) {
                CommonProcessors.FindFirstProcessor dtorFinder = new CommonProcessors.FindFirstProcessor();
                ((OCStructType)qualifierType).getSymbol().processDestructors((Processor<? super OCFunctionSymbol>)dtorFinder, false, context);
                if (dtorFinder.getFoundValue() == null || !((OCFunctionSymbol)dtorFinder.getFoundValue()).isDelete()) {
                    return Pair.create((Object)dtorFinder.getFoundValue(), (Object)new OCFunctionType(OCVoidType.instance(), Collections.emptyList()));
                }
            }
            List<OCSymbol> members = OCQualifiedExpressionImpl.getResolvedMembers((OCStructType)qualifierType, this.myMemberName, this.myTypeArguments, context, true);
            if (this.myParent instanceof OCCallExpressionSymbol && file != null && ((OCFile)file).isCpp()) {
                OCSymbol symbol;
                return Pair.create((Object)symbol, (Object)((symbol = ((OCCallExpressionSymbol)this.myParent).resolveOverloads(members, context)) != null ? symbol.getType().resolve(context) : OCUnknownType.INSTANCE));
            }
            if (!members.isEmpty()) {
                OCSymbol firstSymbol = (OCSymbol)ContainerUtil.getFirstItem(members);
                return Pair.create((Object)firstSymbol, (Object)firstSymbol.getType().resolve(context));
            }
        }
        if (qualifierType instanceof OCMagicType || qualifierType instanceof OCAutoType) {
            return Pair.create(null, (Object)new OCMagicType());
        }
        return Pair.create(null, (Object)OCUnknownType.INSTANCE);
    }

    @NotNull
    public OCExpressionSymbol getQualifier() {
        return this.myQualifier;
    }

    public boolean isDeref() {
        return this.isDeref;
    }

    @NotNull
    public OCExpressionSymbol getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myQualifier.getPresentableName() + (this.isDeref ? "->" : ".") + this.myMemberName;
    }
}

