/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCReferenceExpressionSymbol
extends OCExpressionSymbol {
    @NotNull
    private OCSymbolReference myReference;
    private OCExpressionSymbol myParent;

    public OCReferenceExpressionSymbol() {
    }

    @Override
    @NotNull
    public String getName() {
        String name2 = this.myReference.getQualifiedName().getName();
        return name2 == null || name2.isEmpty() ? "<unnamed>" : name2;
    }

    public OCReferenceExpressionSymbol(@Nullable VirtualFile file, long offset, @NotNull OCSymbolReference reference) {
        super(file, offset);
        this.myReference = reference;
    }

    public void setParent(OCExpressionSymbol parent) {
        this.myParent = parent;
    }

    @NotNull
    public OCSymbolReference getReference() {
        return this.myReference;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCReferenceExpressionSymbol firstSymbol = (OCReferenceExpressionSymbol)first;
        OCReferenceExpressionSymbol secondSymbol = (OCReferenceExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myReference, secondSymbol.myReference)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myParent, secondSymbol.myParent);
    }

    @Nullable
    public OCSymbol resolveToSymbol(@NotNull OCResolveContext context) {
        List<OCSymbol> symbols = context.resolveToSymbols(this.myReference);
        PsiFile file = context.getFile();
        if (this.myParent instanceof OCCallExpressionSymbol && file != null && ((OCFile)file).isCpp()) {
            if (symbols.size() == 1 && symbols.get(0) instanceof OCStructSymbol) {
                OCArgumentsList<OCExpressionSymbol> arguments = ((OCCallExpressionSymbol)this.myParent).getArgumentList(context);
                OCStructSymbol symbol = (OCStructSymbol)symbols.get(0);
                if (arguments != null) {
                    return symbol.findConstructor(arguments, context, null, true, null, false, symbol.getType()).getSymbol();
                }
                return null;
            }
            return ((OCCallExpressionSymbol)this.myParent).resolveOverloads(symbols, context);
        }
        return OCReferenceElementImpl.findPredeclaration(symbols);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        return evaluator.evalReference(this);
    }

    @Override
    @Nullable
    public OCTypeArgument evaluateToTypeArgument(@NotNull OCResolveContext resolver) {
        OCSymbol symbol;
        OCTypeArgument result = super.evaluateToTypeArgument(resolver);
        if (result == null && (symbol = this.resolveToSymbol(resolver)) instanceof OCTypeParameterValueSymbol) {
            return new OCTypeParameterType((OCTypeParameterSymbol)((Object)symbol));
        }
        return result;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCSymbol symbol = this.resolveToSymbol(context);
        if (symbol instanceof OCTypeParameterSymbol) {
            context.addTypeDependency((OCTypeParameterSymbol)((Object)symbol));
        }
        OCUnknownType unresolvedType = symbol != null ? OCTypeUtils.getSymbolType(symbol, this.myReference, context) : OCUnknownType.INSTANCE;
        OCType type = unresolvedType.resolve(context);
        if (symbol instanceof OCDeclaratorSymbol && type instanceof OCStructType) {
            type = OCTypeUtils.deduceDeclaratorTemplateArguments((OCStructType)type, unresolvedType, (OCDeclaratorSymbol)symbol, context);
        }
        return type;
    }

    @NotNull
    public OCReferenceType asTypeReference() {
        return new OCReferenceTypeBuilder(this.getReference()).build();
    }

    @Override
    @NotNull
    public String getPresentableName() {
        return this.myReference.getQualifiedName().toString();
    }
}

