/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCClassSymbol
extends OCSymbolWithQualifiedName,
OCMembersContainer<OCMemberSymbol> {
    @Nullable
    public String getCategoryName();

    @NotNull
    public OCReferenceType getSuperType();

    @NotNull
    default public String getSuperClassName() {
        return StringUtil.notNullize((String)this.getSuperType().getReference().getQualifiedName().getName());
    }

    @NotNull
    public List<String> getProtocolNames();

    @Override
    default public boolean processMembers(@Nullable String memberName, @NotNull Processor<? super OCMemberSymbol> processor2) {
        return this.processMembers(memberName, null, processor2);
    }

    default public <T extends OCMemberSymbol> boolean processMembers(@NotNull Class<T> memberClass, @NotNull Processor<? super T> processor2) {
        return this.processMembers(null, memberClass, processor2);
    }

    public int getMembersCount();

    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String var1, @Nullable Class<? extends T> var2, @NotNull Processor<? super T> var3);

    default public <T extends OCMemberSymbol> boolean processMembersInAllCategories(@Nullable String memberName, @NotNull Class<? extends T> memberClass, @NotNull Processor<? super T> processor2, @NotNull Project project2) {
        return this.processMembersInAllCategories(memberName, memberClass, processor2, true, project2);
    }

    default public <T extends OCMemberSymbol> boolean processMembersInAllCategories(@Nullable String memberName, @NotNull Class<? extends T> memberClass, @NotNull Processor<? super T> processor2, boolean fromSameParentClass, @NotNull Project project2) {
        return this.processCategories((Processor<? super OCClassSymbol>)((Processor)clazz -> clazz.processMembers(memberName, memberClass, processor2)), fromSameParentClass, null, project2);
    }

    default public <T extends OCMemberSymbol> boolean processMembers(@Nullable String categoryName, @Nullable String memberName, @NotNull Class<? extends T> memberClass, @NotNull Processor<? super T> processor2, boolean fromSameParentClass, @NotNull Project project2) {
        return this.processCategories((Processor<? super OCClassSymbol>)((Processor)clazz -> !Comparing.equal((String)categoryName, (String)clazz.getCategoryName()) || clazz.processMembers(memberName, memberClass, processor2)), fromSameParentClass, null, project2);
    }

    default public boolean processAllMethods(@Nullable String methodName, @NotNull Processor<OCMethodSymbol> processor2, @Nullable Set<String> baseProtocols, @Nullable PsiElement context) {
        return OCClassSymbolImpl.processAllMethods(this, methodName, processor2, baseProtocols, context);
    }

    default public boolean processCategories(@NotNull Processor<? super OCClassSymbol> processor2, boolean fromSameParentClass, @Nullable PsiElement context, @NotNull Project project2) {
        return OCClassSymbolImpl.processCategories(this, processor2, fromSameParentClass, context, project2);
    }

    @Override
    @Nullable
    public OCClassSymbol getDefinitionSymbol(@NotNull Project var1);

    @Nullable
    public OCInterfaceSymbol getInterface(@NotNull Project var1);

    @Nullable
    public OCClassSymbol getInterfaceOrProtocol(@NotNull Project var1);

    @Nullable
    public OCImplementationSymbol getImplementation(@NotNull Project var1);

    @Nullable
    default public OCInterfaceSymbol getMainInterface(@NotNull Project project2) {
        return OCClassSymbolImpl.getMainSymbol(this, this.getInterface(project2), project2);
    }

    @Nullable
    default public OCImplementationSymbol getMainImplementation(@NotNull Project project2) {
        return OCClassSymbolImpl.getMainSymbol(this, this.getImplementation(project2), project2);
    }

    @Override
    @Nullable
    public OCObjectType getResolvedType(@NotNull OCResolveContext var1, boolean var2);

    default public boolean isSameClass(@NotNull OCClassSymbol symbol) {
        return Comparing.equal((String)this.getName(), (String)symbol.getName()) && this instanceof OCProtocolSymbol == symbol instanceof OCProtocolSymbol;
    }

    default public boolean isSameCategory(@Nullable OCSymbol symbol) {
        return OCClassSymbolImpl.isSameCategory(this, symbol);
    }

    default public boolean isSubclass(@NotNull OCClassSymbol ancestor, @NotNull Project project2) {
        return OCClassSymbolImpl.isSubclass(this, ancestor, project2);
    }

    @Override
    @Nullable
    default public OCFile getContainingOCFile(@NotNull Project project2) {
        return OCSymbolWithQualifiedName.super.getContainingOCFile(project2);
    }

    @Override
    @NotNull
    default public String getPresentableName() {
        return OCCodeInsightUtil.getClassNameWithCategory(this.getName(), this.getCategoryName());
    }
}

