/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInstanceVariableSymbolImpl
extends OCMemberSymbolImpl
implements OCInstanceVariableSymbol {
    private OCType myType;
    private String myGeneratedFromProperty;
    private OCVisibility myVisibility;

    public OCInstanceVariableSymbolImpl() {
    }

    public OCInstanceVariableSymbolImpl(VirtualFile file, long offset, String name2, @NotNull List<String> attributes, OCClassSymbol parent, @NotNull OCType type, @NotNull OCVisibility visibility, @Nullable String generatedFromProperty) {
        super(file, offset, name2, attributes, parent);
        this.myType = type;
        this.myVisibility = visibility;
        this.myGeneratedFromProperty = generatedFromProperty;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCInstanceVariableSymbolImpl f = (OCInstanceVariableSymbolImpl)first;
        OCInstanceVariableSymbolImpl s = (OCInstanceVariableSymbolImpl)second;
        if (f.myVisibility != s.myVisibility) {
            return false;
        }
        if (!Comparing.equal((String)f.myGeneratedFromProperty, (String)f.myGeneratedFromProperty)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Override
    public void compact() {
        super.compact();
        this.myType.compact();
    }

    @Override
    @NotNull
    public OCType getType() {
        return this.myGeneratedFromProperty == null ? this.myType : new OCInstanceVariableFromPropertyDeferredType(this);
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.INSTANCE_VARIABLE;
    }

    @Override
    @NotNull
    public OCVisibility getVisibility() {
        return this.myVisibility;
    }

    @Override
    public void updateVisibility(@NotNull OCVisibility visibility) {
        this.myVisibility = visibility;
    }

    @Override
    public Icon getBaseIcon() {
        return OCIcons.getVisibilityIcon(this.getVisibility(), super.getBaseIcon());
    }

    @Override
    @NotNull
    public ARCAttribute getARCAttribute(PsiElement context, @NotNull Project project2) {
        OCType type = this.getResolvedType(OCResolveContext.forNullablePsi(context, project2));
        if (this.myGeneratedFromProperty != null) {
            OCPropertySymbol property = this.getAssociatedProperty(project2);
            if (property != null) {
                return property.getAttributeOfGroup(OCPropertySymbol.PropertyAttribute.ASSIGN, type, context).getIvarCompatibleARCAttribute();
            }
            return ARCAttribute.DEFAULT;
        }
        ARCAttribute arcAttribute = type instanceof OCPointerType ? ((OCPointerType)type).getARCAttribute() : null;
        return arcAttribute != null ? arcAttribute : ARCAttribute.DEFAULT;
    }

    @Override
    public Class<? extends PsiElement> getPsiElementClass() {
        return this.myGeneratedFromProperty != null ? OCReferenceElement.class : super.getPsiElementClass();
    }

    @Override
    public String getGeneratedFromProperty() {
        return this.myGeneratedFromProperty;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean processSynthesizes(Processor<OCSynthesizeSymbol> processor2, @NotNull Project project2) {
        OCImplementationSymbol implementation = this.getParent().getMainImplementation(project2);
        if (implementation == null) {
            return false;
        }
        return implementation.processMembers(OCSynthesizeSymbol.class, symbol -> !this.getName().equals(symbol.getIvarName()) || processor2.process(symbol));
    }

    @Override
    @Nullable
    public OCPropertySymbol getAssociatedProperty(@NotNull Project project2) {
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        this.processSynthesizes((Processor<OCSynthesizeSymbol>)finder, project2);
        if (!finder.isFound()) {
            if (OCCompilerFeatures.supportsAutosynthesis(this.getContainingOCFile(project2))) {
                OCInterfaceSymbol anInterface = this.myParent.getInterface(project2);
                String propertyName = OCNameSuggester.getClang4PropertyName(this.myName);
                CommonProcessors.FindFirstProcessor propFinder = new CommonProcessors.FindFirstProcessor();
                if (propertyName != null && anInterface != null) {
                    anInterface.processMembers(propertyName, OCPropertySymbol.class, propFinder);
                }
                return (OCPropertySymbol)propFinder.getFoundValue();
            }
            return null;
        }
        return ((OCSynthesizeSymbol)finder.getFoundValue()).getAssociatedProperty(project2);
    }

    @Override
    public boolean isSynthetic() {
        return this.myGeneratedFromProperty != null && this.myComplexOffset == Long.MAX_VALUE;
    }

    @Override
    public boolean isClang4ImplicitIvar(@Nullable PsiFile context) {
        return this.myGeneratedFromProperty != null && this.myComplexOffset == Long.MAX_VALUE && OCCompilerFeatures.supportsAutosynthesis(context);
    }

    @Override
    public boolean isClang4ImplicitIvar(@NotNull Project project2) {
        return this.isClang4ImplicitIvar(this.getContainingOCFile(project2));
    }

    @Override
    public boolean isForbiddenClang4ImplicitIvar(@Nullable PsiFile context, @NotNull Project project2) {
        if (this.myGeneratedFromProperty == null || this.myComplexOffset != Long.MAX_VALUE) {
            return false;
        }
        if (context != null && !OCCompilerFeatures.supportsAutosynthesis(context)) {
            return true;
        }
        if (OCNameSuggester.getClang4PropertyName(this.myName) == null) {
            return false;
        }
        OCPropertySymbol property = this.getAssociatedProperty(project2);
        return property != null && property.hasAllAccessorsImplemented(true, project2);
    }

    private static final class OCInstanceVariableFromPropertyDeferredType
    extends OCDeferredType {
        @NotNull
        private final OCInstanceVariableSymbolImpl myInstanceVariableSymbol;

        private OCInstanceVariableFromPropertyDeferredType(@NotNull OCInstanceVariableSymbolImpl instanceVariableSymbol) {
            super(instanceVariableSymbol.myType.isConst(), instanceVariableSymbol.myType.isVolatile());
            assert (instanceVariableSymbol.myGeneratedFromProperty != null);
            this.myInstanceVariableSymbol = instanceVariableSymbol;
        }

        @Override
        @NotNull
        public OCDeferredType clone(@NotNull OCTypeCloneVisitor visitor) {
            return new OCInstanceVariableFromPropertyDeferredType(this.myInstanceVariableSymbol);
        }

        @Override
        @NotNull
        public OCType getActualType(@NotNull OCResolveContext context) {
            OCClassSymbol parent = this.myInstanceVariableSymbol.getParent();
            OCInterfaceSymbol intfSymbol = parent.getInterface(context.getProject());
            if (intfSymbol == null) {
                return this.myInstanceVariableSymbol.myType;
            }
            OCType parentType = parent.getResolvedType(OCResolveContext.forSymbol(this.myInstanceVariableSymbol, context.getProject()));
            if (!(parentType instanceof OCObjectType)) {
                return this.myInstanceVariableSymbol.myType;
            }
            CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
            ((OCObjectType)parentType).processMembers(this.myInstanceVariableSymbol.myGeneratedFromProperty, OCPropertySymbol.class, finder, true, false);
            return finder.getFoundValue() != null ? ((OCPropertySymbol)finder.getFoundValue()).getType() : this.myInstanceVariableSymbol.myType;
        }

        @Override
        public boolean equalsDeferredType(@NotNull OCDeferredType type) {
            return type instanceof OCInstanceVariableFromPropertyDeferredType && this.myInstanceVariableSymbol.equals(((OCInstanceVariableFromPropertyDeferredType)type).myInstanceVariableSymbol);
        }

        @Override
        public int hashCode() {
            return 31 * this.baseHashCode() + this.myInstanceVariableSymbol.hashCode();
        }
    }
}

