/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCReferenceTypeBuilder;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCInterfaceSymbolImpl
extends OCClassSymbolImpl
implements OCInterfaceSymbol {
    private List<OCGenericParameterSymbol> myGenericParameters;
    @NotNull
    private OCTypeSubstitution mySubstitution = OCTypeSubstitution.ID;

    public OCInterfaceSymbolImpl() {
    }

    public OCInterfaceSymbolImpl(@Nullable VirtualFile file, long offset, @NotNull String name2, @NotNull List<String> attributes, @Nullable String category, @Nullable MostlySingularMultiMap<String, OCMemberSymbol> members, @NotNull List<String> protocolNames, @Nullable OCReferenceType superType, @NotNull List<OCGenericParameterSymbol> genericParameters) {
        super(file, offset, name2, attributes, category, members, protocolNames, superType);
        this.myGenericParameters = genericParameters;
    }

    public OCInterfaceSymbolImpl(@NotNull OCInterfaceSymbolImpl origin, @NotNull OCTypeSubstitution substitution) {
        this(origin.getContainingFile(), origin.getComplexOffset(), origin.getName(), origin.getAttributes(), origin.getCategoryName(), origin.getMembers(), origin.getProtocolNames(), origin.getSuperType(), origin.getGenericParameters());
        this.mySubstitution = substitution;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.INTERFACE;
    }

    @Override
    public boolean isDefinition() {
        return false;
    }

    @Override
    @Nullable
    public OCClassSymbol getInterfaceOrProtocol(@NotNull Project project2) {
        return this.getInterface(project2);
    }

    @Override
    @NotNull
    public OCType getType() {
        return OCInterfaceSymbolImpl.getInterfaceTypeImpl(this);
    }

    @NotNull
    public static OCType getInterfaceTypeImpl(@NotNull OCInterfaceSymbol self) {
        List<OCTypeArgument> genericArguments = OCInterfaceSymbolImpl.getGenericArguments(self);
        OCQualifiedName qualifiedName = genericArguments.isEmpty() ? self.getQualifiedName() : new OCQualifiedNameWithArguments(null, self.getName(), genericArguments);
        OCSymbolReference.GlobalReference ref = OCSymbolReference.getDummyGlobalReference(qualifiedName);
        return new OCReferenceTypeBuilder(ref).setSubstitution(self.getSubstitution()).build();
    }

    @NotNull
    public static List<OCTypeArgument> getGenericArguments(@NotNull OCInterfaceSymbol self) {
        List<OCGenericParameterSymbol> genericParameters = self.getGenericParameters();
        OCTypeSubstitution substitution = self.getSubstitution();
        if (genericParameters.isEmpty() || substitution == OCTypeSubstitution.ID) {
            return Collections.emptyList();
        }
        ArrayList arguments = ContainerUtil.newArrayList();
        for (OCGenericParameterSymbol parameter : genericParameters) {
            OCTypeArgument argument = substitution.getSubstitutionFor(parameter);
            arguments.add(argument != null ? argument : parameter.getDefaultValue());
        }
        return Collections.unmodifiableList(arguments);
    }

    @Override
    @NotNull
    public OCReferenceType getSuperType() {
        return (OCReferenceType)this.mySubstitution.substitute(super.getSuperType());
    }

    @Override
    public OCInterfaceSymbol getInterface(@NotNull Project project2) {
        return this;
    }

    @Override
    public OCSymbol getAssociatedSymbol(@NotNull Project project2) {
        return this.getImplementation(project2);
    }

    @Override
    @Nullable
    public OCImplementationSymbol getImplementation(@NotNull Project project2) {
        OCImplementationSymbol symbol = this.getImplementation(this.getCategoryName(), project2);
        if (symbol == null && this.getCategoryName() != null) {
            symbol = this.getImplementation(null, project2);
        }
        return symbol;
    }

    @Nullable
    public static OCImplementationSymbol getImplementation(@NotNull OCInterfaceSymbol self, @Nullable String category, @NotNull Project project2) {
        boolean isInProject = OCSearchScope.isInProjectSources(self, project2);
        final Condition condition = symbol -> symbol instanceof OCImplementationSymbol && isInProject == OCSearchScope.isInProjectSources(symbol, project2) && !symbol.isPredeclaration() && Comparing.equal((String)category, (String)((OCImplementationSymbol)symbol).getCategoryName());
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return condition.value((Object)symbol);
            }
        };
        OCFile containingFile = self.getContainingOCFile(project2);
        if (containingFile != null) {
            OCResolveUtil.processGlobalSymbols(self.getName(), containingFile, (Processor<OCSymbol>)processor2);
        }
        if (!processor2.isFound()) {
            return (OCImplementationSymbol)OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(project2, self.getName(), (Condition<? super OCSymbol>)condition, self.getContainingFile());
        }
        return (OCImplementationSymbol)processor2.getFoundValue();
    }

    @Override
    @NotNull
    public List<OCGenericParameterSymbol> getGenericParameters() {
        return ContainerUtil.newUnmodifiableList(this.myGenericParameters);
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.mySubstitution;
    }

    @Override
    public <T extends OCMemberSymbol> boolean processMembers(@Nullable String memberName, @Nullable Class<? extends T> memberClass, @NotNull Processor<? super T> processor2) {
        return super.processMembers(memberName, memberClass, this.getSubstitutingProcessor(processor2));
    }

    @NotNull
    protected <T extends OCMemberSymbol> Processor<T> getSubstitutingProcessor(@NotNull Processor<? super T> processor2) {
        if (this.mySubstitution != OCTypeSubstitution.ID) {
            return member -> processor2.process((Object)this.mySubstitution.substitute(member));
        }
        return processor2;
    }

    @Override
    @NotNull
    public List<OCTypeParameterSymbol> getTemplateParameters() {
        return this.getGenericParameters();
    }

    @Override
    @Nullable
    public List<OCTypeArgument> getTemplateSpecialization() {
        return null;
    }

    @Override
    public int getRequiredTemplateArgumentsCnt() {
        return this.getTemplateParameters().size();
    }

    @Override
    public boolean isTemplateSymbol() {
        return this.myGenericParameters.size() != 0;
    }

    @Override
    public boolean isVariadicTemplate() {
        return false;
    }

    @Override
    public boolean isSpecialization() {
        return false;
    }

    @Override
    public boolean isExplicitInstantiation() {
        return false;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCInterfaceSymbolImpl f = (OCInterfaceSymbolImpl)first;
        OCInterfaceSymbolImpl s = (OCInterfaceSymbolImpl)second;
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalLists(f.myGenericParameters, s.myGenericParameters);
    }
}

