/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMemberSymbolImpl
extends OCSymbolImpl
implements OCMemberSymbol {
    @NotNull
    protected OCClassSymbol myParent;

    public OCMemberSymbolImpl() {
    }

    public OCMemberSymbolImpl(VirtualFile file, long offset, @Nullable String name2, @NotNull List<String> attributes, @NotNull OCClassSymbol parent) {
        super(file, offset, name2, attributes);
        this.myParent = parent;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCMemberSymbolImpl f = (OCMemberSymbolImpl)first;
        OCMemberSymbolImpl s = (OCMemberSymbolImpl)second;
        return c.equalObjects(f.myParent, s.myParent);
    }

    @Override
    @NotNull
    public OCClassSymbol getParent() {
        return this.myParent;
    }

    @Override
    @NotNull
    public String getNameWithParent(@NotNull OCResolveContext context) {
        return this.myParent.getName() + "." + this.myName;
    }

    @Override
    @Nullable
    public OCMemberSymbol getAssociatedSymbol(@NotNull Project project2) {
        OCClassSymbol parentAssociate = (OCClassSymbol)this.getParent().getAssociatedSymbol(project2);
        if (parentAssociate == null) {
            return null;
        }
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        parentAssociate.processMembers(this.getName(), this.getClass(), processor2);
        return (OCMemberSymbol)processor2.getFoundValue();
    }

    @Override
    public boolean processSameSymbols(@NotNull Processor<OCSymbol> processor2, @NotNull Project project2) {
        return this.myParent.processMembersInAllCategories(this.myName, this.getClass(), processor2, false, project2);
    }

    @Override
    public boolean isSameSymbol(OCSymbol symbol, @NotNull Project project2) {
        return symbol instanceof OCMemberSymbol && this.myName.equals(symbol.getName()) && this.myParent.isSameSymbol((OCSymbol)((OCMemberSymbol)symbol).getParent(), project2);
    }
}

