/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CommonProcessors;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSynthesizeSymbol
extends OCMemberSymbolImpl {
    private boolean mySynthesize;
    private boolean myStatic;
    private String myIvarName;

    public OCSynthesizeSymbol() {
    }

    public OCSynthesizeSymbol(VirtualFile file, long offset, String name2, @NotNull List<String> attributes, OCClassSymbol parent, boolean isSynthesize, boolean isStatic, String ivarName) {
        super(file, offset, name2, attributes, parent);
        this.mySynthesize = isSynthesize;
        this.myStatic = isStatic;
        this.myIvarName = ivarName;
    }

    public boolean isSynthesize() {
        return this.mySynthesize;
    }

    @Override
    public boolean isStatic() {
        return this.myStatic;
    }

    public String getIvarName() {
        return this.myIvarName != null ? this.myIvarName : this.myName;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        return OCSymbolKind.SYNTHESIZE;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCSynthesizeSymbol f = (OCSynthesizeSymbol)first;
        OCSynthesizeSymbol s = (OCSynthesizeSymbol)second;
        if (f.mySynthesize != s.mySynthesize) {
            return false;
        }
        if (f.myStatic != s.myStatic) {
            return false;
        }
        return Comparing.equal((String)f.myIvarName, (String)s.myIvarName);
    }

    @Nullable
    public OCPropertySymbol getAssociatedProperty(@NotNull Project project2) {
        OCInterfaceSymbol interf = this.getParent().getInterface(project2);
        if (interf == null) {
            return null;
        }
        final String propertyName = this.getName();
        CommonProcessors.FindFirstProcessor<OCPropertySymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCPropertySymbol>(){

            protected boolean accept(OCPropertySymbol symbol) {
                return Comparing.equal((String)propertyName, (String)symbol.getName());
            }
        };
        interf.processMembers(propertyName, OCPropertySymbol.class, processor2);
        if (!processor2.isFound()) {
            interf.processMembers("", propertyName, OCPropertySymbol.class, processor2, true, project2);
        }
        return (OCPropertySymbol)processor2.getFoundValue();
    }

    @Nullable
    public OCInstanceVariableSymbol getIvarSymbol(final @NotNull Project project2) {
        OCClassSymbol impl = this.getParent();
        CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol> finder = new CommonProcessors.FindFirstProcessor<OCInstanceVariableSymbol>(){

            protected boolean accept(OCInstanceVariableSymbol symbol) {
                return Comparing.equal((String)OCSynthesizeSymbol.this.getIvarName(), (String)symbol.getName()) && !symbol.isClang4ImplicitIvar(project2);
            }
        };
        OCCommonProcessors.OrderedProcessor processor2 = new OCCommonProcessors.OrderedProcessor(finder, true, (Condition<T>[])new Condition[]{ivar -> ivar.getGeneratedFromProperty() == null, Conditions.alwaysTrue()});
        OCInterfaceSymbol intf = impl.getInterface(project2);
        if (intf != null) {
            intf.processMembersInAllCategories(this.getIvarName(), OCInstanceVariableSymbol.class, processor2, project2);
        }
        impl.processMembers(this.getIvarName(), OCInstanceVariableSymbol.class, processor2);
        processor2.finish();
        return (OCInstanceVariableSymbol)finder.getFoundValue();
    }
}

