/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.util.Comparing;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectorPartSymbolImpl
implements OCMethodSymbol.SelectorPartSymbol {
    @Nullable
    private String selectorName;
    @Nullable
    private OCDeclaratorSymbol parameter;
    @NotNull
    private OCTypeSubstitution substitution = OCTypeSubstitution.ID;

    public SelectorPartSymbolImpl() {
    }

    public SelectorPartSymbolImpl(@Nullable OCDeclaratorSymbol parameter, @Nullable String selectorName) {
        this.parameter = parameter;
        this.selectorName = selectorName;
    }

    public SelectorPartSymbolImpl(@NotNull OCMethodSymbol.SelectorPartSymbol origin, @NotNull OCTypeSubstitution substitution) {
        this(origin.getParameter(), origin.getSelectorName());
        this.substitution = OCTypeSubstitution.compose(origin.getSubstitution(), substitution);
    }

    @Override
    @Nullable
    public OCDeclaratorSymbol getParameter() {
        return this.substitution.substitute(this.parameter);
    }

    @Override
    @Nullable
    public OCDeclaratorSymbol getParameterWithoutSubstitution() {
        return this.parameter;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        return this.substitution;
    }

    @Override
    @Nullable
    public String getSelectorName() {
        return this.selectorName;
    }

    public boolean equals(Object o) {
        return DeepEqual.equalObjects(this, o);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull OCMethodSymbol.SelectorPartSymbol first, @NotNull OCMethodSymbol.SelectorPartSymbol second) {
        if (!Comparing.equal((String)first.getSelectorName(), (String)second.getSelectorName())) {
            return false;
        }
        if (!c.equalObjects(first.getSubstitution(), second.getSubstitution())) {
            return false;
        }
        return c.equalObjects(first.getParameter(), second.getParameter());
    }

    public int hashCode() {
        int result = this.selectorName != null ? this.selectorName.hashCode() : 0;
        result = 31 * result + (this.parameter != null ? this.parameter.hashCode() : 0);
        return result;
    }
}

