/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.OCDeprecatedWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGlobalProjectSymbolsCache<T extends OCSymbol, S extends Symbols<T>> {
    @NotNull
    private final CachedValue<S> myGlobalSymbols;
    @NotNull
    private final ReentrantLock myGlobalSymbolsLock = new ReentrantLock();
    @NotNull
    private final CachedValue<MultiValuesMap<String, T>> myGlobalShortNames;
    @NotNull
    private final ReentrantLock myGlobalShortNamesLock = new ReentrantLock();

    protected <Impl extends AbstractGlobalProjectSymbolsCache<T, S>> AbstractGlobalProjectSymbolsCache(@NotNull Class<Impl> clazz, @NotNull Project project2) {
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project2);
        this.myGlobalSymbols = manager.createCachedValue(() -> {
            if (!FileSymbolTablesCache.areSymbolsLoaded(project2)) {
                throw IndexNotReadyException.create();
            }
            S symbols = this.buildGlobalSymbols(project2);
            ModificationTracker changeTracker = FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker();
            return CachedValueProvider.Result.create(symbols, (Object[])new Object[]{OCSymbolTablesBuildingActivity.getInstance(project2).getModificationTracker(), changeTracker});
        }, false);
        this.myGlobalShortNames = manager.createCachedValue(() -> {
            assert (FileSymbolTablesCache.areSymbolsLoaded(project2)) : "Symbols must be loaded";
            MultiValuesMap result = new MultiValuesMap();
            AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project2, symbol -> {
                result.put((Object)symbol.getName(), symbol);
                return true;
            }, null);
            ModificationTracker changeTracker = FileSymbolTablesCache.getInstance(project2).getOutOfBlockModificationTracker();
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{OCSymbolTablesBuildingActivity.getInstance(project2).getModificationTracker(), changeTracker});
        }, false);
    }

    @Nullable
    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> T findNearestTopLevelSymbol(@NotNull Class<Impl> clazz, @NotNull Project project2, @Nullable String name2, @Nullable Condition<? super T> condition, @Nullable VirtualFile contextFile) {
        OCWorkspace workspace = OCWorkspace.getInstance(project2);
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor<T>((Processor)finder, true, new Condition[]{symbol -> contextFile != null && Comparing.equal((Object)symbol.getContainingFile(), (Object)contextFile), symbol -> {
            VirtualFile file = symbol.getContainingFile();
            return contextFile != null && file != null && Comparing.equal((String)file.getNameWithoutExtension(), (String)contextFile.getNameWithoutExtension());
        }, symbol -> {
            VirtualFile file = symbol.getContainingFile();
            return contextFile != null && file != null && Comparing.equal((Object)file.getParent(), (Object)contextFile.getParent());
        }, symbol -> {
            VirtualFile symbolFile = symbol.getContainingFile();
            return workspace instanceof OCDeprecatedWorkspace && ((OCDeprecatedWorkspace)workspace).areFromSameProject(contextFile, symbolFile);
        }, Conditions.alwaysTrue()}){

            @Override
            public Collection<T> sort(Collection<T> collection) {
                ArrayList list = new ArrayList(collection);
                Collections.sort(list, Comparator.comparingInt(Object::hashCode));
                return list;
            }
        };
        AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project2, symbol -> {
            if (condition != null && !condition.value(symbol)) {
                return true;
            }
            if (workspace instanceof OCDeprecatedWorkspace && ((OCDeprecatedWorkspace)workspace).isFromWrongSDK((OCSymbol)symbol, contextFile)) {
                return true;
            }
            return orderedProcessor.process(symbol);
        }, name2, true);
        orderedProcessor.finish();
        return (T)((OCSymbol)finder.getFoundValue());
    }

    @NotNull
    public static <T> T getInstance(@NotNull Class<T> clazz, @NotNull Project project2) {
        return (T)project2.getComponent(clazz);
    }

    @NotNull
    protected S getGlobalSymbols() {
        return (S)((Symbols)AbstractGlobalProjectSymbolsCache.withLock(this.myGlobalSymbolsLock, () -> (Symbols)this.myGlobalSymbols.getValue()));
    }

    @NotNull
    protected MultiValuesMap<String, T> getGlobalShortNames() {
        return (MultiValuesMap)AbstractGlobalProjectSymbolsCache.withLock(this.myGlobalShortNamesLock, () -> (MultiValuesMap)this.myGlobalShortNames.getValue());
    }

    public static <T> T withLock(@NotNull ReentrantLock lock, @NotNull Computable<T> computable) {
        while (true) {
            ProgressManager.checkCanceled();
            try {
                if (!lock.tryLock(100L, TimeUnit.MILLISECONDS)) continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    protected abstract S buildGlobalSymbols(@NotNull Project var1);

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processTopLevelSymbols(@NotNull Class<Impl> clazz, @NotNull Project project2, @NotNull Processor<? super T> processor2, @Nullable String name2) {
        return AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project2, processor2, name2, true);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processTopLevelAndMemberSymbols(@NotNull Class<Impl> clazz, @NotNull Project project2, @NotNull Processor<? super T> processor2, @Nullable String name2) {
        return AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(clazz, project2, processor2, name2, false);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processByQualifiedName(@NotNull Class<Impl> clazz, @NotNull Project project2, @NotNull Processor<? super T> processor2, @NotNull String name2) {
        Collection iterable = ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project2)).getGlobalShortNames().get((Object)name2);
        return iterable == null || ContainerUtil.process((Iterable)iterable, processor2);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache> boolean processAliasNamesForType(@NotNull Class<Impl> clazz, @NotNull Project project2, @NotNull String name2, @NotNull Processor<? super String> processor2) {
        FileSymbolTablesCache.getInstance(project2).ensurePendingFilesProcessed();
        return ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project2)).getGlobalSymbols().processAliasNamesForType(name2, processor2);
    }

    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> boolean processTopLevelAndMemberSymbols(@NotNull Class<Impl> clazz, @NotNull Project project2, @NotNull Processor<? super T> processor2, @Nullable String name2, boolean topLevelOnly) {
        FileSymbolTablesCache.getInstance(project2).ensurePendingFilesProcessed();
        Object symbols = ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project2)).getGlobalSymbols();
        if (topLevelOnly) {
            return symbols.processTopLevel(processor2, name2);
        }
        return symbols.processAllSymbols(processor2, name2);
    }

    @NotNull
    protected static <Impl extends AbstractGlobalProjectSymbolsCache<T, ? extends Symbols<T>>, T extends OCSymbol> Set<String> getAllSymbolNames(@NotNull Class<Impl> clazz, @NotNull Project project2) {
        return ((AbstractGlobalProjectSymbolsCache)AbstractGlobalProjectSymbolsCache.getInstance(clazz, project2)).getGlobalShortNames().keySet();
    }

    public static interface Symbols<T> {
        public boolean processAliasNamesForType(@NotNull String var1, @NotNull Processor<? super String> var2);

        public boolean processTopLevel(@NotNull Processor<? super T> var1, @Nullable String var2);

        public boolean processAllSymbols(@NotNull Processor<? super T> var1, @Nullable String var2);
    }
}

