/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Computable;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import java.util.Collection;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinPool;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\b'\u0018\u0000 \u0013*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001b\u0010\f\u001a\u00028\u00002\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0004\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0004J\u001e\u0010\u0012\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0004R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/CallerAwareJob;", "O", "", "estimatedWorksetSize", "", "(I)V", "callerWorkset", "Ljava/util/Deque;", "Ljava/util/concurrent/CountedCompleter;", "workerQuota", "getWorkerQuota", "()I", "run", "rootWorker", "(Ljava/util/concurrent/CountedCompleter;)Ljava/lang/Object;", "forkAsPending", "", "worker", "scheduleOnCallerAsPending", "Companion", "IterativeWorker", "intellij.c"})
@ApiStatus.Experimental
public abstract class CallerAwareJob<O> {
    private final int workerQuota;
    private final Deque<CountedCompleter<O>> callerWorkset;
    public static final int MIN_FORK_SIZE = 16;
    public static final int TOO_SMALL_TO_SPLIT = 30;
    public static final Companion Companion = new Companion(null);

    protected final int getWorkerQuota() {
        return this.workerQuota;
    }

    protected final O run(@NotNull CountedCompleter<O> rootWorker) {
        return (O)OCLongActionUtil.runWithoutUiPriorityIfNeeded((Computable)new Computable<T>(this, rootWorker){
            final /* synthetic */ CallerAwareJob this$0;
            final /* synthetic */ CountedCompleter $rootWorker;

            public final O compute() {
                this.$rootWorker.fork();
                while (!this.$rootWorker.isDone()) {
                    ProgressManager.checkCanceled();
                    while ((CountedCompleter)CallerAwareJob.access$getCallerWorkset$p(this.this$0).poll() != null) {
                        CountedCompleter callerWorker;
                        try {
                            callerWorker.compute();
                        }
                        catch (Throwable t) {
                            callerWorker.completeExceptionally(t);
                        }
                    }
                    this.$rootWorker.helpComplete(1);
                }
                return (O)this.$rootWorker.join();
            }
            {
                this.this$0 = callerAwareJob;
                this.$rootWorker = countedCompleter;
            }
        });
    }

    protected final void forkAsPending(@NotNull CountedCompleter<?> $receiver, @NotNull CountedCompleter<O> worker) {
        $receiver.addToPendingCount(1);
        worker.fork();
    }

    protected final void scheduleOnCallerAsPending(@NotNull CountedCompleter<?> $receiver, @NotNull CountedCompleter<O> worker) {
        $receiver.addToPendingCount(1);
        this.callerWorkset.push(worker);
    }

    public CallerAwareJob(int estimatedWorksetSize) {
        int n;
        int n2 = 30;
        int n3 = estimatedWorksetSize / ForkJoinPool.getCommonPoolParallelism() / 4;
        CallerAwareJob callerAwareJob = this;
        callerAwareJob.workerQuota = n = Math.max(n2, n3);
        this.callerWorkset = new ConcurrentLinkedDeque();
    }

    public static final /* synthetic */ Deque access$getCallerWorkset$p(CallerAwareJob $this) {
        return $this.callerWorkset;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u00a4\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B#\u0012\f\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00028\u00010\u0000R\b\u0012\u0004\u0012\u00028\u00000\f2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005H$J \u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u00052\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005H$J\b\u0010\u000f\u001a\u00020\nH$J%\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005*\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0082\u0010R\u001c\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00010\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/CallerAwareJob$IterativeWorker;", "I", "Ljava/util/concurrent/CountedCompleter;", "parent", "initialWorkset", "Lcom/google/common/collect/ImmutableList;", "(Lcom/jetbrains/cidr/lang/symbols/symtable/CallerAwareJob;Ljava/util/concurrent/CountedCompleter;Lcom/google/common/collect/ImmutableList;)V", "getInitialWorkset", "()Lcom/google/common/collect/ImmutableList;", "compute", "", "newWorker", "Lcom/jetbrains/cidr/lang/symbols/symtable/CallerAwareJob;", "workset", "process", "processingFinished", "splitWorkset", "quota", "", "intellij.c"})
    protected abstract class IterativeWorker<I>
    extends CountedCompleter<O> {
        @NotNull
        private final ImmutableList<? extends I> initialWorkset;

        @Override
        public final void compute() {
            Collection collection;
            int quota = CallerAwareJob.this.getWorkerQuota();
            ImmutableList<? extends I> workset = this.splitWorkset(this.initialWorkset, quota);
            while (!(collection = (Collection)workset).isEmpty()) {
                workset = this.splitWorkset(this.process(workset), quota -= workset.size());
            }
            this.processingFinished();
        }

        private final ImmutableList<? extends I> splitWorkset(@NotNull ImmutableList<? extends I> $receiver, int quota) {
            int size;
            while ((size = $receiver.size()) > quota) {
                int split = size > 30 ? size / 2 : 0;
                ImmutableList left = $receiver.subList(0, split);
                ImmutableList right = $receiver.subList(split, size);
                CallerAwareJob.this.forkAsPending(this, this.newWorker(right));
                $receiver = left;
            }
            return $receiver;
        }

        @NotNull
        protected abstract IterativeWorker<I> newWorker(@NotNull ImmutableList<? extends I> var1);

        @NotNull
        protected abstract ImmutableList<? extends I> process(@NotNull ImmutableList<? extends I> var1);

        protected abstract void processingFinished();

        @NotNull
        protected final ImmutableList<? extends I> getInitialWorkset() {
            return this.initialWorkset;
        }

        public IterativeWorker(@NotNull CountedCompleter<?> parent, ImmutableList<? extends I> initialWorkset) {
            super(parent);
            this.initialWorkset = initialWorkset;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/cidr/lang/symbols/symtable/CallerAwareJob$Companion;", "", "()V", "MIN_FORK_SIZE", "", "TOO_SMALL_TO_SPLIT", "intellij.c"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

