/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextSignature
implements Serializable {
    public static final int NO_EXACT_DEFINITION_MARKER = Integer.MAX_VALUE;
    @NotNull
    private final String[] myDefined;
    @NotNull
    private final int[] myDefinedHashes;
    @NotNull
    private final String[] myNotDefined;
    @NotNull
    private final String[] myNamespace;
    private int myDistinctiveDefinedCount = 0;
    private int myDistinctiveNotDefinedCount = 0;
    @Nullable
    public final OCLanguageKind myLanguageKind;
    final boolean myIsSurrogate;

    public ContextSignature(@Nullable OCLanguageKind kind, Map<String, Integer> definitions, Set<String> notDefined, @NotNull List<String> namespace, boolean isSurrogate) {
        this.myLanguageKind = kind;
        this.myIsSurrogate = isSurrogate;
        int defSize = definitions.size();
        this.myDefined = ArrayUtil.newStringArray((int)defSize);
        this.myDefinedHashes = ArrayUtil.newIntArray((int)defSize);
        int curDef = 0;
        for (Map.Entry<String, Integer> e : definitions.entrySet()) {
            this.myDefined[curDef] = e.getKey();
            Integer hash = e.getValue();
            this.myDefinedHashes[curDef] = hash == null ? Integer.MAX_VALUE : ContextSignature.packedHash(hash);
            ++curDef;
        }
        this.myNotDefined = ArrayUtil.toStringArray(notDefined);
        this.myNamespace = ArrayUtil.toStringArray(namespace);
    }

    public ContextSignature() {
        this(null, Collections.emptyMap(), Collections.emptySet(), Collections.emptyList(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompatible(@NotNull OCImmutableInclusionContext ctx) {
        if (ctx.getLanguageKind() != this.myLanguageKind) {
            return false;
        }
        if (this.myIsSurrogate && !ctx.isSurrogate()) {
            return false;
        }
        List<String> namespace = ctx.getCurrentNamespace();
        if (!namespace.equals(Arrays.asList(this.myNamespace))) {
            return false;
        }
        ContextSignature contextSignature = this;
        synchronized (contextSignature) {
            int i;
            for (i = 0; i < this.myDistinctiveDefinedCount; ++i) {
                if (ContextSignature.checkDefined(ctx, this.myDefined[i], this.myDefinedHashes[i])) continue;
                return false;
            }
            for (i = 0; i < this.myDistinctiveNotDefinedCount; ++i) {
                if (!ContextSignature.isDefined(ctx, this.myNotDefined[i])) continue;
                return false;
            }
            for (i = this.myDistinctiveDefinedCount; i < this.myDefined.length; ++i) {
                if (ContextSignature.checkDefined(ctx, this.myDefined[i], this.myDefinedHashes[i])) continue;
                ArrayUtil.swap((Object[])this.myDefined, (int)this.myDistinctiveDefinedCount, (int)i);
                ArrayUtil.swap((int[])this.myDefinedHashes, (int)this.myDistinctiveDefinedCount, (int)i);
                ++this.myDistinctiveDefinedCount;
                return false;
            }
            for (i = this.myDistinctiveNotDefinedCount; i < this.myNotDefined.length; ++i) {
                if (!ContextSignature.isDefined(ctx, this.myNotDefined[i])) continue;
                ArrayUtil.swap((Object[])this.myNotDefined, (int)this.myDistinctiveNotDefinedCount, (int)i);
                ++this.myDistinctiveNotDefinedCount;
                return false;
            }
        }
        return true;
    }

    private static boolean isDefined(@NotNull OCImmutableInclusionContext ctx, @NotNull String def) {
        return ctx.getDefinition(def, OCImmutableInclusionContext.SignaturePart.NO) != null;
    }

    public static boolean checkDefined(@NotNull OCImmutableInclusionContext ctx, String def, int defHash) {
        boolean ok;
        boolean shouldCheckExactDefinition = defHash != Integer.MAX_VALUE;
        OCMacroSymbol ctxDef = ctx.getDefinition(def, OCImmutableInclusionContext.SignaturePart.NO);
        boolean bl = ok = ctxDef != null;
        if (ok && shouldCheckExactDefinition) {
            ok = defHash == ContextSignature.packedHash(ctxDef.getSubstitutionHash());
        }
        return ok;
    }

    private static int packedHash(int hash) {
        return hash == Integer.MAX_VALUE ? hash - 1 : hash;
    }

    public boolean sameSignature(@NotNull ContextSignature other) {
        HashSet nd2;
        if (!Comparing.equal((Object)this.myLanguageKind, (Object)other.myLanguageKind)) {
            return false;
        }
        if (this.myIsSurrogate != other.myIsSurrogate) {
            return false;
        }
        HashSet nd1 = ContainerUtil.newHashSet((Object[])this.myNotDefined);
        if (!Comparing.equal((Object)nd1, (Object)(nd2 = ContainerUtil.newHashSet((Object[])other.myNotDefined)))) {
            return false;
        }
        Map d1 = ContainerUtil.newHashMap(Arrays.asList(this.myDefined), (List)ArraysKt.asList((int[])this.myDefinedHashes));
        Map d2 = ContainerUtil.newHashMap(Arrays.asList(other.myDefined), (List)ArraysKt.asList((int[])other.myDefinedHashes));
        return Comparing.equal((Object)d1, (Object)d2);
    }
}

