/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.CallerAwareJob;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import gnu.trove.THashMap;
import gnu.trove.TObjectByteHashMap;
import gnu.trove.TObjectObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DirtyIncludesInvalidator
extends CallerAwareJob<Collection<VirtualFile>> {
    @NotNull
    private final FileSymbolTablesCache myCache;
    @NotNull
    private final ModuleMapManager moduleMapManager;
    @NotNull
    private final ModuleMapResolveService moduleMapResolveService;
    @NotNull
    private final MyConcurrentObjBoolMap<String> moduleDirtyCache = new MyConcurrentObjBoolMap();
    @NotNull
    private final Set<String> myDirtyNames;
    private final boolean myIsRelativePath;

    DirtyIncludesInvalidator(@NotNull FileSymbolTablesCache cache, @NotNull Set<String> dirtyNames, boolean isRelativePath, int estimatedWorksetSize) {
        super(estimatedWorksetSize);
        this.myCache = cache;
        this.moduleMapManager = ModuleMapManager.getInstance(cache.getProject());
        this.moduleMapResolveService = ModuleMapResolveService.getInstance(cache.getProject());
        this.myDirtyNames = dirtyNames;
        this.myIsRelativePath = isRelativePath;
    }

    @NotNull
    Collection<VirtualFile> collect(@NotNull ImmutableList<VirtualFile> workset) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return (Collection)this.run(new FileWorker(null, workset));
    }

    private static final class MyConcurrentObjBoolMap<T> {
        @NotNull
        private final TObjectByteHashMap<T> map = new TObjectByteHashMap();
        @NotNull
        private final Lock r;
        @NotNull
        private final Lock w;

        MyConcurrentObjBoolMap() {
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.w = lock.writeLock();
            this.r = lock.readLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        Boolean getBoolean(@NotNull T key) {
            this.r.lock();
            try {
                byte b = this.map.get(key);
                Boolean bl = b == 0 ? null : Boolean.valueOf(b > 0);
                return bl;
            }
            finally {
                this.r.unlock();
            }
        }

        void putBoolean(@NotNull T key, boolean value) {
            this.w.lock();
            try {
                this.map.put(key, (byte)(value ? 1 : -1));
            }
            finally {
                this.w.unlock();
            }
        }

        void ensureCapacity(int desiredAdditionalCapacity) {
            this.w.lock();
            try {
                this.map.ensureCapacity(desiredAdditionalCapacity);
            }
            finally {
                this.w.unlock();
            }
        }
    }

    private final class ModuleWorker
    extends CountedCompleter<Collection<VirtualFile>>
    implements TObjectObjectProcedure<String, Collection<VirtualFile>> {
        @NotNull
        private final THashMap<String, Collection<VirtualFile>> workset;
        @NotNull
        private final Set<VirtualFile> result;

        private ModuleWorker(@NotNull FileWorker parent, THashMap<String, Collection<VirtualFile>> workset) {
            super(parent);
            this.result = ContainerUtil.newTroveSet();
            this.workset = workset;
        }

        @NotNull
        private FileWorker getParent() {
            return (FileWorker)this.getCompleter();
        }

        @Override
        public void compute() {
            AlreadyComputedRemover remover = new AlreadyComputedRemover();
            ((MyConcurrentObjBoolMap)DirtyIncludesInvalidator.this.moduleDirtyCache).r.lock();
            try {
                this.workset.forEachEntry((TObjectObjectProcedure)remover);
            }
            finally {
                ((MyConcurrentObjBoolMap)DirtyIncludesInvalidator.this.moduleDirtyCache).r.unlock();
            }
            int additionalCapacity = this.workset.size() - remover.alreadyComputed;
            DirtyIncludesInvalidator.this.moduleDirtyCache.ensureCapacity(additionalCapacity);
            this.workset.forEachEntry((TObjectObjectProcedure)this);
            this.tryComplete();
        }

        public boolean execute(@NotNull String moduleName, @NotNull Collection<VirtualFile> files) {
            if (files.isEmpty()) {
                return true;
            }
            ModuleMapModuleSymbol module2 = DirtyIncludesInvalidator.this.moduleMapManager.findModule(moduleName, null);
            if (module2 != null) {
                for (String name2 : DirtyIncludesInvalidator.this.myIsRelativePath ? DirtyIncludesInvalidator.this.moduleMapResolveService.getIncludeHeaderRelativePaths(module2) : ContainerUtil.map(DirtyIncludesInvalidator.this.moduleMapResolveService.getIncludeHeaders(module2, null), VirtualFile::getName)) {
                    if (!DirtyIncludesInvalidator.this.myDirtyNames.contains(name2)) continue;
                    DirtyIncludesInvalidator.this.moduleDirtyCache.putBoolean(moduleName, true);
                    this.result.addAll(files);
                    return true;
                }
            }
            DirtyIncludesInvalidator.this.moduleDirtyCache.putBoolean(moduleName, false);
            return true;
        }

        @Override
        public Set<VirtualFile> getRawResult() {
            return this.result;
        }

        @Override
        public void onCompletion(CountedCompleter<?> caller) {
            if (!this.result.isEmpty()) {
                this.getParent().propagateResults(this.result);
            }
        }

        private class AlreadyComputedRemover
        implements TObjectObjectProcedure<String, Collection<VirtualFile>> {
            private int alreadyComputed = 0;

            private AlreadyComputedRemover() {
            }

            public boolean execute(@NotNull String moduleName, @NotNull Collection<VirtualFile> files) {
                Boolean dirty = DirtyIncludesInvalidator.this.moduleDirtyCache.getBoolean(moduleName);
                if (dirty == null) {
                    return true;
                }
                if (dirty.booleanValue()) {
                    ModuleWorker.this.result.addAll(files);
                }
                files.clear();
                ++this.alreadyComputed;
                return true;
            }
        }
    }

    private final class FileWorker
    extends CallerAwareJob.IterativeWorker<VirtualFile> {
        @NotNull
        private final THashMap<String, Collection<VirtualFile>> additionalModulesWorkset;
        @NotNull
        private final Set<String> newModulesImportedByFile;
        @NotNull
        private final List<VirtualFile> result;

        private FileWorker(@NotNull FileWorker parent, ImmutableList<? extends VirtualFile> workset) {
            super(parent, workset);
            this.additionalModulesWorkset = ContainerUtil.newTroveMap();
            this.newModulesImportedByFile = ContainerUtil.newTroveSet();
            this.result = new ArrayList<VirtualFile>();
        }

        @Nullable
        private FileWorker getParent() {
            return (FileWorker)this.getCompleter();
        }

        @NotNull
        protected FileWorker newWorker(@NotNull ImmutableList<? extends VirtualFile> workset) {
            return new FileWorker(this, workset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected ImmutableList<? extends VirtualFile> process(@NotNull ImmutableList<? extends VirtualFile> workset) {
            block3: for (VirtualFile file : workset) {
                this.newModulesImportedByFile.clear();
                for (FileSymbolTable table : DirtyIncludesInvalidator.this.myCache.allTablesForFile(file)) {
                    for (OCSymbol include : table.getContents()) {
                        if (!(include instanceof OCIncludeSymbol ? this.isIncludeDirty((OCIncludeSymbol)include) : include instanceof OCModuleImportSymbol && this.isModuleDirty(include))) continue;
                        List<VirtualFile> list = this.result;
                        synchronized (list) {
                            this.result.add(file);
                            continue block3;
                        }
                    }
                }
                for (String moduleName : this.newModulesImportedByFile) {
                    ((Collection)this.additionalModulesWorkset.computeIfAbsent((Object)moduleName, m -> ContainerUtil.newSmartList())).add(file);
                }
            }
            return ImmutableList.of();
        }

        private boolean isIncludeDirty(@NotNull OCIncludeSymbol includeSymbol) {
            return DirtyIncludesInvalidator.this.myDirtyNames.contains(DirtyIncludesInvalidator.this.myIsRelativePath ? includeSymbol.getRelativePath() : includeSymbol.getLastPathComponent());
        }

        private boolean isModuleDirty(@NotNull OCSymbol include) {
            String moduleName = include.getName();
            Boolean dirty = DirtyIncludesInvalidator.this.moduleDirtyCache.getBoolean(moduleName);
            if (dirty == null) {
                this.newModulesImportedByFile.add(moduleName);
            }
            return dirty == Boolean.TRUE;
        }

        @Override
        protected void processingFinished() {
            if (!this.additionalModulesWorkset.isEmpty()) {
                DirtyIncludesInvalidator.this.scheduleOnCallerAsPending(this, new ModuleWorker(this, this.additionalModulesWorkset));
            }
            this.tryComplete();
        }

        @Override
        public void onCompletion(@NotNull CountedCompleter<?> caller) {
            FileWorker parent = this.getParent();
            if (parent != null && !this.result.isEmpty()) {
                parent.propagateResults(this.result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void propagateResults(Collection<VirtualFile> childResults) {
            List<VirtualFile> list = this.result;
            synchronized (list) {
                this.result.addAll(childResults);
            }
        }

        @Override
        public List<VirtualFile> getRawResult() {
            return this.result;
        }
    }
}

