/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCModuleResolver;
import com.jetbrains.cidr.lang.preprocessor.OCParsingNameScope;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolOffsetUtil;
import com.jetbrains.cidr.lang.symbols.VirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.SerializationSession;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import gnu.trove.THashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTable
implements Serializable,
VirtualFileOwner {
    public static final FileSymbolTable[] EMPTY_ARRAY = new FileSymbolTable[0];
    private static boolean ourShouldCompactSymbols = true;
    private static final Key<Map<Class, Pair<Integer, Integer>>> DEBUG_STATS_KEY = Key.create((String)"FileSymbolTable.STATS_KEY");
    private static final Logger LOG = Logger.getInstance(FileSymbolTable.class);
    private ArrayList<OCSymbol> myContents = new ArrayList();
    private ContextSignature mySignature;
    private volatile int myPackStamp;
    private transient VirtualFile myFile;
    private volatile transient int myUsingCount;
    private volatile transient boolean myValid = true;
    private volatile transient boolean myFallback;

    public FileSymbolTable() {
    }

    @Override
    public void init(@NotNull VirtualFile file) {
        this.myFile = file;
    }

    public FileSymbolTable(@NotNull VirtualFile file, @NotNull ContextSignature signature) {
        this.init(file);
        this.mySignature = signature;
    }

    public void compact() {
        this.myContents.trimToSize();
    }

    @NotNull
    public ContextSignature getSignature() {
        return this.mySignature;
    }

    @Override
    @NotNull
    public VirtualFile getContainingFile() {
        return this.myFile;
    }

    @NotNull
    public List<OCSymbol> getContents() {
        return this.myContents;
    }

    public int internSymbols(@NotNull UserDataHolder statsHolder, Function<? super OCSymbol, ? extends OCSymbol> internator) {
        int internedCount = 0;
        for (int i = 0; i < this.myContents.size(); ++i) {
            OCSymbol each = this.myContents.get(i);
            OCSymbol replacement = (OCSymbol)internator.fun((Object)each);
            FileSymbolTable.incInterned(statsHolder, each, false);
            if (each != replacement) {
                ++internedCount;
                FileSymbolTable.incInterned(statsHolder, each, true);
                this.myContents.set(i, replacement);
                continue;
            }
            if (!ourShouldCompactSymbols) continue;
            each.compact();
        }
        return internedCount;
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void setFallback(boolean fallback) {
        this.myFallback = fallback;
    }

    public boolean isFallback() {
        return this.myFallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incInterned(@NotNull UserDataHolder statsHolder, @NotNull OCSymbol each, boolean interned) {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        HashMap stats = (HashMap)statsHolder.getUserData(DEBUG_STATS_KEY);
        if (stats == null) {
            stats = new HashMap();
            statsHolder.putUserData(DEBUG_STATS_KEY, stats);
        }
        HashMap hashMap = stats;
        synchronized (hashMap) {
            Pair s = (Pair)stats.get(each.getClass());
            if (s == null) {
                s = new Pair((Object)0, (Object)0);
            }
            s = interned ? new Pair((Object)((Integer)s.first + 1), s.second) : new Pair(s.first, (Object)((Integer)s.second + 2));
            stats.put(each.getClass(), s);
            if (each instanceof OCNamespaceSymbol) {
                ((OCNamespaceSymbol)each).processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol -> {
                    FileSymbolTable.incInterned(statsHolder, symbol, false);
                    FileSymbolTable.incInterned(statsHolder, symbol, true);
                    return true;
                }));
            } else if (each instanceof OCClassSymbol) {
                ((OCClassSymbol)each).processMembers(null, OCMemberSymbol.class, symbol -> {
                    FileSymbolTable.incInterned(statsHolder, symbol, false);
                    FileSymbolTable.incInterned(statsHolder, symbol, true);
                    return true;
                });
            }
        }
    }

    public boolean tryReuseContents(FileSymbolTable original) {
        ArrayList<OCSymbol> tc = original.myContents;
        List<OCSymbol> contents = this.getContents();
        if (FileSymbolTable.hasSameElements(tc, contents)) {
            this.myContents = tc;
            return true;
        }
        return false;
    }

    public static void reportStats(@NotNull Project project2) {
        Map stats = (Map)project2.getUserData(DEBUG_STATS_KEY);
        if (stats == null) {
            return;
        }
        project2.putUserData(DEBUG_STATS_KEY, null);
        for (Map.Entry each : stats.entrySet()) {
            LOG.debug(((Class)each.getKey()).getSimpleName() + ": interned=" + ((Pair)each.getValue()).first + " count=" + ((Pair)each.getValue()).second);
        }
    }

    public void updateOffsets(int start, int lengthShift, THashSet<OCSymbol> processed) {
        for (OCSymbol symbol : this.myContents) {
            if (!processed.add((Object)symbol)) continue;
            symbol.updateOffset(start, lengthShift);
        }
    }

    @Nullable
    public static FileSymbolTable forFile(@NotNull PsiFile file, @NotNull OCInclusionContext context) {
        return FileSymbolTable.forFile(file, context, null);
    }

    @Nullable
    public static FileSymbolTable forFile(@NotNull PsiFile file, @NotNull OCInclusionContext context, @Nullable SerializationSession serializationSession) {
        Project project2 = file.getProject();
        OCSymbolTablesBuildingActivity.getInstance(project2).assertParsingAndSymbolBuildingAllowed();
        file = file.getOriginalFile();
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project2);
        return cache.forFile(file, context, serializationSession);
    }

    @Nullable
    public static FileSymbolTable forFile(@NotNull VirtualFile file, @NotNull OCInclusionContext context) {
        return FileSymbolTable.forFile(file, context, null);
    }

    @Nullable
    public static FileSymbolTable forFile(@NotNull VirtualFile file, @NotNull OCInclusionContext context, @Nullable SerializationSession serializationSession) {
        Project project2 = context.getProject();
        OCSymbolTablesBuildingActivity.getInstance(project2).assertParsingAndSymbolBuildingAllowed();
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project2);
        return cache.forFile(file, context, serializationSession);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull PsiElement element, @NotNull Class<T> symbolClass) {
        return this.findSymbol(element, null, symbolClass);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@NotNull PsiElement element, @Nullable String symbolName, @NotNull Class<T> symbolClass) {
        String lookupName = symbolName != null ? symbolName : OCElementUtil.getSymbolName(element);
        long offset = element instanceof OCElement ? ((OCElement)element).getComplexOffset() : OCSymbolOffsetUtil.getComplexOffset(element.getTextOffset(), 0);
        return this.findSymbol(lookupName, offset, symbolClass);
    }

    @Nullable
    public <T extends OCSymbol> T findSymbol(@Nullable String symbolName, @NotNull Class<T> symbolClass) {
        return this.findSymbol(symbolName, -1L, symbolClass);
    }

    @Nullable
    private <T extends OCSymbol> T findSymbol(final @Nullable String symbolName, final long complexOffset, final @NotNull Class<T> symbolClass) {
        final OCSymbol[] result = new OCSymbol[1];
        final OCSymbol[] possible = new OCSymbol[1];
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                symbol = symbol.getDelegate();
                if ((complexOffset == -1L || symbol.getOffset() == OCSymbolOffsetUtil.getTextOffset(complexOffset)) && (symbolName == null || Comparing.equal((String)symbolName, (String)symbol.getName())) && symbolClass.isAssignableFrom(symbol.getClass())) {
                    if (complexOffset == -1L || symbol.getComplexOffset() == complexOffset) {
                        result[0] = symbol;
                        return false;
                    }
                    possible[0] = symbol;
                }
                if (symbol instanceof OCNamespaceSymbol) {
                    return ((OCNamespaceSymbol)symbol).processMembers((String)null, this);
                }
                if (symbol instanceof OCClassSymbol) {
                    return ((OCClassSymbol)symbol).processMembers(symbolName, this);
                }
                return true;
            }
        };
        ContainerUtil.process(this.myContents, (Processor)processor2);
        if (result[0] != null) {
            return (T)result[0];
        }
        return (T)possible[0];
    }

    public boolean processFile(Processor<OCSymbol> processor2) {
        for (OCSymbol symbol : this.myContents) {
            ProgressManager.checkCanceled();
            if (processor2.process((Object)symbol.getDelegate())) continue;
            return false;
        }
        return true;
    }

    public boolean processFile(Processor<OCSymbol> processor2, int afterOffset, int beforeOffset) {
        return OCResolveUtil.processSymbolsFromList((Processor<OCSymbol>)((Processor)symbol -> processor2.process((Object)symbol.getDelegate())), this.myContents, afterOffset, beforeOffset);
    }

    public boolean processIncludes(@NotNull Processor<? super OCSymbol> processor2) {
        for (OCSymbol item : this.myContents) {
            if (!(item instanceof OCIncludeSymbol) && !(item instanceof OCModuleImportSymbol) || processor2.process((Object)item)) continue;
            return false;
        }
        return true;
    }

    public boolean shallowProcessSymbols(@NotNull Processor<? super OCSymbol> processor2) {
        for (OCSymbol content : this.myContents) {
            if (content == null || processor2.process((Object)content.getDelegate())) continue;
            return false;
        }
        return false;
    }

    public boolean processSymbols(@NotNull Processor<OCSymbol> processor2, @Nullable String symbolName, @NotNull ProcessingState state, @Nullable Map<OCSymbol, VirtualFile> importsMap, @Nullable VirtualFile firstImportLink, @Nullable VirtualFile breakOn) {
        if (this.isEmpty()) {
            return true;
        }
        if (!state.startProcessing(this)) {
            return true;
        }
        class Builder
        implements Processor<OCSymbol> {
            private final OCParsingNameScope myNameScope;
            final /* synthetic */ ProcessingState val$state;
            final /* synthetic */ Processor val$processor;
            final /* synthetic */ String val$symbolName;
            final /* synthetic */ VirtualFile val$breakOn;
            final /* synthetic */ VirtualFile val$firstImportLink;
            final /* synthetic */ Map val$importsMap;

            Builder(OCParsingNameScope nameScope) {
                this.val$state = processingState;
                this.val$processor = processor2;
                this.val$symbolName = string;
                this.val$breakOn = virtualFile;
                this.val$firstImportLink = virtualFile2;
                this.val$importsMap = map2;
                this.myNameScope = nameScope;
            }

            public boolean process(OCSymbol symbol) {
                ProgressManager.checkCanceled();
                if (symbol instanceof OCModuleImportSymbol) {
                    if (this.val$state.shouldProcessImports && !this.val$processor.process((Object)symbol)) {
                        return false;
                    }
                    return OCModuleResolver.processModuleImports(this.val$state.context, ((OCModuleImportSymbol)symbol).getNameParts(), (Processor<VirtualFile>)((Processor)file -> this.processInclude((VirtualFile)file, true)));
                }
                if (symbol instanceof OCIncludeSymbol) {
                    OCIncludeSymbol include = (OCIncludeSymbol)symbol;
                    include.enterNamespace(this.val$state.context);
                    VirtualFile includeFile = include.getTargetFile();
                    boolean once = include.isOnce();
                    if (this.val$state.shouldProcessImports && !this.val$processor.process((Object)symbol)) {
                        return false;
                    }
                    if (!this.processInclude(includeFile, once)) {
                        return false;
                    }
                    include.exitNamespace(this.val$state.context);
                    return true;
                }
                if (this.val$symbolName != null && !this.val$symbolName.equals(symbol.getName())) {
                    return true;
                }
                this.updateImportsMap(symbol);
                this.updateContext(symbol);
                return this.val$processor.process((Object)symbol);
            }

            private boolean processInclude(@Nullable VirtualFile includeFile, boolean once) {
                if (this.val$breakOn != null && Comparing.equal((Object)includeFile, (Object)this.val$breakOn)) {
                    return false;
                }
                FileSymbolTable table = this.findTableForInclude(includeFile, once);
                if (table != null) {
                    VirtualFile link;
                    VirtualFile virtualFile = link = this.val$firstImportLink == null ? includeFile : this.val$firstImportLink;
                    if (!table.processSymbols((Processor<OCSymbol>)this.val$processor, this.val$symbolName, this.val$state, this.val$importsMap, link, this.val$breakOn)) {
                        return false;
                    }
                }
                return true;
            }

            @Nullable
            private FileSymbolTable findTableForInclude(@Nullable VirtualFile includeFile, boolean once) {
                PsiFile psiFile;
                if (includeFile != null && includeFile.isValid() && SymbolTableProvider.isSourceFile(psiFile = PsiManager.getInstance((Project)this.val$state.context.getProject()).findFile(includeFile)) && this.val$state.context.reserveInclude(includeFile, once)) {
                    return this.val$state.cache.forFile(psiFile, this.val$state.context);
                }
                return null;
            }

            private void updateImportsMap(@NotNull OCSymbol symbol) {
                if (this.val$importsMap != null && this.val$firstImportLink != null) {
                    OCType type;
                    this.val$importsMap.put(symbol, this.val$firstImportLink);
                    if ((symbol instanceof OCAliasUsingSymbol || symbol.getKind() == OCSymbolKind.TYPEDEF) && (type = symbol.getType()) instanceof OCStructType) {
                        List<OCStructSymbol> ss = ((OCStructType)type).getStructs();
                        for (OCStructSymbol struct : ss) {
                            if (!struct.isUnnamed()) continue;
                            this.updateImportsMap(struct);
                        }
                    }
                    if (symbol instanceof OCMembersContainer) {
                        ((OCMembersContainer)((Object)symbol)).processMembers(null, symbol1 -> {
                            this.updateImportsMap((OCSymbol)symbol1);
                            return true;
                        });
                    }
                }
            }

            private void updateContext(OCSymbol symbol) {
                if (symbol instanceof OCMacroSymbol) {
                    this.val$state.context.define((OCMacroSymbol)symbol);
                } else if (symbol instanceof OCUndefMacroSymbol) {
                    this.val$state.context.undef(symbol.getName());
                } else {
                    OCSymbolKind kind = symbol.getKind();
                    boolean isCPP = this.val$state.context.getLanguageKind().isCpp();
                    if (isCPP && symbol instanceof OCNamespaceSymbol && !((OCNamespaceSymbol)symbol).isPredefinition()) {
                        OCParsingNameScope inner = this.myNameScope.defineNamespace(symbol.getName());
                        Builder innerProcessor = new Builder(inner);
                        ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<? super OCSymbol>)((Processor)symbol12 -> {
                            innerProcessor.updateContext((OCSymbol)symbol12);
                            return true;
                        }));
                    }
                    if (kind.isType()) {
                        if (kind == OCSymbolKind.PROTOCOL) {
                            this.myNameScope.defineProtocol(symbol.getName());
                        } else if (kind.isClass() || kind == OCSymbolKind.COMPATIBILITY_ALIAS) {
                            this.myNameScope.defineInterface(symbol.getName());
                        } else {
                            boolean isTemplate = isCPP && kind.isStructLike() && ((OCStructSymbol)symbol).isTemplateSymbol();
                            this.myNameScope.defineType(symbol.getName(), isTemplate);
                        }
                    } else if (isCPP) {
                        if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).getQualifiedName().getQualifier() == null) {
                            if (!symbol.getKind().isConstructorOrDestructor() && ((OCFunctionSymbol)symbol).isTemplateSymbol()) {
                                this.myNameScope.defineValue(symbol.getName(), true);
                            }
                        } else if (symbol instanceof OCUsingSymbol) {
                            if (symbol.getKind() == OCSymbolKind.NAMESPACE_USING_SYMBOL) {
                                this.myNameScope.defineNamespaceUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                            } else {
                                this.myNameScope.defineSymbolUsing(((OCUsingSymbol)symbol).getSymbolReference().getQualifiedName().flatten());
                            }
                        }
                    }
                }
            }
        }
        return this.processFile(new Builder(state.context.getNameScope()));
    }

    public boolean isEmpty() {
        return this.myContents.isEmpty();
    }

    public void append(OCSymbol symbol) {
        this.myContents.add(symbol);
    }

    public void appendAll(@NotNull List<OCSymbol> symbols) {
        this.myContents.addAll(symbols);
    }

    public void sortSymbols() {
        FileSymbolTable.sortSymbols(this.myContents);
    }

    private static void sortSymbols(@Nullable List<OCSymbol> symbols) {
        if (symbols != null) {
            symbols.sort(Comparator.comparingLong(OCSymbol::getComplexOffset));
            for (OCSymbol symbol : symbols) {
                if (!(symbol instanceof OCNamespaceSymbol)) continue;
                FileSymbolTable.sortSymbols(((OCNamespaceSymbol)symbol).getMembersList());
            }
        }
    }

    public synchronized int incUsageCount() {
        return ++this.myUsingCount;
    }

    public int getUsageCount() {
        return this.myUsingCount;
    }

    public void resetUsageCount() {
        this.myUsingCount = 1;
    }

    public int getPackStamp() {
        return this.myPackStamp;
    }

    public void setPackStamp(int packStamp) {
        this.myPackStamp = packStamp;
    }

    public static void setShouldCompactSymbols(boolean value) {
        ourShouldCompactSymbols = value;
    }

    private static boolean hasSameElements(List<OCSymbol> l1, List<OCSymbol> l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (l1.get(i) == l2.get(i)) continue;
            return false;
        }
        return true;
    }

    public static class ProcessingState {
        @NotNull
        private final OCInclusionContext context;
        @NotNull
        private final FileSymbolTablesCache cache;
        private final boolean shouldProcessImports;
        private final Set<List<OCSymbol>> myProcessed = new THashSet(ContainerUtil.identityStrategy());

        public ProcessingState(@NotNull OCInclusionContext context, boolean processImports) {
            this.context = context;
            this.cache = FileSymbolTablesCache.getInstance(context.getProject());
            this.shouldProcessImports = processImports;
        }

        public boolean startProcessing(@NotNull FileSymbolTable table) {
            return this.myProcessed.add(table.myContents);
        }
    }
}

