/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.FastInput;
import com.esotericsoftware.kryo.io.FastOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCKeywordElementType;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCastKind;
import com.jetbrains.cidr.lang.psi.OCExceptionSpecificationKind;
import com.jetbrains.cidr.lang.psi.impl.OCBlockExpressionImpl;
import com.jetbrains.cidr.lang.symbols.ComplexTextRange;
import com.jetbrains.cidr.lang.symbols.MaybeVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.OCDelegatingSymbol;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithArguments;
import com.jetbrains.cidr.lang.symbols.OCQualifiedNameWithDecltype;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.ProjectAndVirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.VirtualFileOwner;
import com.jetbrains.cidr.lang.symbols.cpp.OCAliasUsingSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbolImpl;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeductionGuideSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLabelSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCLocalFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroParameterSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceAliasSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUndefMacroSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCArgumentListSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCArrayIndexExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCBinaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCallExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCastExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCCommaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCConditionalExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCInitializerListExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLambdaExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCLiteralExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNewExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCNoexceptExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCPostfixExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCPrefixExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCSizeofExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCThrowExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnaryExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCUnknownExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCVariadicPackExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCCompatibilityAliasSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCGenericParameterSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCProtocolSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.SelectorPartSymbolImpl;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.MetaData;
import com.jetbrains.cidr.lang.symbols.symtable.NeverSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.OCJavaSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.OCSerializer;
import com.jetbrains.cidr.lang.symbols.symtable.SerializerProvider;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.CTypeId;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCDeferredType;
import com.jetbrains.cidr.lang.types.OCEllipsisType;
import com.jetbrains.cidr.lang.types.OCExpansionPackType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCExceptionSpecificationInfo;
import com.jetbrains.cidr.lang.util.OCImmutableList;
import com.jetbrains.cidr.lang.util.OCNumber;
import gnu.trove.TObjectIntHashMap;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objenesis.instantiator.ObjectInstantiator;

public class FileSymbolTableSerializer
extends OCSerializer {
    private VirtualFile myCurrentFile;
    private Project myProject;

    public void setProject(Project project2) {
        this.myProject = project2;
    }

    @Override
    protected void registerSerializers() {
        Kryo myKryo = this.getKryo();
        this.registerFieldSerializer(FileSymbolTablesPack.class, FileSymbolTablesPack::new);
        myKryo.register(TObjectIntHashMap.class, (Serializer)new OCJavaSerializer());
        this.registerFieldSerializer(ContextSignature.class, ContextSignature::new);
        this.registerFileOwnerSerializer(FileSymbolTable.class, FileSymbolTable::new);
        myKryo.register(OCQualifiedName.class, (Serializer)new Serializer<OCQualifiedName>(true){

            public void write(Kryo kryo, Output output, OCQualifiedName object) {
                kryo.writeClassAndObject(output, (Object)object.getQualifier());
                kryo.writeObjectOrNull(output, (Object)object.getName(), String.class);
            }

            public OCQualifiedName read(Kryo kryo, Input input, Class<OCQualifiedName> type) {
                OCQualifiedName qualifier = (OCQualifiedName)kryo.readClassAndObject(input);
                String name2 = (String)kryo.readObjectOrNull(input, String.class);
                return OCQualifiedName.interned(qualifier, name2);
            }
        });
        this.registerFieldSerializer(OCQualifiedNameWithArguments.class, OCQualifiedNameWithArguments::new);
        this.registerFieldSerializer(OCQualifiedNameWithDecltype.class, OCQualifiedNameWithDecltype::new);
        this.registerMaybeFileOwnerSerializer(OCImplementationSymbol.class, OCImplementationSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCInterfaceSymbolImpl.class, OCInterfaceSymbolImpl::new);
        this.registerMaybeFileOwnerSerializer(OCProtocolSymbolImpl.class, OCProtocolSymbolImpl::new);
        this.registerMaybeFileOwnerSerializer(OCLabelSymbol.class, OCLabelSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCMacroParameterSymbol.class, OCMacroParameterSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCMacroSymbol.class, OCMacroSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCInstanceVariableSymbolImpl.class, OCInstanceVariableSymbolImpl::new);
        this.registerMaybeFileOwnerSerializer(OCMethodSymbolImpl.class, OCMethodSymbolImpl::new);
        this.registerMaybeFileOwnerSerializer(OCPropertySymbolImpl.class, OCPropertySymbolImpl::new);
        this.registerMaybeFileOwnerSerializer(OCSynthesizeSymbol.class, OCSynthesizeSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCDeclaratorSymbolImpl.class, OCDeclaratorSymbolImpl::new);
        this.registerMaybeFileOwnerSerializer(OCFunctionSymbol.class, OCFunctionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCLocalFunctionSymbol.class, OCLocalFunctionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCNamespaceSymbol.class, OCNamespaceSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCNamespaceAliasSymbol.class, OCNamespaceAliasSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCStructSymbol.class, OCStructSymbol::new);
        myKryo.register(OCDelegatingSymbol.class, new Serializer(){

            public void write(Kryo kryo, Output output, Object object) {
                OCSymbol delegate = ((OCDelegatingSymbol)object).getRawDelegate();
                kryo.writeClass(output, delegate.getClass());
                kryo.writeObject(output, (Object)delegate);
            }

            public Object read(Kryo kryo, Input input, Class type) {
                Registration registration = kryo.readClass(input);
                return new OCDelegatingSymbol((OCSymbol)kryo.readObject(input, registration.getType()));
            }
        });
        this.registerMaybeFileOwnerSerializer(OCArgumentListSymbol.class, OCArgumentListSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCDeductionGuideSymbol.class, OCDeductionGuideSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCTypeParameterTypeSymbol.class, OCTypeParameterTypeSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCTypeParameterValueSymbol.class, OCTypeParameterValueSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCBinaryExpressionSymbol.class, OCBinaryExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCUnaryExpressionSymbol.class, OCUnaryExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCPrefixExpressionSymbol.class, OCPrefixExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCPostfixExpressionSymbol.class, OCPostfixExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCConditionalExpressionSymbol.class, OCConditionalExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCCallExpressionSymbol.class, OCCallExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCArrayIndexExpressionSymbol.class, OCArrayIndexExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCCastExpressionSymbol.class, OCCastExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCNewExpressionSymbol.class, OCNewExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCSizeofExpressionSymbol.class, OCSizeofExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCNoexceptExpressionSymbol.class, OCNoexceptExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCThrowExpressionSymbol.class, OCThrowExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCLiteralExpressionSymbol.class, OCLiteralExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCInitializerListExpressionSymbol.class, OCInitializerListExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCCommaExpressionSymbol.class, OCCommaExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCLambdaExpressionSymbol.class, OCLambdaExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCReferenceExpressionSymbol.class, OCReferenceExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCQualifiedExpressionSymbol.class, OCQualifiedExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCUnknownExpressionSymbol.class, OCUnknownExpressionSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCUndefMacroSymbol.class, OCUndefMacroSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCUsingSymbol.class, OCUsingSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCAliasUsingSymbol.class, OCAliasUsingSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCCompatibilityAliasSymbol.class, OCCompatibilityAliasSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCBlockExpressionImpl.OCBlockSymbol.class, OCBlockExpressionImpl.OCBlockSymbol::new);
        this.registerMaybeFileOwnerSerializer(OCThisSelfSuperSymbol.class, OCThisSelfSuperSymbol::new);
        this.registerElementTypeSerializer(OCPunctuatorElementType.class);
        this.registerElementTypeSerializer(OCElementType.class);
        this.registerElementTypeSerializer(OCKeywordElementType.class);
        this.registerFieldSerializer(SelectorPartSymbolImpl.class, SelectorPartSymbolImpl::new);
        this.registerSingletonSerializer((ObjectInstantiator<Object>)((ObjectInstantiator)() -> OCSymbolReference.SymbolFilter.NONE));
        myKryo.register(OCSymbolReference.SymbolKindFilter.class);
        this.registerGlobalReferenceSerializer(OCSymbolReference.GlobalReference.class, OCSymbolReference.GlobalReference::new);
        this.registerGlobalReferenceSerializer(OCSymbolReference.BaseClauseReference.class, OCSymbolReference.BaseClauseReference::new);
        this.registerGlobalReferenceSerializer(OCSymbolReference.TemplateArgumentsReference.class, OCSymbolReference.TemplateArgumentsReference::new);
        this.registerFieldSerializer(OCSymbolReference.LambdaLocalReference.class, OCSymbolReference.LambdaLocalReference::new);
        myKryo.register(OCSymbolReference.LocalReference.class, (Serializer)new NeverSerializer(myKryo, OCSymbolReference.LocalReference.class));
        myKryo.register(OCDeferredType.class, (Serializer)new NeverSerializer(myKryo, OCDeferredType.class));
        myKryo.register(PsiElement.class, (Serializer)new NeverSerializer(myKryo, PsiElement.class));
        this.registerFieldSerializer(OCExpressionTypeArgument.class, OCExpressionTypeArgument::new);
        this.registerFieldSerializer(OCCppReferenceType.class, OCCppReferenceType::new);
        this.registerSingletonSerializer((ObjectInstantiator<Object>)((ObjectInstantiator)() -> OCEllipsisType.instance()));
        this.registerFieldSerializer(OCFunctionType.class, OCFunctionType::new);
        this.registerSerializer(OCMagicType.class, new FieldSerializer<OCMagicType>(myKryo, OCMagicType.class){

            public void write(Kryo kryo, Output output, OCMagicType object) {
                FileSymbolTableSerializer.this.LOG.assertTrue(object != OCMagicType.SEVERAL_UNRELATED_STRUCTS, (Object)"Don't serialize SEVERAL_SUBSTITUTIONS");
                super.write(kryo, output, (Object)object);
            }
        }, OCMagicType::new);
        this.registerSingletonSerializer((ObjectInstantiator<Object>)((ObjectInstantiator)() -> OCUnknownType.INSTANCE));
        this.registerSingletonSerializer((ObjectInstantiator<Object>)((ObjectInstantiator)() -> OCBracedInitListType.INSTANCE));
        this.registerFieldSerializer(OCIntType.class, OCIntType::new);
        myKryo.register(CTypeId.class);
        this.registerFieldSerializer(OCRealType.class, OCRealType::new);
        this.registerFieldSerializer(OCObjectType.class, OCObjectType::new);
        this.registerFieldSerializer(OCIdType.class, OCIdType::new);
        this.registerSingletonSerializer((ObjectInstantiator<Object>)((ObjectInstantiator)() -> OCIdType.IDInterfaceSymbol.INSTANCE));
        this.registerFieldSerializer(OCPointerType.class, OCPointerType::new);
        this.registerFieldSerializer(OCPointerType.LengthOrNull.class, () -> new OCPointerType.LengthOrNull(null));
        this.registerFieldSerializer(OCBlockPointerType.class, OCBlockPointerType::new);
        this.registerFieldSerializer(OCReferenceType.class, OCReferenceType::new);
        this.registerFieldSerializer(OCStructType.class, OCStructType::new);
        myKryo.register(OCVoidType.class, (Serializer)new Serializer<OCVoidType>(){

            public void write(Kryo kryo, Output output, OCVoidType object) {
                output.writeBoolean(object.isConst());
                output.writeBoolean(object.isVolatile());
            }

            public OCVoidType read(Kryo kryo, Input input, Class<OCVoidType> type) {
                return OCVoidType.instance(input.readBoolean(), input.readBoolean());
            }
        });
        this.registerFieldSerializer(OCAutoType.class, OCAutoType::new);
        this.registerFieldSerializer(OCStructuredBindingType.class, OCStructuredBindingType::new);
        this.registerFieldSerializer(OCArrayType.class, OCArrayType::new);
        this.registerFieldSerializer(OCExpansionPackType.class, OCExpansionPackType::new);
        this.registerFieldSerializer(OCVariadicType.class, OCVariadicType::new);
        this.registerMaybeFileOwnerSerializer(OCVariadicPackExpressionSymbol.class, OCVariadicPackExpressionSymbol::new);
        this.registerSerializer(OCSimpleTypeSubstitution.class, new FieldSerializer<OCSimpleTypeSubstitution>(myKryo, OCSimpleTypeSubstitution.class){

            public OCSimpleTypeSubstitution read(Kryo kryo, Input input, Class<OCSimpleTypeSubstitution> type) {
                boolean isId = input.readBoolean();
                if (isId) {
                    return OCTypeSubstitution.ID;
                }
                return (OCSimpleTypeSubstitution)super.read(kryo, input, type);
            }

            public void write(Kryo kryo, Output output, OCSimpleTypeSubstitution object) {
                boolean isId = object == OCTypeSubstitution.ID;
                output.writeBoolean(isId);
                if (!isId) {
                    super.write(kryo, output, (Object)object);
                }
            }
        }, OCSimpleTypeSubstitution::new);
        myKryo.register(ARCAttribute.class);
        myKryo.register(OCSymbolKind.class);
        myKryo.register(OCCastKind.class);
        myKryo.register(OCExceptionSpecificationKind.class);
        myKryo.register(OCNullability.class);
        this.registerFieldSerializer(OCModuleImportSymbol.class, OCModuleImportSymbol::new);
        this.registerFieldSerializer(OCExceptionSpecificationInfo.class, OCExceptionSpecificationInfo::new);
        this.registerSerializer(OCIncludeSymbol.class, new MaybeFileOwnerSerializer<OCIncludeSymbol>(OCIncludeSymbol.class){

            @Override
            public void write(Kryo kryo, Output output, OCIncludeSymbol object) {
                String path;
                int id;
                super.write(kryo, output, object);
                VirtualFile targetFile = object.getTargetFile();
                if (targetFile != null && targetFile.isValid()) {
                    if (targetFile instanceof VirtualFileWithId) {
                        id = ((VirtualFileWithId)targetFile).getId();
                        path = targetFile.getPath();
                    } else {
                        id = -1;
                        path = CustomHeaderProvider.provideSerializationPathForFile(targetFile);
                        if (path == null) {
                            FileSymbolTableSerializer.this.LOG.error("only LocalVirtualFiles are supported: " + targetFile.getClass() + ": " + targetFile);
                        }
                    }
                } else {
                    id = -1;
                    path = null;
                }
                output.writeInt(id, true);
                output.writeString(path);
            }

            public OCIncludeSymbol read(Kryo kryo, Input input, Class<OCIncludeSymbol> type) {
                OCIncludeSymbol include = (OCIncludeSymbol)super.read(kryo, input, type);
                int fileId = input.readInt(true);
                String path = input.readString();
                VirtualFile targetFile = null;
                if (fileId != -1) {
                    targetFile = PersistentFS.getInstance().findFileById(fileId);
                }
                if (!(path == null || targetFile != null && FileUtil.pathsEqual((String)path, (String)targetFile.getPath()) || (targetFile = LocalFileSystem.getInstance().findFileByPath(path)) != null)) {
                    targetFile = CustomHeaderProvider.getCustomHeaderFile(path, FileSymbolTableSerializer.this.myProject, FileSymbolTableSerializer.this.myCurrentFile);
                }
                include.updateTargetFile(targetFile);
                return include;
            }
        }, OCIncludeSymbol::new);
        this.registerFieldSerializer(OCIncludeSymbol.IncludePath.class, OCIncludeSymbol.IncludePath::new);
        this.registerSingletonSerializer((ObjectInstantiator<Object>)((ObjectInstantiator)() -> OCIncludeSymbol.IncludePath.EMPTY));
        myKryo.register(EnumMap.class, (Serializer)new OCJavaSerializer());
        myKryo.register(OCPropertySymbol.FlagAttribute.class);
        myKryo.register(OCPropertySymbol.ValueAttribute.class);
        myKryo.register(OCVisibility.class);
        myKryo.register(ComplexTextRange.class, (Serializer)new Serializer<ComplexTextRange>(){

            public void write(Kryo kryo, Output output, ComplexTextRange object) {
                output.writeLong(object.getStartOffset(), true);
                output.writeLong(object.getEndOffset(), true);
            }

            public ComplexTextRange read(Kryo kryo, Input input, Class<ComplexTextRange> type) {
                long startOffset = input.readLong(true);
                long endOffset = input.readLong(true);
                return new ComplexTextRange(startOffset, endOffset);
            }
        });
        myKryo.register(OCNumber.class, (Serializer)new Serializer<OCNumber>(){

            public void write(Kryo kryo, Output output, OCNumber object) {
                output.writeByte(object.getSizeInBytes());
                output.writeBoolean(object.isSigned());
                byte[] bytes = object.toByteArray();
                output.writeByte(bytes.length);
                if (bytes.length > 0) {
                    output.write(bytes);
                }
            }

            public OCNumber read(Kryo kryo, Input input, Class<OCNumber> type) {
                byte sizeInBytes = input.readByte();
                boolean isSigned = input.readBoolean();
                byte length = input.readByte();
                byte[] bytes = new byte[length];
                input.readBytes(bytes);
                return new OCNumber(bytes, (int)sizeInBytes, isSigned);
            }
        });
        this.registerFieldSerializer(MetaData.class, MetaData::new);
        myKryo.register(OCGenericParameterSymbol.Covariance.class);
        this.registerMaybeFileOwnerSerializer(OCGenericParameterSymbolImpl.class, OCGenericParameterSymbolImpl::new);
        this.registerSerializer(OCImmutableList.class, new FieldSerializer<OCImmutableList>(myKryo, OCImmutableList.class){

            public void write(Kryo kryo, Output output, OCImmutableList l) {
                boolean hasElements = l.size() > 0;
                output.writeBoolean(hasElements);
                if (hasElements) {
                    super.write(kryo, output, (Object)l);
                }
            }

            public OCImmutableList read(Kryo kryo, Input input, Class<OCImmutableList> type) {
                boolean hasElements = input.readBoolean();
                return hasElements ? (OCImmutableList)((Object)super.read(kryo, input, type)) : OCImmutableList.emptyList();
            }
        }, () -> new OCImmutableList(Collections.emptyList()));
        this.registerCustomSerializers();
    }

    private <T extends OCSymbolReference.GlobalReference> void registerGlobalReferenceSerializer(Class<T> type, ObjectInstantiator<T> initializer) {
        this.registerSerializer(type, new FieldSerializer<T>(this.getKryo(), type){

            public T read(Kryo kryo, Input input, Class<T> type) {
                OCSymbolReference.GlobalReference object = (OCSymbolReference.GlobalReference)super.read(kryo, input, type);
                FileSymbolTableSerializer.readContextOrFileForGlobalReference(kryo, input, object, FileSymbolTableSerializer.this.myCurrentFile);
                return object;
            }

            public void write(Kryo kryo, Output output, T object) {
                super.write(kryo, output, object);
                FileSymbolTableSerializer.writeContextOrFileForGlobalReference(kryo, output, object);
            }
        }, initializer);
    }

    private static void writeContextOrFileForGlobalReference(Kryo kryo, Output output, OCSymbolReference.GlobalReference object) {
        Object fileOrContext = object.getVirtualFileOrSymbolContext();
        boolean storesVirtualFile = fileOrContext instanceof VirtualFile;
        output.writeBoolean(storesVirtualFile);
        if (!storesVirtualFile) {
            kryo.writeClassAndObject(output, fileOrContext);
        }
    }

    private static void readContextOrFileForGlobalReference(Kryo kryo, Input input, OCSymbolReference.GlobalReference object, VirtualFile file) {
        boolean storesVirtualFile = input.readBoolean();
        if (storesVirtualFile) {
            object.setVirtualFileOrSymbolContext(file);
        } else {
            Object symbol = kryo.readClassAndObject(input);
            if (symbol != null) {
                OCLog.LOG.assertTrue(symbol instanceof OCSymbolWithQualifiedName, (Object)("Wrong symbol in reference: " + symbol.getClass()));
            }
            object.setVirtualFileOrSymbolContext(symbol);
        }
    }

    private void registerCustomSerializers() {
        for (SerializerProvider provider2 : (SerializerProvider[])SerializerProvider.EP_NAME.getExtensions()) {
            provider2.registerSerializers(this);
        }
    }

    @Nullable
    public FileSymbolTablesPack readSymbolTables(@NotNull DataInputStream dis, @NotNull VirtualFile file) {
        this.myCurrentFile = file;
        return this.readObject(dis, FileSymbolTablesPack.class);
    }

    public void writeSymbolTables(@NotNull DataOutputStream dos, @NotNull FileSymbolTablesPack pack) {
        this.writeObject(dos, pack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <T> T readObject(@NotNull DataInputStream dis, Class<T> type) {
        FastInput input = new FastInput((InputStream)dis, 65536);
        try {
            Object object = this.getKryo().readObject((Input)input, type);
            return (T)object;
        }
        catch (Exception e) {
            this.LOG.error((Throwable)e);
            T t = null;
            return t;
        }
        finally {
            StreamUtil.closeStream((Closeable)input);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(DataOutputStream dos, Object object) {
        FastOutput output = new FastOutput((OutputStream)dos, 65536);
        try {
            this.getKryo().writeObject((Output)output, object);
            output.flush();
        }
        catch (Exception e) {
            this.LOG.error((Throwable)e);
        }
        finally {
            StreamUtil.closeStream((Closeable)output);
        }
    }

    @Nullable
    public MetaData readMetaData(@NotNull DataInputStream dis) {
        return this.readObject(dis, MetaData.class);
    }

    public void writeMetaData(@NotNull DataOutputStream dos, @NotNull MetaData metaData) {
        this.writeObject(dos, metaData);
    }

    public <T extends VirtualFileOwner> void registerFileOwnerSerializer(Class<T> type, ObjectInstantiator<T> instantiator) {
        this.registerSerializer(type, new FileOwnerSerializer<T>(type), instantiator);
    }

    public <T extends ProjectAndVirtualFileOwner> void registerProjectAndFileOwnerSerializer(Class<T> type, ObjectInstantiator<T> instantiator) {
        this.registerSerializer(type, new ProjectAndFileOwnerSerializer<T>(type), instantiator);
    }

    public <T extends MaybeVirtualFileOwner> void registerMaybeFileOwnerSerializer(Class<T> type, ObjectInstantiator<T> instantiator) {
        this.registerSerializer(type, new MaybeFileOwnerSerializer<T>(type), instantiator);
    }

    private <T extends OCElementType> void registerElementTypeSerializer(Class<T> type) {
        this.getKryo().register(type, (Serializer)ElementTypeSerializer.getInstance());
    }

    public static Map<String, OCElementType> getNameToElementTypeMap(TokenSet tokenSet) {
        HashMap<String, OCElementType> result = new HashMap<String, OCElementType>();
        for (IElementType type : tokenSet.getTypes()) {
            result.put(type.toString(), (OCElementType)type);
        }
        assert (result.size() == tokenSet.getTypes().length);
        return result;
    }

    static class ElementTypeSerializer<T extends OCElementType>
    extends Serializer<T> {
        private static final ElementTypeSerializer INSTANCE = new ElementTypeSerializer();

        ElementTypeSerializer() {
        }

        private static <T extends OCElementType> ElementTypeSerializer<T> getInstance() {
            return INSTANCE;
        }

        public void write(Kryo kryo, Output output, T elementType) {
            output.writeString(elementType.toString());
        }

        public T read(Kryo kryo, Input input, Class<T> type) {
            OCElementType elementType = OCTokenTypes.ourNameToTokenType.get(input.readString());
            return (T)((Object)((OCElementType)((Object)type.cast((Object)elementType))));
        }
    }

    public class MaybeFileOwnerSerializer<T extends MaybeVirtualFileOwner>
    extends FieldSerializer<T> {
        public MaybeFileOwnerSerializer(Class<T> symbolClass) {
            super(FileSymbolTableSerializer.this.getKryo(), symbolClass);
        }

        public void write(Kryo kryo, Output output, T object) {
            output.writeBoolean(object.getContainingFile() != null);
            super.write(kryo, output, object);
        }

        protected final T create(Kryo kryo, Input input, Class type) {
            boolean hasFile = input.readBoolean();
            T result = this.createInstance(kryo, input, type);
            result.init(hasFile ? FileSymbolTableSerializer.this.myCurrentFile : null);
            return result;
        }

        protected final T createCopy(Kryo kryo, T original) {
            MaybeVirtualFileOwner result = (MaybeVirtualFileOwner)super.createCopy(kryo, original);
            VirtualFile file = original.getContainingFile();
            FileSymbolTableSerializer.this.LOG.assertTrue(file == null || file.equals(FileSymbolTableSerializer.this.myCurrentFile));
            result.init(file);
            return (T)result;
        }

        public final T createInstance(Kryo kryo, Input input, Class type) {
            return (T)((MaybeVirtualFileOwner)super.create(kryo, input, type));
        }
    }

    public class ProjectAndFileOwnerSerializer<T extends ProjectAndVirtualFileOwner>
    extends FieldSerializer<T> {
        public ProjectAndFileOwnerSerializer(Class<T> symbolClass) {
            super(FileSymbolTableSerializer.this.getKryo(), symbolClass);
        }

        public void write(Kryo kryo, Output output, T object) {
            output.writeBoolean(object.getProject() != null);
            output.writeBoolean(object.getContainingFile() != null);
            super.write(kryo, output, object);
        }

        protected final T create(Kryo kryo, Input input, Class type) {
            boolean hasProject = input.readBoolean();
            boolean hasFile = input.readBoolean();
            T result = this.createInstance(kryo, input, type);
            result.init(hasProject ? FileSymbolTableSerializer.this.myProject : null, hasFile ? FileSymbolTableSerializer.this.myCurrentFile : null);
            return result;
        }

        protected final T createCopy(Kryo kryo, T original) {
            ProjectAndVirtualFileOwner result = (ProjectAndVirtualFileOwner)super.createCopy(kryo, original);
            VirtualFile file = original.getContainingFile();
            FileSymbolTableSerializer.this.LOG.assertTrue(file == null || file.equals(FileSymbolTableSerializer.this.myCurrentFile));
            result.init(original.getProject() != null ? FileSymbolTableSerializer.this.myProject : null, file);
            return (T)result;
        }

        public final T createInstance(Kryo kryo, Input input, Class type) {
            return (T)((ProjectAndVirtualFileOwner)super.create(kryo, input, type));
        }
    }

    public class FileOwnerSerializer<T extends VirtualFileOwner>
    extends FieldSerializer<T> {
        public FileOwnerSerializer(Class<T> symbolClass) {
            super(FileSymbolTableSerializer.this.getKryo(), symbolClass);
        }

        protected final T create(Kryo kryo, Input input, Class type) {
            T result = this.createInstance(kryo, input, type);
            result.init(FileSymbolTableSerializer.this.myCurrentFile);
            return result;
        }

        protected final T createCopy(Kryo kryo, T original) {
            VirtualFileOwner result = (VirtualFileOwner)super.createCopy(kryo, original);
            VirtualFile file = original.getContainingFile();
            FileSymbolTableSerializer.this.LOG.assertTrue(file.equals(FileSymbolTableSerializer.this.myCurrentFile));
            result.init(file);
            return (T)result;
        }

        public final T createInstance(Kryo kryo, Input input, Class type) {
            return (T)((VirtualFileOwner)super.create(kryo, input, type));
        }
    }
}

