/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableCacheListener;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

class FileSymbolTableUpdater {
    @NotNull
    private final Object myLock = new Object();
    @NotNull
    private final Project myProject;
    @NotNull
    private final UpdateQueue myRootQueue = new UpdateQueue();
    @NotNull
    private final UpdateQueue myIncludeQueue = new UpdateQueue();
    @NotNull
    private final AtomicBoolean myHugeUpdateRequested = new AtomicBoolean();
    @NotNull
    private final AtomicInteger myLastNotificationId = new AtomicInteger();
    @NotNull
    private final ThreadLocal<UpdateQueue> myParentQueue = new ThreadLocal();
    @NotNull
    private final CachedValue<Boolean> myQueueUpdater;

    FileSymbolTableUpdater(@NotNull Project project2) {
        this.myProject = project2;
        this.myQueueUpdater = CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
            OCWorkspaceModificationTrackers trackers = OCWorkspace.getInstance(project2).getModificationTrackers();
            return new CachedValueProvider.Result((Object)this.rebuildQueues(), new Object[]{trackers.getResolveConfigurationsTracker(), trackers.getSourceFilesTracker(), trackers.getCompilerSettingsTracker()});
        }, false);
    }

    public void ensurePendingFilesProcessed(boolean rootsOnly) {
        ProgressManager pm = ProgressManager.getInstance();
        ProgressIndicator ci = pm.getProgressIndicator();
        if (ci == null) {
            EmptyProgressIndicator ind = new EmptyProgressIndicator();
            pm.runProcess(() -> this.update(rootsOnly), (ProgressIndicator)ind);
        } else {
            this.update(rootsOnly);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(boolean rootsOnly) {
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        OCLog.LOG.assertTrue(indicator != null, (Object)"no progress indicator");
        UpdateQueue parentQueue = this.myParentQueue.get();
        if (parentQueue == this.myRootQueue) {
            throw new IllegalStateException("Nested updates are not allowed for root files.");
        }
        if (parentQueue != null && !rootsOnly) {
            throw new IllegalStateException("Nested update may not process included files.");
        }
        ProgressManager.checkCanceled();
        boolean isDispatchThread = ApplicationManager.getApplication().isDispatchThread();
        int updatedCount = 0;
        while (true) {
            VirtualFile file = null;
            UpdateQueue queue = null;
            Object object = this.myLock;
            synchronized (object) {
                while (file == null) {
                    ProgressManager.checkCanceled();
                    this.myQueueUpdater.getValue();
                    if (isDispatchThread && rootsOnly && this.tryHugeUpdate()) {
                        return;
                    }
                    if (!(this.myRootQueue.hasUnprocessedFiles() || !rootsOnly && this.myIncludeQueue.hasUnprocessedFiles())) {
                        if (!rootsOnly && updatedCount > 0) {
                            this.notifyOnUpToDate();
                        }
                        return;
                    }
                    file = this.myRootQueue.startProcessingNext();
                    queue = this.myRootQueue;
                    if (file == null && !rootsOnly) {
                        file = this.myIncludeQueue.startProcessingNext();
                        queue = this.myIncludeQueue;
                    }
                    if (file != null) continue;
                    try {
                        this.myLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            boolean ok = false;
            this.myParentQueue.set(queue);
            try {
                ProgressManager.checkCanceled();
                FileSymbolTableUpdater.updateTables(file, this.myProject, queue == this.myRootQueue);
                ok = true;
                ++updatedCount;
                continue;
            }
            finally {
                this.myParentQueue.set(parentQueue);
                Object object2 = this.myLock;
                synchronized (object2) {
                    queue.finishProcessing(file, ok);
                    this.myLock.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    private void notifyInvalidated() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ((FileSymbolTableCacheListener)this.myProject.getMessageBus().syncPublisher(FileSymbolTableCacheListener.TOPIC)).onSymbolsInvalidated();
    }

    private void notifyOnUpToDate() {
        int notificationId = this.myLastNotificationId.incrementAndGet();
        Runnable n = () -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myLastNotificationId.get() == notificationId && !this.myProject.isDisposed() && FileSymbolTablesCache.areSymbolsLoaded(this.myProject) && this.isUpToDate()) {
                    ((FileSymbolTableCacheListener)this.myProject.getMessageBus().syncPublisher(FileSymbolTableCacheListener.TOPIC)).onSymbolsUpToDate();
                }
            }
        };
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            n.run();
        } else {
            app.invokeLater(n);
        }
    }

    public boolean isUpToDate() {
        return this.isUpToDate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpToDate(boolean rootsOnly) {
        Object object = this.myLock;
        synchronized (object) {
            return !this.myRootQueue.hasUnprocessedFiles() && (rootsOnly || !this.myIncludeQueue.hasUnprocessedFiles());
        }
    }

    private boolean rebuildQueues() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myRootQueue.size() + this.myIncludeQueue.size());
        files.addAll(this.myRootQueue.removeAllFilesToUpdate());
        files.addAll(this.myIncludeQueue.removeAllFilesToUpdate());
        for (VirtualFile file : files) {
            this.addFileInner(file);
        }
        return true;
    }

    private static void updateTables(@NotNull VirtualFile file, @NotNull Project project2, boolean isRoot) {
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project2);
        if (!isRoot && cache.allTablesForFileCount(file) > 0) {
            return;
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        for (OCResolveConfiguration config : OCInclusionContextUtil.getAllBuildConfigurationsForIndexing(file, project2)) {
            OCImportGraph.buildSymbolAndRootHeaderCache(config, file, !isRoot, pi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileForUpdate(@NotNull VirtualFile file) {
        Object object = this.myLock;
        synchronized (object) {
            boolean wasUpToDate = this.isUpToDate();
            this.addFileInner(file);
            if (wasUpToDate && !this.isUpToDate()) {
                this.notifyInvalidated();
            }
            this.myLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilesForUpdate(Collection<VirtualFile> files, boolean clearCaches) {
        Object object = this.myLock;
        synchronized (object) {
            if (clearCaches) {
                FileSymbolTablesCache.getInstance(this.myProject).removeFilesFromCache(files);
            }
            boolean wasUpToDate = this.isUpToDate();
            for (VirtualFile file : files) {
                this.addFileInner(file);
            }
            if (wasUpToDate && !this.isUpToDate()) {
                this.notifyInvalidated();
            }
            this.myLock.notifyAll();
        }
    }

    private void addFileInner(@NotNull VirtualFile file) {
        if (!file.isValid()) {
            return;
        }
        if (this.isInclude(file)) {
            this.myIncludeQueue.add(file);
        } else {
            this.myRootQueue.add(file);
        }
    }

    private boolean isInclude(@NotNull VirtualFile file) {
        return OCInclusionContextUtil.isNeedToFindRoot(file, this.myProject);
    }

    private boolean tryHugeUpdate() {
        int fileScore = this.myRootQueue.filesToUpdateSize();
        if (fileScore < 20) {
            return false;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myRootQueue.removeAllFilesToUpdate());
        this.myHugeUpdateRequested.set(false);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myHugeUpdateRequested.getAndSet(true)) {
                return;
            }
            OCSymbolTablesBuildingActivity.getInstance(this.myProject).buildSymbolsForFiles(files);
        }, ModalityState.NON_MODAL);
        return true;
    }

    private static class UpdateQueue {
        private final Set<VirtualFile> myFilesToUpdate = new THashSet();
        private int myFilesInProgressCount;

        private UpdateQueue() {
        }

        public void add(VirtualFile file) {
            this.myFilesToUpdate.add(file);
        }

        public VirtualFile startProcessingNext() {
            Iterator<VirtualFile> it = this.myFilesToUpdate.iterator();
            while (it.hasNext()) {
                VirtualFile file = it.next();
                it.remove();
                if (!file.isValid()) continue;
                ++this.myFilesInProgressCount;
                return file;
            }
            return null;
        }

        public boolean hasUnprocessedFiles() {
            return this.myFilesToUpdate.size() > 0 || this.myFilesInProgressCount > 0;
        }

        public void finishProcessing(VirtualFile file, boolean isProcessed) {
            --this.myFilesInProgressCount;
            if (!isProcessed) {
                this.myFilesToUpdate.add(file);
            }
        }

        public int filesToUpdateSize() {
            return this.myFilesToUpdate.size();
        }

        public Collection<VirtualFile> removeAllFilesToUpdate() {
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.myFilesToUpdate.size());
            Iterator<VirtualFile> it = this.myFilesToUpdate.iterator();
            while (it.hasNext()) {
                VirtualFile file = it.next();
                if (file.isValid()) {
                    result.add(file);
                }
                it.remove();
            }
            return result;
        }

        public int size() {
            return this.myFilesToUpdate.size();
        }
    }
}

