/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Alarm;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.VirtualFileChangeListener;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.DirtyIncludesInvalidator;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.SerializationService;
import com.jetbrains.cidr.lang.symbols.symtable.SerializationSession;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTablesCache
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(FileSymbolTablesCache.class);
    private static final boolean USE_PSI_FOR_INVALIDATION = Registry.is((String)"cidr.indexer.invalidateUsingPsi", (boolean)false);
    private static volatile Boolean ourForceSymbolsLoadedInTests = null;
    private static final SymbolsProperties DEFAULT_SYMBOLS_PROPERTIES;
    private static volatile SymbolsProperties ourSymbolsProperties;
    private final ConcurrentMap<VirtualFile, FileSymbolTablesPack> myCache = ContainerUtil.newConcurrentMap();
    private final FileSymbolTableUpdater myTableUpdater;
    private final Project myProject;
    private final Set<VirtualFile> myPendingReparses = new THashSet();
    private final Set<VirtualFile> myPendingPSIResets = new THashSet();
    private final Object mySerializationLock = new Object();
    private final PeriodicSerializationTask mySerializationTask = new PeriodicSerializationTask();
    private final SimpleModificationTracker myOutOfBlockModificationTracker;
    private final SimpleModificationTracker myOCOutOfBlockModificationTracker = new SimpleModificationTracker();
    private final AtomicBoolean mySymbolsLoaded = new AtomicBoolean(false);
    private final Object myFileAndContextDependencyLock = new Object();
    private final Map<Thread, VirtualFile> myContextToAwaitingFile = new THashMap();
    private final Map<VirtualFile, Thread> myFileToProcessingContext = new THashMap();
    private final SerializationService mySerializationService;

    @NotNull
    public static FileSymbolTablesCache getInstance(@NotNull Project project2) {
        return (FileSymbolTablesCache)project2.getComponent(FileSymbolTablesCache.class);
    }

    public FileSymbolTablesCache(@NotNull Project project2, @NotNull MessageBus bus, @NotNull PsiManager psiManager, @NotNull SerializationService serializationService) {
        this.myTableUpdater = new FileSymbolTableUpdater(project2);
        this.myProject = project2;
        final PsiModificationTrackerImpl psiTracker = (PsiModificationTrackerImpl)psiManager.getModificationTracker();
        this.myOutOfBlockModificationTracker = new SimpleModificationTracker(){

            public void incModificationCount() {
                super.incModificationCount();
                psiTracker.incOutOfCodeBlockModificationCounter();
            }
        };
        if (psiManager instanceof PsiManagerImpl) {
            ((PsiManagerImpl)psiManager).addTreeChangePreprocessor((PsiTreeChangePreprocessor)new OCCodeBlockModificationListener());
        }
        MessageBusConnection connection = bus.connect();
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

            @Override
            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
                if (event.resolveConfigurationsChanged() || event.compilerSettingsChanged()) {
                    OCSymbolTablesBuildingActivity.getInstance(FileSymbolTablesCache.this.myProject).rebuildSymbols();
                }
                FileSymbolTablesCache.this.incOCOutOfCodeBlockTracker();
                FileSymbolTablesCache.this.myOutOfBlockModificationTracker.incModificationCount();
            }

            @Override
            public void selectedResolveConfigurationChanged() {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
                FileSymbolTablesCache.this.scheduleReparseCachedPsiFiles();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new VirtualFileChangeListener(true){
            private ClearTablesAndCollectNamesVisitor visitor;

            @Override
            protected void begin() {
                this.visitor = new ClearTablesAndCollectNamesVisitor();
            }

            @Override
            protected void onFileChange(@NotNull VirtualFile file) {
                if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)FileSymbolTablesCache.this.myProject, (Object)true)).booleanValue()) {
                    return;
                }
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)this.visitor);
            }

            @Override
            protected void done() {
                if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)FileSymbolTablesCache.this.myProject, (Object)true)).booleanValue()) {
                    return;
                }
                Set<String> toInvalidate = this.visitor.dirtyNames;
                this.visitor = null;
                if (!toInvalidate.isEmpty()) {
                    FileSymbolTablesCache.this.invalidateDirtyIncludes(toInvalidate);
                    FileSymbolTablesCache.this.myOutOfBlockModificationTracker.incModificationCount();
                }
            }
        });
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> OCSymbolTablesBuildingActivity.getInstance(project2).rebuildSymbols());
        }
        this.mySerializationService = serializationService;
    }

    @NotNull
    public ModificationTracker getOutOfBlockModificationTracker() {
        return this.myOutOfBlockModificationTracker;
    }

    @NotNull
    public ModificationTracker getOCOutOfBlockModificationTracker() {
        return this.myOCOutOfBlockModificationTracker;
    }

    public void incOCOutOfCodeBlockTracker() {
        this.myOCOutOfBlockModificationTracker.incModificationCount();
    }

    public void projectOpened() {
        if (!this.myProject.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.mySerializationTask.schedule(20000);
        }
    }

    public void projectClosed() {
        this.mySerializationTask.cancelAll();
    }

    public static synchronized boolean shouldBuildTables() {
        return ourSymbolsProperties == null || ourSymbolsProperties.buildSymbolsKind != SymbolsProperties.SymbolsKind.NO_SYMBOLS;
    }

    public static synchronized boolean shouldBuildTablesForAllSystemHeaders() {
        return ourSymbolsProperties == null || ourSymbolsProperties.buildSymbolsKind == SymbolsProperties.SymbolsKind.ALL_INCLUDING_UNUSED_SYSTEM_HEADERS;
    }

    private static synchronized boolean isSerializationEnabled() {
        return ourSymbolsProperties == null || ourSymbolsProperties.serializeSymbolTables;
    }

    private static synchronized boolean isDeserializationEnabled() {
        return ourSymbolsProperties == null || ourSymbolsProperties.deserializeSymbolTables;
    }

    @Nullable
    public static synchronized SymbolsProperties setShouldBuildTablesInTests(@Nullable SymbolsProperties properties) {
        SymbolsProperties prev = ourSymbolsProperties;
        ourSymbolsProperties = properties != null ? properties : DEFAULT_SYMBOLS_PROPERTIES;
        return prev;
    }

    public void invalidateDirtyIncludes(Set<String> dirtyNames) {
        this.invalidateDirtyIncludes(dirtyNames, false);
    }

    public void invalidateDirtyIncludes(@NotNull Set<String> dirtyNames, boolean isRelativePath) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Set<VirtualFile> allCachedFiles = this.getCachedFiles();
        ImmutableList.Builder cachedFilesBuilder = ImmutableList.builderWithExpectedSize((int)allCachedFiles.size());
        for (VirtualFile cachedFile : allCachedFiles) {
            if (!cachedFile.isValid()) continue;
            cachedFilesBuilder.add((Object)cachedFile);
        }
        ImmutableList cachedFiles = cachedFilesBuilder.build();
        DirtyIncludesInvalidator invalidator = new DirtyIncludesInvalidator(this, dirtyNames, isRelativePath, cachedFiles.size());
        Collection<VirtualFile> pendingInvalidation = invalidator.collect((ImmutableList<VirtualFile>)cachedFiles);
        this.invalidateDirtyIncludeFiles(pendingInvalidation);
        for (SymbolTableProvider provider2 : (THashSet)CollectionsKt.mapNotNullTo(pendingInvalidation, (Collection)ContainerUtil.newTroveSet(), SymbolTableProvider::findProvider)) {
            provider2.onOutOfCodeBlockModification(this.myProject, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateDirtyIncludeFiles(@NotNull Collection<VirtualFile> dirtyFiles) {
        if (!dirtyFiles.isEmpty()) {
            THashSet invalidatedFiles = ContainerUtil.newTroveSet();
            for (VirtualFile file : dirtyFiles) {
                this.invalidate(file, true, (Set<VirtualFile>)invalidatedFiles, true);
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    this.myPendingReparses.add(file);
                }
            }
            OCImportGraph.invalidateHeaderRootsCache(this.myProject);
            OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, this.myProject);
        }
        this.schedulePSIUpdates();
    }

    public void compact() {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.compactSynchronized();
        }
    }

    @NotNull
    public Set<VirtualFile> getFilesToBuildTablesFor() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> allSourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
        Set result = (Set)CollectionsKt.filterTo(allSourceFiles, (Collection)ContainerUtil.newLinkedHashSet(), SymbolTableProvider::isSourceFile);
        if (FileSymbolTablesCache.shouldBuildTablesForAllSystemHeaders()) {
            result.addAll(OCInclusionContextUtil.getHeaderFilesToBuildSymbols(this.myProject));
        }
        return result;
    }

    public Set<VirtualFile> getCachedFiles() {
        return this.myCache.keySet();
    }

    public void addFileToCache(@Nullable VirtualFile file) {
        if (file == null) {
            return;
        }
        this.myTableUpdater.addFileForUpdate(file);
    }

    public void addFilesToCache(@NotNull Collection<VirtualFile> files) {
        this.myTableUpdater.addFilesForUpdate(files, false);
    }

    public void removeFilesFromCache(@NotNull Iterable<VirtualFile> files) {
        for (VirtualFile each : files) {
            this.clearCache(each);
        }
    }

    public void removeAllChildrenFromCache(@Nullable VirtualFile root) {
        if (root == null) {
            return;
        }
        for (VirtualFile file : this.myCache.keySet()) {
            if (file == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            this.clearCache(file);
        }
    }

    @Nullable
    @Contract(value="null -> null")
    private static VirtualFile key(@Nullable PsiFile file) {
        return OCInclusionContextUtil.getVirtualFile(file);
    }

    public FileSymbolTable calcTableUsingPSI(@NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        return SymbolTableProvider.getProvider(file).calcTableUsingPSI(file, virtualFile, context);
    }

    @Nullable
    FileSymbolTable forFile(@NotNull PsiFile file, @NotNull OCInclusionContext context) {
        return this.forFile(file, context, null);
    }

    @Nullable
    FileSymbolTable forFile(@NotNull PsiFile file, @NotNull OCInclusionContext context, @Nullable SerializationSession serializationSession) {
        VirtualFile virtualFile = FileSymbolTablesCache.key(file);
        if (virtualFile == null) {
            return null;
        }
        return this.forFile(virtualFile, context, serializationSession);
    }

    @Nullable
    public FileSymbolTable forFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        return this.forFile(virtualFile, context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public FileSymbolTable forFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context, @Nullable SerializationSession serializationSession) {
        boolean deadlock;
        Ref outTimeStamp;
        ProgressManager.checkCanceled();
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("deadlock may occur if 'FileSymbolTablesCache.forFile' is called outside of read-action");
        }
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return null;
        }
        if (!virtualFile.isValid()) {
            return null;
        }
        FileSymbolTablesPack pack = this.packForFile(virtualFile, serializationSession);
        FileSymbolTable table = pack.findConformingTable(context, 0, (Ref<Integer>)(outTimeStamp = new Ref()));
        if (table != null) {
            return table;
        }
        int checkedPackTimeStamp = (Integer)outTimeStamp.get();
        if (context.getInclusionLevel() >= OCInclusionContext.getMaxInclusionLevel(this.myProject)) {
            return null;
        }
        Thread currentThread = Thread.currentThread();
        Object object = this.myFileAndContextDependencyLock;
        synchronized (object) {
            this.myContextToAwaitingFile.put(currentThread, virtualFile);
            deadlock = this.checkForDeadlock(currentThread);
            if (deadlock) {
                this.myContextToAwaitingFile.remove(currentThread);
            }
        }
        if (deadlock) {
            return SymbolTableProvider.getProvider(virtualFile).calcTable(virtualFile, context);
        }
        object = pack;
        synchronized (object) {
            boolean alreadyInProcessingStack;
            Object currentlyProcessedBy;
            Object object2 = this.myFileAndContextDependencyLock;
            synchronized (object2) {
                this.myContextToAwaitingFile.remove(currentThread);
                currentlyProcessedBy = this.myFileToProcessingContext.get(virtualFile);
                if (currentlyProcessedBy != null && currentlyProcessedBy != currentThread) {
                    LOG.error("File is processed by another thread, deadlock detection failed! " + virtualFile.getName());
                }
                boolean bl = alreadyInProcessingStack = currentlyProcessedBy != null;
                if (!alreadyInProcessingStack) {
                    this.myFileToProcessingContext.put(virtualFile, currentThread);
                }
            }
            ProgressManager.checkCanceled();
            FileSymbolTable t = pack.findConformingTable(context, checkedPackTimeStamp, null);
            if (t != null) {
                currentlyProcessedBy = t;
                return currentlyProcessedBy;
            }
            OCSymbolTablesBuildingActivity.getInstance(this.myProject).assertParsingAndSymbolBuildingAllowed(currentThread);
            FileSymbolTable answer = SymbolTableProvider.getProvider(virtualFile).calcTable(virtualFile, context);
            context.addProcessedFile(virtualFile);
            pack.addCompactSynchronized(this.myProject, answer);
            FileSymbolTable fileSymbolTable = answer;
            return fileSymbolTable;
            finally {
                if (!alreadyInProcessingStack) {
                    Object object3 = this.myFileAndContextDependencyLock;
                    synchronized (object3) {
                        this.myFileToProcessingContext.remove(virtualFile);
                    }
                }
            }
        }
    }

    @Nullable
    public FileSymbolTable findForFile(@NotNull VirtualFile file, @NotNull OCInclusionContext context) {
        FileSymbolTablesPack pack = this.packForFile(file);
        return pack.findConformingTable(context, 0, null);
    }

    private boolean checkForDeadlock(@NotNull Thread context) {
        Thread thread = context;
        while (thread != null) {
            VirtualFile lock = this.myContextToAwaitingFile.get(thread);
            if (lock == null) {
                return false;
            }
            Thread next = this.myFileToProcessingContext.get(lock);
            if (next == thread) {
                return false;
            }
            if (next == context) {
                return true;
            }
            thread = next;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleReparseFile(OCFile file) {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            VirtualFile key = FileSymbolTablesCache.key(file);
            if (key != null) {
                this.myPendingReparses.add(key);
            }
        }
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachedFilesToReparse() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            for (PsiFile file : PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager().getAllCachedFiles()) {
                VirtualFile key = FileSymbolTablesCache.key(file);
                if (key == null) continue;
                this.myPendingReparses.add(key);
            }
        }
    }

    private void scheduleReparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePSIUpdates() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            if (!this.myPendingPSIResets.isEmpty() || !this.myPendingReparses.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> this.updateDirtyFilesPSI(), ModalityState.NON_MODAL);
            }
        }
    }

    public void reparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.updateDirtyFilesPSI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDirtyFilesPSI() {
        ArrayList<VirtualFile> toResetPSI;
        if (this.myProject.isDisposed()) {
            return;
        }
        ArrayList<VirtualFile> toReparse = new ArrayList<VirtualFile>();
        FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager();
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            this.myPendingPSIResets.removeAll(this.myPendingReparses);
            toResetPSI = new ArrayList<VirtualFile>(this.myPendingPSIResets);
            this.myPendingPSIResets.clear();
            for (VirtualFile virtualFile : this.myPendingReparses) {
                PsiFile file;
                if (!virtualFile.isValid()) continue;
                FileViewProvider pp = fileManager.findCachedViewProvider(virtualFile);
                PsiFile psiFile = file = pp == null ? null : fileManager.findFile(virtualFile);
                if (file == null) continue;
                FileSymbolTablesCache.processDirtyFile(toReparse, file, virtualFile);
            }
            this.myPendingReparses.clear();
        }
        if (!toResetPSI.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (VirtualFile file : toResetPSI) {
                    fileManager.setViewProvider(file, null);
                }
            });
        }
        if (!toReparse.isEmpty()) {
            FileContentUtilCore.reparseFiles(toReparse);
        }
        if (!toResetPSI.isEmpty() || !toReparse.isEmpty()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    private static void processDirtyFile(@NotNull List<VirtualFile> dirty, @NotNull PsiFile file, @NotNull VirtualFile virtualFile) {
        if (SymbolTableProvider.isSourceFile(virtualFile) && file instanceof PsiFileImpl) {
            FileElement node = ((PsiFileImpl)file).getTreeElement();
            if (node != null && node.isParsed()) {
                dirty.add(virtualFile);
            } else {
                file.clearCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate(@Nullable VirtualFile file, boolean reparse, Set<VirtualFile> processed, boolean withIncludingFiles) {
        if (file == null || !processed.add(file)) {
            return;
        }
        this.clearCache(file);
        if (file.isValid() && SymbolTableProvider.isSourceFile(file)) {
            this.myTableUpdater.addFileForUpdate(file);
        }
        if (withIncludingFiles) {
            Collection<OCResolveConfiguration> configs;
            Set<VirtualFile> dirtySet = reparse ? this.myPendingReparses : this.myPendingPSIResets;
            OCWorkspace workspace = OCWorkspace.getInstance(this.myProject);
            if (!OCInclusionContextUtil.isNeedToFindRoot(file, this.myProject)) {
                for (OCResolveConfiguration config : workspace.getConfigurations()) {
                    OCImportGraph.invalidateRootHeadersCache(config, file);
                }
            }
            if (!(configs = OCInclusionContext.getBuildConfigurationByPchFile(file, this.myProject)).isEmpty()) {
                Runnable runnable = () -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    for (OCResolveConfiguration config : configs) {
                        OCInclusionContext.onPrecompiledContextChange(config);
                    }
                    Collection<VirtualFile> sourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
                    this.myTableUpdater.addFilesForUpdate(sourceFiles, true);
                    Set<VirtualFile> set = this.myPendingReparses;
                    synchronized (set) {
                        dirtySet.addAll(sourceFiles);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    runnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
                }
            }
            THashSet includingFiles = new THashSet();
            if (USE_PSI_FOR_INVALIDATION) {
                PsiFile psiFile = OCInclusionContextUtil.findCachedPsiFile(file, this.myProject);
                if (psiFile instanceof OCFile) {
                    Collection<VirtualFile> includingFromPsi = ((OCFile)psiFile).resetIncludingFiles();
                    includingFiles.addAll(includingFromPsi);
                }
            } else {
                Collection<VirtualFile> immediateIncludingFiles = OCImportGraph.findImmediateIncludingFiles(this.myProject, file, false);
                includingFiles.addAll(immediateIncludingFiles);
            }
            for (VirtualFile including : includingFiles) {
                this.invalidate(including, reparse, processed, true);
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    dirtySet.add(including);
                }
            }
        }
    }

    public void ensurePendingFilesProcessed() {
        this.ensurePendingFilesProcessed(false);
    }

    public void ensurePendingFilesProcessed(boolean rootsOnly) {
        this.myTableUpdater.ensurePendingFilesProcessed(rootsOnly);
    }

    @NotNull
    public List<FileSymbolTable> allTablesForFile(OCFile file) {
        VirtualFile virtualFile = FileSymbolTablesCache.key(file);
        if (virtualFile == null) {
            return Collections.emptyList();
        }
        return this.packForFile(virtualFile).getTablesSynchronized();
    }

    @NotNull
    public List<FileSymbolTable> allTablesForFile(@NotNull VirtualFile virtualFile) {
        return this.packForFile(virtualFile).getTablesSynchronized();
    }

    public int allTablesForFileCount(@NotNull VirtualFile virtualFile) {
        return this.packForFile(virtualFile).getTablesCountSynchronized();
    }

    @NotNull
    private FileSymbolTablesPack packForFile(@NotNull VirtualFile virtualFile) {
        return this.packForFile(virtualFile, null);
    }

    @NotNull
    private FileSymbolTablesPack packForFile(@NotNull VirtualFile virtualFile, @Nullable SerializationSession serializationSession) {
        FileSymbolTablesPack newPack;
        FileSymbolTablesPack prev;
        FileSymbolTablesPack pack = (FileSymbolTablesPack)this.myCache.get(virtualFile);
        if (pack != null) {
            return pack;
        }
        FileSymbolTablesPack deserializedPack = null;
        if (serializationSession != null && FileSymbolTablesCache.isDeserializationEnabled() && virtualFile instanceof VirtualFileWithId) {
            deserializedPack = SerializationService.getService().deserializeTables(this.myProject, serializationSession, virtualFile);
        }
        if ((prev = this.myCache.putIfAbsent(virtualFile, newPack = deserializedPack != null ? deserializedPack : new FileSymbolTablesPack())) != null) {
            return prev;
        }
        if (deserializedPack != null) {
            deserializedPack.onThaw(this.myProject);
        }
        return newPack;
    }

    public void clearAllTables() {
        ArrayList packs = new ArrayList(this.myCache.values());
        this.myCache.clear();
        for (FileSymbolTablesPack pack : packs) {
            pack.onRemove(this.myProject);
        }
    }

    private boolean clearCache(@NotNull VirtualFile file) {
        FileSymbolTablesPack pack = (FileSymbolTablesPack)this.myCache.remove(file);
        if (pack != null) {
            pack.onRemove(this.myProject);
        }
        return pack != null;
    }

    private int fillCache(Map<VirtualFile, FileSymbolTablesPack> packs) {
        for (FileSymbolTablesPack pack : packs.values()) {
            pack.onThaw(this.myProject);
        }
        this.myCache.putAll(packs);
        return packs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> files, @NotNull ProgressIndicator indicator) {
        Object object = this.mySerializationLock;
        synchronized (object) {
            if (!FileSymbolTablesCache.isSerializationEnabled()) {
                return;
            }
            HashMap tables = ContainerUtil.newHashMap();
            for (VirtualFile file : files) {
                tables.put(file, this.packForFile(file));
            }
            this.mySerializationService.serializeTables(this.myProject, projectLocationHash, tables, indicator);
        }
    }

    public static boolean areSymbolsLoaded(@NotNull Project project2) {
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        FileSymbolTablesCache instance2 = (FileSymbolTablesCache)project2.getComponent(FileSymbolTablesCache.class);
        return instance2 == null || !FileSymbolTablesCache.shouldBuildTables() || instance2.mySymbolsLoaded.get();
    }

    public boolean areSymbolsLoaded() {
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        return !FileSymbolTablesCache.shouldBuildTables() || this.mySymbolsLoaded.get();
    }

    public boolean isUpToDate() {
        return this.isUpToDate(false);
    }

    public boolean isUpToDate(boolean rootsOnly) {
        return FileSymbolTablesCache.areSymbolsLoaded(this.myProject) && this.myTableUpdater.isUpToDate(rootsOnly);
    }

    public static int getIndexingThreadCount() {
        return FileSymbolTablesCache.getIndexingThreadCount(Registry.intValue((String)"cidr.indexer.thread.count"));
    }

    static int getIndexingThreadCount(int userValue) {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        if (userValue <= 0) {
            userValue = cpuCount + userValue;
        }
        return Math.min(cpuCount, Math.max(1, userValue));
    }

    public static void forceSymbolsLoadedInTests(@Nullable Boolean force) {
        ourForceSymbolsLoadedInTests = force;
    }

    public static Boolean getForceSymbolsLoadedInTests() {
        return ourForceSymbolsLoadedInTests;
    }

    void notifySymbolsLoaded() {
        this.mySymbolsLoaded.getAndSet(true);
    }

    void notifySymbolsUnloaded() {
        this.mySymbolsLoaded.getAndSet(false);
    }

    public Project getProject() {
        return this.myProject;
    }

    public void removeJunkTables(boolean includingUnused) {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.removeJunkTables(this.myProject, includingUnused);
        }
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithChangedTables() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            if (!((FileSymbolTablesPack)entry.getValue()).isChanged()) continue;
            result.add((VirtualFile)entry.getKey());
        }
        return result;
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithNonFallbackTables(boolean withUsedTablesOnly) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            if (pack.isFallback() || withUsedTablesOnly && !pack.hasUsedTables()) continue;
            result.add((VirtualFile)entry.getKey());
        }
        return result;
    }

    public long deserializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        if (!FileSymbolTablesCache.isDeserializationEnabled()) {
            return 0L;
        }
        Map<VirtualFile, FileSymbolTablesPack> packs = this.mySerializationService.deserializeTables(this.myProject, projectLocationHash, filesToLoad, indicator, indicatorScale);
        return this.fillCache(packs);
    }

    public void deserializeTables(@NotNull SerializationSession session, @NotNull VirtualFile file) {
        if (!FileSymbolTablesCache.isDeserializationEnabled()) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myCache.get(file) != null) {
            return;
        }
        FileSymbolTablesPack pack = this.mySerializationService.deserializeTables(this.myProject, session, file);
        if (pack != null && this.myCache.putIfAbsent(file, pack) == null) {
            pack.onThaw(this.myProject);
        }
    }

    public void handleOutOfCodeBlockChange(@NotNull PsiFile file, boolean hasMacro) {
        if (SymbolTableProvider.isSourceFile(file)) {
            this.incOutOfCodeBlockTrackers(file);
            this.invalidate(FileSymbolTablesCache.key(file), false, (Set<VirtualFile>)new THashSet(), hasMacro);
            this.schedulePSIUpdates();
            OCInclusionContextUtil.invalidateHeaderContextsExcept(OCInclusionContextUtil.getVirtualFile(file), file.getProject());
        }
        if (hasMacro) {
            OCImportGraph.invalidateHeaderRootsCache(file.getProject());
            OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(OCInclusionContextUtil.getVirtualFile(file), file.getProject());
        }
    }

    private void incOutOfCodeBlockTrackers(@NotNull PsiFile file) {
        this.myOutOfBlockModificationTracker.incModificationCount();
        SymbolTableProvider.fireOutOfCodeBlockModification(file);
    }

    public void dumpStats() {
        ArrayList list = new ArrayList(this.myCache.entrySet());
        Collections.sort(list, (o1, o2) -> {
            int c = Comparing.compare((int)((FileSymbolTablesPack)o1.getValue()).getTablesCountSynchronized(), (int)((FileSymbolTablesPack)o2.getValue()).getTablesCountSynchronized());
            if (c != 0) {
                return c;
            }
            List<FileSymbolTable> ts1 = ((FileSymbolTablesPack)o1.getValue()).tablesView();
            List<FileSymbolTable> ts2 = ((FileSymbolTablesPack)o2.getValue()).tablesView();
            if (ts1.size() > 0 && ts2.size() > 0) {
                VirtualFile f1 = ts1.get(0).getContainingFile();
                VirtualFile f2 = ts2.get(0).getContainingFile();
                int fc = Comparing.compare((Comparable)((Object)f1.getName()), (Comparable)((Object)f2.getName()));
                if (fc != 0) {
                    return fc;
                }
                return Comparing.compare((Comparable)((Object)f1.getPath()), (Comparable)((Object)f2.getPath()));
            }
            return Comparing.compare((int)ts1.size(), (int)ts2.size());
        });
        int totalFiles = 0;
        int multiTableFiles = 0;
        int totalSymbols = 0;
        int totalUniqueSymbols = 0;
        int totalContents = 0;
        int totalUniqueContents = 0;
        int totalUniqueContentsLen = 0;
        for (Map.Entry entry : list) {
            ++totalFiles;
            VirtualFile file = (VirtualFile)entry.getKey();
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            List<FileSymbolTable> tables = pack.getTablesSynchronized();
            if (tables.size() <= 1) continue;
            ++multiTableFiles;
            Function tablePrinter = table -> Integer.toString(table.getUsageCount());
            int symbolCount = 0;
            int contentsCount = 0;
            THashSet uniqueSymbols = new THashSet(TObjectHashingStrategy.IDENTITY);
            THashSet uniqueContents = new THashSet();
            int uniqueContentsLength = 0;
            for (FileSymbolTable table2 : tables) {
                List<OCSymbol> contents = table2.getContents();
                symbolCount += contents.size();
                uniqueSymbols.addAll(contents);
                ++contentsCount;
                if (!uniqueContents.add(contents)) continue;
                uniqueContentsLength += contents.size();
            }
            totalSymbols += symbolCount;
            totalUniqueSymbols += uniqueSymbols.size();
            totalContents += contentsCount;
            totalUniqueContents += uniqueContents.size();
            totalUniqueContentsLen += uniqueContentsLength;
            double reuseFactor = (double)uniqueSymbols.size() / (double)symbolCount;
            if (reuseFactor == 0.5) {
                int br_1371 = 0;
                ++br_1371;
            }
            if (reuseFactor < 0.005) {
                int br_1379 = 0;
                ++br_1379;
            }
            String num = String.format("%5d", totalFiles + 1);
            String contentsReuseInfo = "";
            if (uniqueContents.size() != contentsCount) {
                contentsReuseInfo = ", " + uniqueContents.size() + "/" + contentsCount + " <" + uniqueContentsLength + "/" + symbolCount + ">";
            }
            String tableBaseInfo = file.getName() + " (" + tables.size() + ") -> : [" + String.format("%.4f", reuseFactor) + contentsReuseInfo + "] ";
            System.out.println(num + " -- " + tableBaseInfo + StringUtil.join(tables, (Function)tablePrinter, (String)", "));
            Collections.sort(tables, (o1, o2) -> Comparing.compare((int)o2.getUsageCount(), (int)o1.getUsageCount()));
            System.out.println(num + "    " + tableBaseInfo + StringUtil.join(tables, (Function)tablePrinter, (String)", "));
        }
        System.out.println("============================");
        System.out.println("multitable files: " + multiTableFiles + " / " + totalFiles + " (" + (double)multiTableFiles / (double)totalFiles + ")");
        System.out.println("reusedSym/totalSym = " + totalUniqueSymbols + "/" + totalSymbols);
        System.out.println("uniqueTables/totalTables = " + totalUniqueContents + "/" + totalContents);
        System.out.println("uniqueTablesSize/totalTablesSize = " + totalUniqueContentsLen + "/" + totalSymbols);
    }

    static {
        ourSymbolsProperties = DEFAULT_SYMBOLS_PROPERTIES = ApplicationManager.getApplication().isUnitTestMode() ? SymbolsProperties.NO_SYMBOLS : null;
    }

    private static class Delta {
        final int start;
        final int shift;

        private Delta(int start, int shift) {
            this.start = start;
            this.shift = shift;
        }
    }

    class PeriodicSerializationTask
    implements Runnable {
        public static final int IDLE_PERIOD = 20000;
        public static final int POLL_PERIOD = 10000;
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

        PeriodicSerializationTask() {
        }

        @Override
        public void run() {
            if (this.shouldStop()) {
                return;
            }
            if (!this.shouldSerialize()) {
                this.schedule(10000);
                return;
            }
            String projectHash = FileSymbolTablesCache.this.myProject.getLocationHash();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.serializeInBackground(projectHash);
                }
                finally {
                    this.schedule(10000);
                }
            });
        }

        private void serializeInBackground(@NotNull String projectHash) {
            ProgressIndicatorBase indicator = new ProgressIndicatorBase();
            indicator.setIndeterminate(false);
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                if (this.shouldStop() || !this.shouldSerialize()) {
                    return;
                }
                ArrayList<VirtualFile> fs = new ArrayList<VirtualFile>();
                for (VirtualFile file : FileSymbolTablesCache.this.myCache.keySet()) {
                    ProgressManager.checkCanceled();
                    FileSymbolTablesPack pack = (FileSymbolTablesPack)FileSymbolTablesCache.this.myCache.get(file);
                    if (pack == null || !pack.shouldSerialize()) continue;
                    fs.add(file);
                }
                if (!fs.isEmpty()) {
                    FileSymbolTablesCache.this.serializeTables(projectHash, fs, (ProgressIndicator)indicator);
                }
            }, (ProgressIndicator)indicator);
        }

        private boolean shouldStop() {
            return !FileSymbolTablesCache.this.myProject.isOpen() || FileSymbolTablesCache.this.myProject.isDisposed();
        }

        private boolean shouldSerialize() {
            return FileSymbolTablesCache.isSerializationEnabled() && !PowerSaveMode.isEnabled() && !DumbService.isDumb((Project)FileSymbolTablesCache.this.myProject) && ApplicationManager.getApplication().getIdleTime() >= 20000L && FileSymbolTablesCache.this.isUpToDate();
        }

        public void schedule(int delayMillis) {
            this.cancelAll();
            this.myAlarm.addRequest((Runnable)this, delayMillis);
        }

        public void cancelAll() {
            this.myAlarm.cancelAllRequests();
        }
    }

    public static final class SymbolsProperties {
        public static final SymbolsProperties NO_SYMBOLS = new SymbolsProperties(SymbolsKind.NO_SYMBOLS, false, false);
        @NotNull
        private final SymbolsKind buildSymbolsKind;
        private final boolean deserializeSymbolTables;
        private final boolean serializeSymbolTables;

        public SymbolsProperties(@NotNull SymbolsKind buildSymbolKind, boolean deserializeSymbolTables, boolean serializeSymbolTables) {
            this.buildSymbolsKind = buildSymbolKind;
            this.deserializeSymbolTables = deserializeSymbolTables;
            this.serializeSymbolTables = serializeSymbolTables;
        }

        public static enum SymbolsKind {
            NO_SYMBOLS,
            ONLY_USED,
            ALL_INCLUDING_UNUSED_SYSTEM_HEADERS;

        }
    }

    private class OCCodeBlockModificationListener
    implements PsiTreeChangePreprocessor {
        private final Key<String> FILE_PREPROCESSOR_STAMP = Key.create((String)"FILE_PREPROCESSOR_STAMP");

        private OCCodeBlockModificationListener() {
        }

        public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
            String stamp;
            PsiFile file = this.getFile(event);
            if (!SymbolTableProvider.isSourceFile(file)) {
                return;
            }
            Delta delta = this.processChange(event, file);
            if (delta != null && delta.shift != 0) {
                this.validate(file, delta.start, delta.shift);
            }
            if (event.isGenericChange() && (stamp = (String)file.getUserData(this.FILE_PREPROCESSOR_STAMP)) != null) {
                if (!stamp.equals(this.macroStamp(file))) {
                    FileSymbolTablesCache.this.handleOutOfCodeBlockChange(file, true);
                }
                file.putUserData(this.FILE_PREPROCESSOR_STAMP, null);
            }
        }

        @Nullable
        private Delta processChange(@NotNull PsiTreeChangeEventImpl event, PsiFile file) {
            switch (event.getCode()) {
                case BEFORE_CHILDREN_CHANGE: 
                case BEFORE_CHILD_REPLACEMENT: 
                case BEFORE_CHILD_ADDITION: 
                case BEFORE_CHILD_REMOVAL: {
                    this.processBeforeChange(event, file);
                    return null;
                }
                case BEFORE_CHILD_MOVEMENT: {
                    return null;
                }
                case CHILD_ADDED: 
                case CHILD_REMOVED: 
                case CHILD_REPLACED: 
                case CHILDREN_CHANGED: {
                    return this.processChildChange(event, file);
                }
                case CHILD_MOVED: 
                case BEFORE_PROPERTY_CHANGE: 
                case PROPERTY_CHANGED: {
                    FileSymbolTablesCache.this.incOutOfCodeBlockTrackers(file);
                    return null;
                }
            }
            LOG.error("Unknown code:" + event.getCode());
            return null;
        }

        @Nullable
        private PsiFile getFile(@NotNull PsiTreeChangeEventImpl event) {
            PsiFile childFile;
            PsiFile file = event.getFile();
            if (file != null) {
                return file;
            }
            PsiElement child = event.getChild();
            PsiFile psiFile = childFile = child != null ? child.getContainingFile() : null;
            if (childFile != null) {
                return childFile;
            }
            PsiElement parent = event.getParent();
            return parent != null ? parent.getContainingFile() : null;
        }

        @Nullable
        private Delta processChildChange(@NotNull PsiTreeChangeEventImpl event, @NotNull PsiFile file) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (event.isGenericChange()) {
                return null;
            }
            if (this.isOutOfCodeBlockChange(event, file)) {
                FileSymbolTablesCache.this.handleOutOfCodeBlockChange(file, false);
            }
            PsiElement child = event.getChild();
            PsiElement parent = event.getParent();
            int offset = event.getOffset();
            switch (event.getCode()) {
                case CHILD_ADDED: {
                    assert (child != null);
                    if (this.checkInvalid((PsiTreeChangeEvent)event, child)) {
                        return null;
                    }
                    return new Delta(offset, child.getTextLength());
                }
                case CHILD_REMOVED: {
                    return new Delta(offset, -event.getOldLength());
                }
                case CHILD_REPLACED: {
                    assert (child != null);
                    if (this.checkInvalid((PsiTreeChangeEvent)event, child)) {
                        return null;
                    }
                    return new Delta(offset, child.getTextLength() - event.getOldLength());
                }
                case CHILDREN_CHANGED: {
                    assert (parent != null);
                    return new Delta(offset, parent.getTextLength() - event.getOldLength());
                }
            }
            OCLog.LOG.error("unexpected event code: " + event.getCode());
            return null;
        }

        private boolean checkInvalid(@NotNull PsiTreeChangeEvent event, @NotNull PsiElement psi) {
            if (!psi.isValid()) {
                LOG.warn("Invalid PSI in OCCodeBlockModificationListener.treeChanged: " + psi + ", event: " + event);
                return true;
            }
            return false;
        }

        private void processBeforeChange(@NotNull PsiTreeChangeEventImpl event, PsiFile file) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (event.getCode() == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE && event.getParent() instanceof PsiFile) {
                return;
            }
            boolean isFile = event.getChild() instanceof PsiFile;
            if (!isFile && !(file instanceof OCCodeFragment) && file.getUserData(this.FILE_PREPROCESSOR_STAMP) == null) {
                file.putUserData(this.FILE_PREPROCESSOR_STAMP, (Object)this.macroStamp(file));
            }
        }

        private boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl event, @Nullable PsiFile file) {
            if (file instanceof OCCodeFragment) {
                return false;
            }
            PsiElement element = event.getParent();
            if (element instanceof PsiFileSystemItem) {
                return true;
            }
            if (element == null || element.getParent() == null) {
                return false;
            }
            return SymbolTableProvider.getProvider(element.getContainingFile()).isOutOfCodeBlockChange(event);
        }

        @NotNull
        private String macroStamp(PsiFile file) {
            if (!(file instanceof OCFile)) {
                return "";
            }
            StringBuilder acc = new StringBuilder();
            this.processASTNodeForMacros((ASTNode)file.getNode(), acc);
            return acc.toString();
        }

        private void processASTNodeForMacros(@Nullable ASTNode node, @NotNull StringBuilder acc) {
            if (node == null) {
                return;
            }
            IElementType elementType = node.getElementType();
            if (OCElementTypes.IMPORTANT_DIRECTIVES.contains(elementType)) {
                acc.append(node.getText());
            }
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                this.processASTNodeForMacros(child, acc);
            }
        }

        private void validate(PsiFile file, int start, int lengthShift) {
            VirtualFile key = FileSymbolTablesCache.key(file);
            if (key != null) {
                FileSymbolTablesCache.this.packForFile(key).updateOffsetsSynchronized(start, lengthShift);
            }
        }
    }

    private final class ClearTablesAndCollectNamesVisitor
    extends VirtualFileVisitor {
        @NotNull
        final Set<String> dirtyNames;

        private ClearTablesAndCollectNamesVisitor() {
            super(new VirtualFileVisitor.Option[0]);
            this.dirtyNames = new SmartHashSet(FileUtil.PATH_HASHING_STRATEGY);
        }

        @Nullable
        public Collection<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
            return file.isDirectory() ? ((NewVirtualFile)file).getCachedChildren() : null;
        }

        public final boolean visitFile(@NotNull VirtualFile file) {
            if (file.isDirectory() || file.getFileType() != OCFileType.INSTANCE) {
                return true;
            }
            if (FileSymbolTablesCache.this.clearCache(file)) {
                FileSymbolTablesCache.this.addFileToCache(file);
            }
            this.dirtyNames.add(file.getName());
            return true;
        }
    }
}

