/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTablesPack {
    @NotNull
    private final ArrayList<FileSymbolTable> myTables = new ArrayList();
    @Nullable
    private transient Internary myInternary;
    private volatile transient boolean myIsChanged;
    private volatile transient boolean myShouldSerialize;
    private transient boolean myFallback;

    public boolean isEmpty() {
        return this.myTables.isEmpty();
    }

    public List<FileSymbolTable> tablesView() {
        return Collections.unmodifiableList(this.myTables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compactSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            this.myTables.trimToSize();
            for (FileSymbolTable table : this.myTables) {
                table.compact();
            }
            this.myInternary = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCompactSynchronized(@NotNull Project project2, @NotNull FileSymbolTable table) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            if (!this.myTables.isEmpty()) {
                if (this.myInternary == null) {
                    this.myInternary = new Internary();
                    for (FileSymbolTable t : this.myTables) {
                        this.myInternary.internBatch((Consumer<Function<OCSymbol, OCSymbol>>)((Consumer)i -> {
                            for (OCSymbol symbol : t.getContents()) {
                                i.fun((Object)symbol);
                            }
                        }));
                    }
                }
                Ref internedCount = new Ref();
                this.myInternary.internBatch((Consumer<Function<OCSymbol, OCSymbol>>)((Consumer)i -> internedCount.set((Object)table.internSymbols((UserDataHolder)project2, (Function<? super OCSymbol, ? extends OCSymbol>)i))));
                if (table.getContents().size() == ((Integer)internedCount.get()).intValue()) {
                    for (FileSymbolTable t : this.myTables) {
                        if (table.tryReuseContents(t)) break;
                    }
                }
            }
            if (!table.isFallback()) {
                this.myFallback = false;
            }
            this.addTableInternal(table);
            table.incUsageCount();
            FileSymbolTablesPack.addToImportGraph(project2, table);
        }
    }

    private void addTableInternal(@NotNull FileSymbolTable table) {
        this.setChanged();
        this.myTables.add(table);
        table.setPackStamp(this.getTimeStamp());
    }

    private void setChanged() {
        this.myIsChanged = true;
        this.myShouldSerialize = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSerialized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            this.myShouldSerialize = false;
        }
    }

    public boolean shouldSerialize() {
        return this.myShouldSerialize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJunkTables(@NotNull Project project2, boolean includingUnused) {
        Condition shouldRemove = table -> table.isFallback() || includingUnused && table.getUsageCount() == 0;
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            boolean hasJunkTables = false;
            for (FileSymbolTable table2 : this.myTables) {
                if (!shouldRemove.value((Object)table2)) continue;
                hasJunkTables = true;
                break;
            }
            if (hasJunkTables) {
                this.setChanged();
                this.myInternary = null;
                FileSymbolTable[] oldTables = this.myTables.toArray(FileSymbolTable.EMPTY_ARRAY);
                this.myTables.clear();
                for (FileSymbolTable table3 : oldTables) {
                    if (shouldRemove.value((Object)table3)) {
                        FileSymbolTablesPack.onTableRemove(project2, table3);
                        continue;
                    }
                    this.addTableInternal(table3);
                }
            }
        }
    }

    public boolean isChanged() {
        return this.myIsChanged;
    }

    private int getTimeStamp() {
        return this.myTables.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsFallback() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            this.setChanged();
            this.myFallback = true;
            for (FileSymbolTable table : this.myTables) {
                table.setFallback(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFallback() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            return this.myFallback;
        }
    }

    private static void addToImportGraph(@NotNull Project project2, @NotNull FileSymbolTable table) {
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(project2);
        ModuleMapResolveService moduleMapResolveService = ModuleMapResolveService.getInstance(project2);
        table.processIncludes((Processor<? super OCSymbol>)((Processor)symbol -> {
            ModuleMapModuleSymbol module2;
            if (symbol instanceof OCIncludeSymbol) {
                VirtualFile header = ((OCIncludeSymbol)symbol).getTargetFile();
                if (header != null && header.isValid()) {
                    OCImportGraph.addHeaderIncluder(project2, header, table.getContainingFile());
                }
            } else if (symbol instanceof OCModuleImportSymbol && (module2 = moduleMapManager.findModule(symbol.getName(), null)) != null) {
                for (VirtualFile header : moduleMapResolveService.getIncludeHeaders(module2, null)) {
                    if (!header.isValid()) continue;
                    OCImportGraph.addHeaderIncluder(project2, header, table.getContainingFile());
                }
            }
            return true;
        }));
    }

    private static void removeFromImportGraph(@NotNull Project project2, @NotNull FileSymbolTable table) {
        ModuleMapManager moduleMapManager = ModuleMapManager.getInstance(project2);
        ModuleMapResolveService moduleMapResolveService = ModuleMapResolveService.getInstance(project2);
        table.processIncludes((Processor<? super OCSymbol>)((Processor)symbol -> {
            ModuleMapModuleSymbol module2;
            if (symbol instanceof OCIncludeSymbol) {
                VirtualFile header = ((OCIncludeSymbol)symbol).getTargetFile();
                if (header != null) {
                    OCImportGraph.removeHeaderIncluder(project2, header, table.getContainingFile());
                }
            } else if (symbol instanceof OCModuleImportSymbol && (module2 = moduleMapManager.findModule(symbol.getName(), null)) != null) {
                for (VirtualFile header : moduleMapResolveService.getIncludeHeaders(module2, null)) {
                    if (!header.isValid()) continue;
                    OCImportGraph.removeHeaderIncluder(project2, header, table.getContainingFile());
                }
            }
            return true;
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onThaw(@NotNull Project project2) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                FileSymbolTablesPack.addToImportGraph(project2, table);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemove(@NotNull Project project2) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                FileSymbolTablesPack.onTableRemove(project2, table);
            }
        }
    }

    private static void onTableRemove(@NotNull Project project2, FileSymbolTable table) {
        FileSymbolTablesPack.removeFromImportGraph(project2, table);
        table.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<FileSymbolTable> getTablesSynchronized() {
        FileSymbolTable[] tables;
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            tables = this.myTables.toArray(FileSymbolTable.EMPTY_ARRAY);
        }
        return Arrays.asList(tables);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTablesCountSynchronized() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            return this.myTables.size();
        }
    }

    @NotNull
    public Object getTablesAccessLock() {
        return this.myTables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOffsetsSynchronized(int start, int lengthShift) {
        THashSet processed = new THashSet(ContainerUtil.identityStrategy());
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                table.updateOffsets(start, lengthShift, (THashSet<OCSymbol>)processed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileSymbolTable findConformingTable(@NotNull OCInclusionContext context, int sinceTimeStamp, @Nullable Ref<Integer> outCurrentTimeStamp) {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            int timeStamp = this.getTimeStamp();
            if (outCurrentTimeStamp != null) {
                outCurrentTimeStamp.set((Object)timeStamp);
            }
            if (timeStamp > sinceTimeStamp) {
                for (int i = 0; i < this.myTables.size(); ++i) {
                    FileSymbolTable table = this.myTables.get(i);
                    if (table.getPackStamp() <= sinceTimeStamp || !context.checkConformanceAndFillSignatures(table)) continue;
                    int usingCount = table.incUsageCount();
                    if (usingCount < 0) {
                        for (FileSymbolTable t : this.myTables) {
                            t.resetUsageCount();
                        }
                    } else {
                        for (int prev = i - 1; prev >= 0 && this.myTables.get(prev).getUsageCount() + 2 < usingCount; --prev) {
                            Collections.swap(this.myTables, prev, prev + 1);
                        }
                    }
                    table.setFallback(false);
                    this.myFallback = false;
                    return table;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUsedTables() {
        Object object = this.getTablesAccessLock();
        synchronized (object) {
            for (FileSymbolTable table : this.myTables) {
                if (table.getUsageCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private static class Internary {
        private DeepEqual.Resolver myEqualityResolver;
        @NotNull
        private final THashMap<OCSymbol, OCSymbol> mySymbols = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<OCSymbol>(){

            public int computeHashCode(OCSymbol object) {
                return object.hashCodeExcludingOffset();
            }

            public boolean equals(OCSymbol o1, OCSymbol o2) {
                ProgressManager.checkCanceled();
                return myEqualityResolver.equalObjects(o1, o2);
            }
        });

        private Internary() {
        }

        public void internBatch(@NotNull Consumer<Function<OCSymbol, OCSymbol>> action) {
            this.myEqualityResolver = DeepEqual.newResolver();
            try {
                action.consume(symbol -> {
                    OCSymbol same = (OCSymbol)this.mySymbols.get(symbol);
                    if (same != null) {
                        return same;
                    }
                    this.mySymbols.put(symbol, symbol);
                    return symbol;
                });
            }
            finally {
                this.myEqualityResolver = null;
            }
        }
    }
}

