/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.Iterator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MetaData {
    @NotNull
    private final LinkedHashMap<String, String> locationHashesWithPaths = new LinkedHashMap();
    private transient boolean isFileUpToDate;

    MetaData() {
    }

    boolean isFileUpToDate() {
        return this.isFileUpToDate;
    }

    void setFileUpToDate(boolean fileUpToDate) {
        this.isFileUpToDate = fileUpToDate;
    }

    @Nullable
    String getMostRecentLocationHash() {
        return (String)this.locationHashesWithPaths.getLastKey();
    }

    void registerProject(@NotNull String locationHash, @NotNull String path) {
        this.locationHashesWithPaths.remove((Object)locationHash);
        this.locationHashesWithPaths.put((Object)locationHash, (Object)path);
    }

    <E extends Throwable> boolean evictProjects(@NotNull ProjectEvictionPolicy<E> evictionPolicy) throws E {
        boolean metaDataChanged = false;
        Iterator iterator2 = this.locationHashesWithPaths.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator2.next();
            if (!evictionPolicy.evictProject((String)entry.getKey(), (String)entry.getValue())) continue;
            iterator2.remove();
            metaDataChanged = true;
        }
        return metaDataChanged;
    }

    @FunctionalInterface
    static interface ProjectEvictionPolicy<E extends Throwable> {
        public boolean evictProject(@NotNull String var1, @NotNull String var2) throws E;
    }
}

