/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCContextSignatureBuilder
implements OCInclusionContext.SignatureBuilder {
    private final THashSet<String> myDefined = new THashSet();
    private final THashSet<String> myNotDefined = new THashSet();
    private final THashMap<String, Integer> myDefinitions = new THashMap();
    @Nullable
    public final OCLanguageKind languageKind;
    @NotNull
    private final List<String> myNamespace;
    private final boolean myIsSurrogate;
    private boolean myInConformMode;

    public OCContextSignatureBuilder(@Nullable OCLanguageKind kind, @NotNull List<String> namespace, boolean isSurrogate) {
        this.languageKind = kind;
        this.myNamespace = namespace;
        this.myIsSurrogate = isSurrogate;
    }

    @Override
    public void setDefined(@NotNull String name2, boolean isDefined) {
        if (this.myInConformMode) {
            throw new IllegalStateException("Cannot set definition when checking conformance");
        }
        String intName = OCNamesInternary.intern(name2);
        if (isDefined) {
            this.myDefined.add((Object)intName);
        } else {
            this.myNotDefined.add((Object)intName);
        }
    }

    @Override
    public void setDefinition(@NotNull String name2, @NotNull OCMacroSymbol result) {
        if (this.myInConformMode) {
            throw new IllegalStateException("Cannot set definition when checking conformance");
        }
        String intName = OCNamesInternary.intern(name2);
        int substHash = result.getSubstitutionHash();
        this.myDefinitions.put((Object)intName, (Object)substHash);
    }

    @Override
    public void enterConformanceCheckMode() {
        this.myInConformMode = true;
    }

    @Override
    public void exitConformanceCheckMode(boolean commit2) {
        this.myInConformMode = false;
    }

    @NotNull
    public ContextSignature build() {
        for (String d : this.myDefined) {
            if (this.myDefinitions.containsKey((Object)d)) continue;
            this.myDefinitions.put((Object)d, null);
        }
        this.myDefined.clear();
        return new ContextSignature(this.languageKind, (Map<String, Integer>)this.myDefinitions, (Set<String>)this.myNotDefined, this.myNamespace, this.myIsSurrogate);
    }
}

