/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapResolveService;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapModuleSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCModuleImportSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.CallerAwareJob;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountedCompleter;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

final class OCGlobalProjectSymbolsBuilder
extends CallerAwareJob<Void> {
    @NotNull
    final MyConcurrentMostlySingularMultiMap<OCClassSymbol> myCategoryToClass = OCGlobalProjectSymbolsBuilder.createConcurrentMap();
    @NotNull
    final MyConcurrentMostlySingularMultiMap<OCSymbol> myTopLevelSymbols = OCGlobalProjectSymbolsBuilder.createConcurrentMap();
    @NotNull
    final MyConcurrentMostlySingularMultiMap<OCSymbol> myMemberSymbols = OCGlobalProjectSymbolsBuilder.createConcurrentMap();
    @NotNull
    final MyConcurrentMostlySingularMultiMap<OCSymbol> myCppMemberSymbols = OCGlobalProjectSymbolsBuilder.createConcurrentMap();
    @NotNull
    final MyConcurrentMostlySingularMultiMap<String> myTypeAliases = OCGlobalProjectSymbolsBuilder.createConcurrentMap();
    @NotNull
    private final Set<OCClassSymbol> myCategoryToClassAllValues = ConcurrentCollectionFactory.createConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    @NotNull
    private final Set<OCSymbol> myTopLevelSymbolsAllValues = ConcurrentCollectionFactory.createConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    @NotNull
    private final Set<OCSymbol> myMemberSymbolsAllValues = ConcurrentCollectionFactory.createConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    @NotNull
    private final Set<OCSymbol> myCppMemberSymbolsAllValues = ConcurrentCollectionFactory.createConcurrentSet((TObjectHashingStrategy)ContainerUtil.identityStrategy());
    @NotNull
    private final Set<String> myTypeAliasesAllValues = ContainerUtil.newConcurrentSet();
    @NotNull
    private final FileSymbolTablesCache cache;
    @NotNull
    private final ModuleMapManager moduleMapManager;
    @NotNull
    private final ModuleMapResolveService moduleMapResolveService;
    @NotNull
    private final Set<VirtualFile> processed = ContainerUtil.newConcurrentSet();
    @NotNull
    private final Set<String> processedModules = ContainerUtil.newConcurrentSet();

    OCGlobalProjectSymbolsBuilder(@NotNull Project project2, int estimatedWorksetSize) {
        super(estimatedWorksetSize);
        this.cache = FileSymbolTablesCache.getInstance(project2);
        this.moduleMapManager = ModuleMapManager.getInstance(project2);
        this.moduleMapResolveService = ModuleMapResolveService.getInstance(project2);
    }

    void build(@NotNull Set<VirtualFile> workset) {
        this.processed.addAll(workset);
        this.run(new FileWorker(null, ImmutableList.copyOf(workset)));
    }

    private void addSymbol(@NotNull OCSymbol symbol) {
        String name2 = symbol.getName();
        if (OCSymbolWithQualifiedName.isWithoutQualifier(symbol) ? !OCGlobalProjectSymbolsBuilder.addIfAbsent(this.myTopLevelSymbols, this.myTopLevelSymbolsAllValues, name2, symbol) : !OCGlobalProjectSymbolsBuilder.addIfAbsent(this.myCppMemberSymbols, this.myCppMemberSymbolsAllValues, name2, symbol)) {
            return;
        }
        if (symbol instanceof OCClassSymbol) {
            OCClassSymbol classSymbol = (OCClassSymbol)symbol;
            String categoryName = classSymbol.getCategoryName();
            if (categoryName != null && !OCGlobalProjectSymbolsBuilder.addIfAbsent(this.myCategoryToClass, this.myCategoryToClassAllValues, categoryName, classSymbol)) {
                return;
            }
            classSymbol.processMembers(OCMemberSymbol.class, ocMemberSymbol -> {
                ProgressManager.checkCanceled();
                OCGlobalProjectSymbolsBuilder.addIfAbsent(this.myMemberSymbols, this.myMemberSymbolsAllValues, ocMemberSymbol.getName(), ocMemberSymbol);
                return true;
            });
        } else if (symbol instanceof OCNamespaceSymbol) {
            ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<? super OCSymbol>)new Processor<OCSymbol>(){

                public boolean process(OCSymbol ocSymbol) {
                    boolean isMember;
                    ProgressManager.checkCanceled();
                    boolean bl = isMember = !(ocSymbol instanceof OCSymbolWithQualifiedName) || ((OCSymbolWithQualifiedName)ocSymbol).getQualifierParent() != null;
                    if (isMember && !OCGlobalProjectSymbolsBuilder.addIfAbsent(OCGlobalProjectSymbolsBuilder.this.myCppMemberSymbols, OCGlobalProjectSymbolsBuilder.this.myCppMemberSymbolsAllValues, ocSymbol.getName(), ocSymbol)) {
                        return true;
                    }
                    if (ocSymbol instanceof OCNamespaceSymbol) {
                        ((OCNamespaceSymbol)ocSymbol).processMembers((String)null, this);
                    }
                    return true;
                }
            });
        } else if (symbol.getKind().isTypedefOrAlias()) {
            String refName = symbol.getType().getName();
            OCGlobalProjectSymbolsBuilder.addIfAbsent(this.myTypeAliases, this.myTypeAliasesAllValues, refName, symbol.getName());
        }
    }

    private static <K, V> boolean addIfAbsent(@NotNull MostlySingularMultiMap<K, V> map2, @NotNull Set<V> allValues, @NotNull K key, @NotNull V value) {
        if (allValues.add(value)) {
            map2.add(key, value);
            return true;
        }
        return false;
    }

    @NotNull
    private static <T> MyConcurrentMostlySingularMultiMap<T> createConcurrentMap() {
        return new MyConcurrentMostlySingularMultiMap();
    }

    private static final class MyCompactMostlySingularMultiMap<T>
    extends MostlySingularMultiMap<String, T> {
        private MyCompactMostlySingularMultiMap(@NotNull Map<String, Object> map2) {
            ((THashMap)this.myMap).ensureCapacity(map2.size());
            map2.forEach((key, value) -> {
                if (value instanceof MostlySingularMultiMap.ValueList) {
                    ((MostlySingularMultiMap.ValueList)value).trimToSize();
                }
                this.myMap.put(key, value);
            });
        }
    }

    static final class MyConcurrentMostlySingularMultiMap<T>
    extends MostlySingularMultiMap<String, T>
    implements BiFunction<Object, Object, Object> {
        MyConcurrentMostlySingularMultiMap() {
        }

        @NotNull
        protected ConcurrentMap<String, Object> createMap() {
            return ContainerUtil.newConcurrentMap();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(@NotNull String key, @NotNull T value) {
            MostlySingularMultiMap.ValueList newList;
            Object newValue = this.myMap.merge(key, value, this);
            if (newValue == value) {
                return;
            }
            MostlySingularMultiMap.ValueList valueList = newList = (MostlySingularMultiMap.ValueList)newValue;
            synchronized (valueList) {
                newList.add(value);
            }
        }

        @Override
        public Object apply(Object current, Object value) {
            if (current instanceof MostlySingularMultiMap.ValueList) {
                return current;
            }
            MostlySingularMultiMap.ValueList newList = new MostlySingularMultiMap.ValueList();
            newList.add(current);
            return newList;
        }

        @NotNull
        MostlySingularMultiMap<String, T> createCompacted() {
            if (this.isEmpty()) {
                return MyConcurrentMostlySingularMultiMap.emptyMap();
            }
            return new MyCompactMostlySingularMultiMap(this.myMap);
        }
    }

    private final class ModuleWorker
    extends CountedCompleter<Void> {
        @NotNull
        private final List<String> workset;

        private ModuleWorker(@NotNull CountedCompleter parent, List<String> workset) {
            super(parent);
            this.workset = workset;
        }

        @Override
        public void compute() {
            ImmutableList.Builder additionalFiles = ImmutableList.builder();
            for (String moduleName : this.workset) {
                ModuleMapModuleSymbol module2 = (ModuleMapModuleSymbol)ReadAction.compute(() -> OCGlobalProjectSymbolsBuilder.this.moduleMapManager.findModule(moduleName, null));
                if (module2 == null) continue;
                for (VirtualFile header : OCGlobalProjectSymbolsBuilder.this.moduleMapResolveService.getIncludeHeaders(module2, null)) {
                    if (!OCGlobalProjectSymbolsBuilder.this.processed.add(header)) continue;
                    additionalFiles.add((Object)header);
                }
            }
            ImmutableList additionalWorkset = additionalFiles.build();
            if (!additionalWorkset.isEmpty()) {
                OCGlobalProjectSymbolsBuilder.this.forkAsPending(this, new FileWorker(this, additionalWorkset));
            }
            this.propagateCompletion();
        }
    }

    private final class FileWorker
    extends CallerAwareJob.IterativeWorker<VirtualFile> {
        @NotNull
        private final List<String> additionalModulesWorkset;

        private FileWorker(@NotNull CountedCompleter parent, ImmutableList<? extends VirtualFile> workset) {
            super(parent, workset);
            this.additionalModulesWorkset = new ArrayList<String>();
        }

        @NotNull
        protected FileWorker newWorker(@NotNull ImmutableList<? extends VirtualFile> workset) {
            return new FileWorker((CountedCompleter)this, workset);
        }

        @Override
        @NotNull
        protected ImmutableList<? extends VirtualFile> process(@NotNull ImmutableList<? extends VirtualFile> workset) {
            ImmutableList.Builder additionalWorkset = ImmutableList.builder();
            for (VirtualFile currentFile : workset) {
                ProgressManager.checkCanceled();
                for (FileSymbolTable table : OCGlobalProjectSymbolsBuilder.this.cache.allTablesForFile(currentFile)) {
                    for (OCSymbol content : table.getContents()) {
                        OCSymbol symbol = content.getDelegate();
                        if (symbol instanceof OCIncludeSymbol) {
                            VirtualFile targetFile = ((OCIncludeSymbol)symbol).getTargetFile();
                            if (targetFile == null || !OCGlobalProjectSymbolsBuilder.this.processed.add(targetFile)) continue;
                            additionalWorkset.add((Object)targetFile);
                            continue;
                        }
                        if (symbol instanceof OCModuleImportSymbol) {
                            String moduleName = symbol.getName();
                            if (!OCGlobalProjectSymbolsBuilder.this.processedModules.add(moduleName)) continue;
                            this.additionalModulesWorkset.add(moduleName);
                            continue;
                        }
                        OCGlobalProjectSymbolsBuilder.this.addSymbol(symbol);
                    }
                }
            }
            return additionalWorkset.build();
        }

        @Override
        protected void processingFinished() {
            if (!this.additionalModulesWorkset.isEmpty()) {
                OCGlobalProjectSymbolsBuilder.this.scheduleOnCallerAsPending(this, new ModuleWorker(this, this.additionalModulesWorkset));
            }
            this.propagateCompletion();
        }
    }
}

