/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.intellij.util.containers.MostlySingularMultiMap;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.AbstractGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsBuilder;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGlobalProjectSymbolsCache
extends AbstractGlobalProjectSymbolsCache<OCSymbol, OCSymbols> {
    protected OCGlobalProjectSymbolsCache(@NotNull Project project2) {
        super(OCGlobalProjectSymbolsCache.class, project2);
    }

    @Override
    @NotNull
    protected OCSymbols buildGlobalSymbols(@NotNull Project project2) {
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project2);
        Set files = (Set)ReadAction.compute(cache::getFilesToBuildTablesFor);
        if (files.isEmpty()) {
            return new OCSymbols();
        }
        OCGlobalProjectSymbolsBuilder builder = new OCGlobalProjectSymbolsBuilder(project2, 3 * files.size());
        builder.build(files);
        return new OCSymbols(builder.myCategoryToClass.createCompacted(), builder.myTopLevelSymbols.createCompacted(), builder.myMemberSymbols.createCompacted(), builder.myCppMemberSymbols.createCompacted(), builder.myTypeAliases.createCompacted());
    }

    @NotNull
    public static OCGlobalProjectSymbolsCache getInstance(@NotNull Project project2) {
        return (OCGlobalProjectSymbolsCache)project2.getComponent(OCGlobalProjectSymbolsCache.class);
    }

    @Nullable
    public static OCSymbol findNearestTopLevelSymbol(@NotNull Project project2, @Nullable String name2, @Nullable Condition<? super OCSymbol> condition, @Nullable VirtualFile contextFile) {
        return OCGlobalProjectSymbolsCache.findNearestTopLevelSymbol(OCGlobalProjectSymbolsCache.class, project2, name2, condition, contextFile);
    }

    public static boolean processTopLevelSymbols(@NotNull Project project2, @NotNull Processor<? super OCSymbol> processor2, @Nullable String name2) {
        return OCGlobalProjectSymbolsCache.processTopLevelSymbols(OCGlobalProjectSymbolsCache.class, project2, processor2, name2);
    }

    public static boolean processTopLevelAndMemberSymbols(@NotNull Project project2, @NotNull Processor<? super OCSymbol> processor2, @Nullable String name2) {
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCGlobalProjectSymbolsCache.class, project2, processor2, name2);
    }

    public static boolean processByQualifiedName(@NotNull Project project2, @NotNull Processor<? super OCSymbol> processor2, @NotNull String name2) {
        return OCGlobalProjectSymbolsCache.processByQualifiedName(OCGlobalProjectSymbolsCache.class, project2, processor2, name2);
    }

    public static boolean processAliasNamesForType(@NotNull Project project2, @NotNull String name2, @NotNull Processor<String> processor2) {
        return OCGlobalProjectSymbolsCache.processAliasNamesForType(OCGlobalProjectSymbolsCache.class, project2, name2, processor2);
    }

    public static boolean processTopLevelAndMemberSymbols(@NotNull Project project2, @NotNull Processor<? super OCSymbol> processor2, @Nullable String name2, boolean topLevelOnly) {
        return OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCGlobalProjectSymbolsCache.class, project2, processor2, name2, topLevelOnly);
    }

    @NotNull
    public static Set<String> getAllSymbolNames(@NotNull Project project2) {
        return OCGlobalProjectSymbolsCache.getAllSymbolNames(OCGlobalProjectSymbolsCache.class, project2);
    }

    public static MostlySingularMultiMap<String, OCSymbol> getCppMemberSymbols(@NotNull Project project2) {
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project2).getGlobalSymbols()).myCppMemberSymbols;
    }

    public static boolean processSymbolsByCategory(@NotNull Project project2, @NotNull Processor<? super OCSymbol> processor2, @Nullable String name2) {
        FileSymbolTablesCache.getInstance(project2).ensurePendingFilesProcessed();
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project2).getGlobalSymbols()).processSymbolsByCategory(processor2, name2);
    }

    @NotNull
    public static MostlySingularMultiMap<String, OCClassSymbol> getAllCategories(@NotNull Project project2) {
        return ((OCSymbols)OCGlobalProjectSymbolsCache.getInstance(project2).getGlobalSymbols()).getAllNamesWithCategories();
    }

    static class OCSymbols
    implements AbstractGlobalProjectSymbolsCache.Symbols<OCSymbol> {
        @NotNull
        private final MostlySingularMultiMap<String, OCClassSymbol> myCategoryToClass;
        @NotNull
        private final MostlySingularMultiMap<String, OCSymbol> myTopLevelSymbols;
        @NotNull
        private final MostlySingularMultiMap<String, OCSymbol> myMemberSymbols;
        @NotNull
        private final MostlySingularMultiMap<String, OCSymbol> myCppMemberSymbols;
        @NotNull
        private final MostlySingularMultiMap<String, String> myTypeAliases;

        private OCSymbols() {
            this((MostlySingularMultiMap<String, OCClassSymbol>)MostlySingularMultiMap.emptyMap(), (MostlySingularMultiMap<String, OCSymbol>)MostlySingularMultiMap.emptyMap(), (MostlySingularMultiMap<String, OCSymbol>)MostlySingularMultiMap.emptyMap(), (MostlySingularMultiMap<String, OCSymbol>)MostlySingularMultiMap.emptyMap(), (MostlySingularMultiMap<String, String>)MostlySingularMultiMap.emptyMap());
        }

        private OCSymbols(@NotNull MostlySingularMultiMap<String, OCClassSymbol> categoryToClass, @NotNull MostlySingularMultiMap<String, OCSymbol> topLevelSymbols, @NotNull MostlySingularMultiMap<String, OCSymbol> memberSymbols, @NotNull MostlySingularMultiMap<String, OCSymbol> cppMemberSymbols, @NotNull MostlySingularMultiMap<String, String> typeAliases) {
            this.myCategoryToClass = categoryToClass;
            this.myTopLevelSymbols = topLevelSymbols;
            this.myMemberSymbols = memberSymbols;
            this.myCppMemberSymbols = cppMemberSymbols;
            this.myTypeAliases = typeAliases;
        }

        @Override
        public boolean processAliasNamesForType(@NotNull String name2, @NotNull Processor<? super String> processor2) {
            return this.myTypeAliases.processForKey((Object)name2, processor2);
        }

        @Override
        public boolean processTopLevel(@NotNull Processor<? super OCSymbol> processor2, @Nullable String name2) {
            return OCResolveUtil.processMap(processor2, name2, this.myTopLevelSymbols);
        }

        public boolean processCppMemberSymbols(@NotNull Processor<? super OCSymbol> processor2, @Nullable String name2) {
            return OCResolveUtil.processMap(processor2, name2, this.myCppMemberSymbols);
        }

        @Override
        public boolean processAllSymbols(@NotNull Processor<? super OCSymbol> processor2, @Nullable String name2) {
            return OCResolveUtil.processMap(processor2, name2, this.myTopLevelSymbols) && OCResolveUtil.processMap(processor2, name2, this.myMemberSymbols) && OCResolveUtil.processMap(processor2, name2, this.myCppMemberSymbols);
        }

        public boolean processSymbolsByCategory(@NotNull Processor<? super OCSymbol> processor2, @Nullable String name2) {
            return OCResolveUtil.processMap(processor2, name2, this.myCategoryToClass);
        }

        @NotNull
        public MostlySingularMultiMap<String, OCClassSymbol> getAllNamesWithCategories() {
            return this.myCategoryToClass;
        }
    }
}

